<script type="text/javascript">
	$(function(){
		$('#tt').datagrid({  
			title:'该班级下的考生列表',
			striped:true,
			pagination:true,
			queryParams:{exam_id:$('#title').val()},
			remoteSort:true,
			sortName: 'id',
			sortOrder: 'asc',
			url:"<?php echo $this->createUrl('qq',array('classroom_id'=>$classroom_id)); ?>",  
			//idField:"id",
			//checkbox:false,
			fitColumns:true,
			toolbar:"#tb",			
			columns:[[  
				{field:'ck',checkbox:'true'}, 
				{field:'id',title:'ID',width:50,align:'center',sortable:true},  
				{field:'title',title:'考试名称',width:300,align:'center',sortable:true,editor:{type:'validatebox',options:{required:true}}}, 
				{field:'fullname',title:'姓名',width:100,align:'center',sortable:false,editor:{type:'validatebox',options:{required:true}}}, 
				{field:'starttime',title:'开始时间',width:150,align:'center',sortable:true,editor:{type:'validatebox',options:{required:true}}}, 
				{field:'submittime',title:'结束时间',width:150,align:'center',sortable:true,editor:{type:'validatebox',options:{required:true}}},
				{field:'remaintime',title:'剩余时间',width:150,align:'center',sortable:true,editor:{type:'validatebox',options:{required:true}}},
				{field:'submitmark',title:'交卷',width:50,align:'center',sortable:true,editor:{type:'validatebox',options:{required:true}}}, 
				{field:'cheatmark',title:'作弊',width:50,align:'center',sortable:true,editor:{type:'validatebox',options:{required:true}}},
				{field:'action',title:'动作',width:200,align:'center',
						formatter:function(value,row,index){
							if (row.editing){
								var s = '<a href="#" onclick="saverow('+index+')">保存</a> ';
								var c = '<a href="#" onclick="cancelrow('+index+')">取消</a>';
								return s+c;
							} else {
								var e = '<a href="#" onclick="overtime('+row.id+','+index+')">延长时间</a> ';
								var g = '<a href="#" onclick="replaceSubmit('+row.id+','+index+')">代交试卷</a> ';
								var d = '<a href="#" onclick="setCheat('+row.id+','+index+')">设为作弊</a> ';
								var f = '<a href="#" onclick="deleterow('+row.id+','+index+')">删除</a>';
								return e+g+d+f;
							}
						}
				}
			]],
            onSelect:function(index,row){
                $('#btnRemove').linkbutton('enable');
				$('#btnOn').linkbutton('enable');
				$('#btnOff').linkbutton('enable');
                },
			onUnselect:function(rowIndex, rowData){
				var rows = $('#tt').datagrid('getSelections');
				if(rows.length==0) {
					$('#btnRemove').linkbutton('disable');
					$('#btnOn').linkbutton('disable');
					$('#btnOff').linkbutton('disable');
				}
				},
            onSelectAll:function(index,row){
                $('#btnRemove').linkbutton('enable');
				$('#btnOn').linkbutton('enable');
				$('#btnOff').linkbutton('enable');
                },
            onUnselectAll:function(index,row){
                $('#btnRemove').linkbutton('disable');
				$('#btnOn').linkbutton('disable');
				$('#btnOff').linkbutton('disable');
                } 			
		}); 
	});
	function replaceSubmit(value,index){
		$.messager.confirm('确认','确定要代交试卷吗？',function(r){
			if (r){

					$.ajax({
						type: 'POST',
						url: '<?php echo $this->createUrl("replaceSubmit")?>',
						data: {id:value},
						success: function(data){if(data=="yes"){
						$.messager.alert('系统提示','代交成功!','info');
						//$('#tt').datagrid('deleteRow',index);
						$('#tt').datagrid('reload');
						//updateActions();
						//$("#tt").datagrid("acceptChanges");
					   }else $.messager.alert('系统提示','代交失败!'+'<br />'+data,'info');},
					  dataType: "text"
					});	

			}
		});
	}
	function setCheat(value,index)
	{
		$.messager.confirm('确认','确定要设为作弊吗？',function(r){
			if (r){

					$.ajax({
						type: 'POST',
						url: '<?php echo $this->createUrl("setCheat")?>',
						data: {id:value},
						success: function(data){if(data=="yes"){
						$.messager.alert('系统提示','设置成功!','info');
						//$('#tt').datagrid('deleteRow',index);
						$('#tt').datagrid('reload');
						//updateActions();
						//$("#tt").datagrid("acceptChanges");
					   }else $.messager.alert('系统提示','设置失败!'+'<br />'+data,'info');},
					  dataType: "text"
					});	

			}
		});
	}
	function overtime(value,index){
		//alert(value);
		//$('#ff').form('load',value);
		$('#w').window('open');
		//$('#ff').form('load','<?php echo $this->createUrl('editrow').'/id/';?>'+value);
		var url='<?php echo $this->createUrl('update').'/id/';?>'+value;
		$('#myform').html('<iframe scrolling="auto" frameborder="0" src="'+url+'" style="width:100%;height:100%;"></iframe>');
		//$('#tt').datagrid('beginEdit', index);
	}	
	function deleterow(value,index){
		$.messager.confirm('确认','确定要删除吗？',function(r){
			if (r){
				if(typeof(value)=='undefined'){
					$('#tt').datagrid('deleteRow',index);
				}else{
					$.ajax({
						type: 'POST',
						url: '<?php echo $this->createUrl("deleterow")?>',
						data: {id:value},
						success: function(data){if(data=="yes"){
						$.messager.alert('系统提示','删除成功!','info');
						$('#tt').datagrid('deleteRow',index);
						$('#tt').datagrid('reload');
						//updateActions();
						$("#tt").datagrid("acceptChanges");
					   }else $.messager.alert('系统提示','删除失败!'+'<br />'+data,'info');},
					  dataType: "text"
					});	
				}
			
			}
		});
	}

	
	function saverow(index){
		$('#tt').datagrid('endEdit', index);
	}
	function cancelrow(index){
		$('#tt').datagrid('cancelEdit', index);
	}
	function close1(){
		$('#w').window('close');
	}
	function open1(){
		$('#w').window('open');
	}
	$(function(){
		$("#w").window({
			//onClose:function(){$("#tt").datagrid("reload");}//这是查看图片，不需要更新datagrid
		});
	})
	function tt_add(){
		$('#w').window('open');
		var url='<?php echo $this->createUrl('create',array('classroom_id'=>$classroom_id));?>';
		$('#myform').html('<iframe scrolling="auto" frameborder="0" src="'+url+'" style="width:100%;height:100%;"></iframe>');
	}
	function tt_remove(){
		var rows = $('#tt').datagrid('getSelections');
		var uprow = [];
			for(var i=0;i<rows.length;i++){
				uprow.push(rows[i]);
			}
		//alert(JSON.stringify(uprow));
		
				$.messager.confirm('确认','确定要删除吗？',function(r){
				if (r){


						$.ajax({
							  type: 'POST',
							  url: '<?php echo $this->createUrl('deleteall')?>',
							  data: {action:'deleteall',qq:JSON.stringify(uprow)},
							  success: function(data){//alert(data);
								   //if(data=="yes"){
									$.messager.alert('系统提示',data,'info');
									$('#tt').datagrid('reload');
									$('#btnRemove').linkbutton('disable');
									$('#btnOn').linkbutton('disable');
									$('#btnOff').linkbutton('disable');
									//$('#btnSave').linkbutton('disable');
								   //}else $.messager.alert('系统提示','更新失败!','info');
							   
							   },
							  dataType: "text"
						});	

				
				}
			});
	}
function my_query(){
	/*去掉提示姓名为空
	if($.trim($("#fullname").val())==""){
		$.messager.alert('系统提示','请输入姓名!','info');
		$("#fullname").focus();
		return ;
	}
	*/
	var exam_id=$.trim($("#title").val());
	var fullname=$.trim($("#fullname").val());
	var queryParams = $('#tt').datagrid('options').queryParams; 
	queryParams.exam_id = exam_id;  
	queryParams.fullname = fullname;  
	$('#tt').datagrid('options').queryParams=queryParams;        
	$("#tt").datagrid('reload'); 
}	
function display_all(){
	$('#tt').datagrid('options').queryParams.fullname='';  
	$("#tt").datagrid('reload'); 
}
</script>
<div data-options="region:'center',border:false">
	<table id="tt">  
	</table>
</div>
<div id="w" class="easyui-window" data-options="title:'照片',closed:true,shadow:true,modal:true,iconCls:'icon-save'" style="width:663px;height:524px;padding:5px;">
	<div id="myform">

	</div>
</div>
<div id="tb" style="padding:5px;height:auto">
	<div style="margin-bottom:5px">
		<a href="javascript:tt_remove()" id="btnRemove" disabled="false" class="easyui-linkbutton" iconCls="icon-remove" plain="true">删除</a>
	</div>
	<div>
		考试名称: 
		<select id="title">
		<?php foreach($data as $k=>$v) {?>
		<option value="<?php echo $v['id']?>"><?php echo $v['title']?></option>
		<?php }?>
		</select>
		姓名: <input id="fullname" type="text" style="width:100px"/>
		<a href="javascript:my_query()" class="easyui-linkbutton" iconCls="icon-search">搜索</a>
		<a href="javascript:display_all()" class="easyui-linkbutton" iconCls="icon-search">显示全部</a>
	</div>
</div>
