<?php
/* @var $this ScoreController */
/* @var $model Score */

$this->breadcrumbs=array(
	'Scores'=>array('index'),
	'Manage',
);

$this->menu=array(
	array('label'=>'List Score', 'url'=>array('index')),
	array('label'=>'Create Score', 'url'=>array('create')),
);

Yii::app()->clientScript->registerScript('search', "
$('.search-button').click(function(){
	$('.search-form').toggle();
	return false;
});
$('.search-form form').submit(function(){
	$.fn.yiiGridView.update('score-grid', {
		data: $(this).serialize()
	});
	return false;
});
");
?>

<h1>Manage Scores</h1>

<p>
You may optionally enter a comparison operator (<b>&lt;</b>, <b>&lt;=</b>, <b>&gt;</b>, <b>&gt;=</b>, <b>&lt;&gt;</b>
or <b>=</b>) at the beginning of each of your search values to specify how the comparison should be done.
</p>

<?php echo CHtml::link('高级搜索','#',array('class'=>'search-button')); ?>
<div class="search-form" style="display:none">
<?php $this->renderPartial('_search',array(
	'model'=>$model,
)); ?>
</div><!-- search-form -->

<?php $this->widget('zii.widgets.grid.CGridView', array(
	'id'=>'score-grid',
	'dataProvider'=>$model->search(),
	'filter'=>$model,
	'columns'=>array(

		array(
            'name' => 'student_fullname.fullname',
            'htmlOptions'=>array(
                'width'=>'60',
                'style'=>'text-align:center',
             )), 
		array(
            'name' => 'classroom_title.title',
            'htmlOptions'=>array(
                'width'=>'60',
                'style'=>'text-align:center',
             )),
		//'grade_id',
		//'exam_id',
		'singlechoiceScore',
		'multichoiceScore',
		'judgeScore',
		//'fillinScore',
		//'faqScore',
		'operateScore',
		'totalScore',
		//'singlechoiceError',
		//'multichoiceError',
		//'judgeError',
		//'fillinAnswer',
		//'faqAnswer',
		//'operateAnswer',
		'reexam',
		
		/*隐藏操作列
		array(
			'class'=>'CButtonColumn',
		),
		*/
	),
)); ?>
