# coding: utf-8

import os
import pika
import json
import time
import datetime
from whoosh.index import open_dir, exists_in
from decouple import config
from record_count import record_count


IP = config('LOG_MQ_IP')
PORT = config('LOG_MQ_PORT', cast=int)
USER = config('LOG_MQ_USER')
PASSWORD = config('LOG_MQ_PASSWORD')
VHOST = config('LOG_MQ_VHOST')
QUEUE = config('LOG_MQ_QUEUE')
INDEX_PATH = config('LOG_INDEX_PATH')


def is_ready():
    if not os.path.isdir(INDEX_PATH):
        print "index folder not exist or it's not a folder."
        return False
    if not exists_in(INDEX_PATH):
        print 'index not exist, please create index first.'
        return False
    return True


def get_channel():

    try:
        credentials = pika.PlainCredentials(USER, PASSWORD)
        parameter = pika.ConnectionParameters(IP, PORT, VHOST, credentials, heartbeat=0)
        connection = pika.BlockingConnection(parameter)
        channel = connection.channel()
        channel.queue_declare(queue=QUEUE, durable=True, auto_delete=False)
        return channel
    except Exception as e:
        print 'error in get_channel(), {}'.format(e)
        return False


def handle_log(msg):
    msg = json.loads(msg)
    msg['flag'] = 1
    time_str = msg['time'].replace('T', ' ').split('+')[0]
    msg['time'] = datetime.datetime.strptime(time_str, '%Y-%m-%d %H:%M:%S')
    return msg


def index_log(channel):

    try:
        print 'start indexing access log'
        logs = []
        time_limit = time.time()
        while True:
            ix = open_dir(INDEX_PATH)
            for method, properties, body in channel.consume(QUEUE, auto_ack=True):
                log = handle_log(body)
                logs.append(log)
                record_count()
                if len(logs) >= 25 or time.time()-time_limit >= 15:
                    time_limit = time.time()
                    w = ix.writer()
                    for _log in logs:
                        print _log
                        w.add_document(**_log)
                    w.commit()
                    logs = []

    except Exception as e:
        print 'error in index_log(), {}'.format(e)


if __name__ == '__main__':
    if is_ready():
        _channel = get_channel()
        if _channel:
            index_log(_channel)
