# coding: utf-8

import redis
from decouple import config


def get_conn():
    redis_pool = redis.ConnectionPool(
        host=config('CLIENT_REDIS_HOST'),
        port=config('CLIENT_REDIS_PORT', cast=int),
        decode_responses=True)

    conn = redis.Redis(connection_pool=redis_pool)
    return conn


rdb = get_conn()


def record_count():
    log_count_key = config('LOG_RECORD_COUNT')
    rdb.incr(log_count_key)
