# -*- coding:utf-8 -*-
import psutil, time, datetime
from pprint import pprint  # 格式化打印
import os

# 定义一个专门用于获取系统信息的类
class Monitor(object):
    # 专门用于单位转化的方法
    def bytes_to_gb(self, data, key=""):
        if key == "percent":
            return data
        else:
            return round(data / (1024 ** 3), 2)

    # 专门获取cpu信息
    def cpu(self):
        data = dict(
            percent_avg=psutil.cpu_percent(interval=0, percpu=False),  # 平均
            percent_per=psutil.cpu_percent(interval=0, percpu=True),  # 单独
            num_p=psutil.cpu_count(logical=False),  # 物理cpu核心数
            num_l=psutil.cpu_count(logical=True),  # 逻辑cpu核心数
        )
        return data

    # 专门获取内存信息
    def mem(self):
        # 内存信息
        info = psutil.virtual_memory()
        data = dict(
            total=self.bytes_to_gb(info.total),
            used=self.bytes_to_gb(info.used),
            free=self.bytes_to_gb(info.free),
            percent=info.percent,
        )
        return data



    # 专门获取磁盘信息
    def disk(self):
        # info = psutil.disk_partitions()
        # data = [
        #     dict(
        #         device=v.device,
        #         mountpoint=v.mountpoint,
        #         fstype=v.fstype,
        #         opts=v.opts,
        #         used={
        #             k: self.bytes_to_gb(v, k)
        #             for k, v in psutil.disk_usage(v.mountpoint)._asdict().items()
        #         }
        #     )
        #     for v in info
        # ]
        info=psutil.disk_usage('/')
        data=dict()
        data['free']=self.bytes_to_gb(info.free)
        data['total']=self.bytes_to_gb(info.total)
        data['used']=self.bytes_to_gb(info.used)
        data['percent']=info.percent
        return data

    #专门获取流量信息
    def net(self):
        old_info=psutil.net_io_counters()
        data=dict()
        time.sleep(1)
        new_info=psutil.net_io_counters()
        data['bytes_recv_rate']=float(new_info.bytes_recv-old_info.bytes_recv)/1024
        data['bytes_sent_rate']=float(new_info.bytes_sent-old_info.bytes_sent)/1024
        # data['packets_recv_rate']=new_info.packets_recv-old_info.packets_recv
        # data['packets_sent_rate']=new_info.packets_sent-old_info.packets_sent
        return data
    #专门获取系统负载
    def load(self):
        info=psutil.cpu_times()
        data=dict()
        data['user']=info.user
        data['nice']=info.nice
        data['system']=info.system
        data['idle']=info.idle
        data['iowait']=info.iowait
        data['irq']=info.irq
        data['softirq']=info.softirq
        data['steal']=info.steal
        data['guest']=info.guest
        data['guest_nice']=info.guest_nice
        return data


    def average_load(self):
        f = os.popen("uptime | sed 's/,//g' | awk '{print $(NF-2)}'")
        info=f.read().strip()
        #info=info.split(": ")
        data=dict()
        data['avg_load']=info
        return data




if __name__ == "__main__":
    m = Monitor()
    # for v in range(1,11):
        # print(m.cpu())
        # time.sleep(1)
    # print(m.mem())
    # print(m.disk())
    pprint(m.disk())

