# coding: utf-8

import tornado.httpserver
import tornado.web
import tornado.ioloop
import sys
from handler.build_site_msg import BuildSiteMsgHandler
from handler.index_msg import RealTimeMonitorHandler
from decouple import config

reload(sys)
sys.setdefaultencoding('utf-8')


class CustomApp(tornado.web.Application):

    def __init__(self):
        handlers = [
            (r'/build-site', BuildSiteMsgHandler),
            (r'/real/time/monitor', RealTimeMonitorHandler),
        ]

        super(CustomApp, self).__init__(handlers)


if __name__ == '__main__':
    port = config('WEBSOCKET_PORT', cast=int)
    application = CustomApp()
    http_server = tornado.httpserver.HTTPServer(application)
    http_server.listen(port)
    print('WebSocket Server is runing at port {}\n'.format(port))
    tornado.ioloop.IOLoop.instance().start()
