/*
 Navicat MySQL Data Transfer

 Source Server         : local
 Source Server Type    : MySQL
 Source Server Version : 80016
 Source Host           : 192.168.3.55
 Source Database       : swanclint

 Target Server Type    : MySQL
 Target Server Version : 80016
 File Encoding         : utf-8

 Date: 01/06/2020 12:40:59 PM
*/

SET NAMES utf8;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
--  Table structure for `client_acquisition_data`
-- ----------------------------
DROP TABLE IF EXISTS `client_acquisition_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_acquisition_data` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain` varchar(255) NOT NULL,
  `title` text NOT NULL,
  `content` MEDIUMTEXT NOT NULL,
  `author` varchar(255) NOT NULL,
  `catid` int(11) NOT NULL,
  `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tags` varchar(255) NOT NULL,
  `likes` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `hates` int(11) NOT NULL DEFAULT '0',
  `downloads` int(11) NOT NULL DEFAULT '0',
  `types` int(11) NOT NULL DEFAULT '1',
  `area` varchar(255) NOT NULL DEFAULT '0',
  `flag` varchar(255) NOT NULL DEFAULT '',
  `img_url` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=975 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- ----------------------------
--  Table structure for `client_categorys`
-- ----------------------------
DROP TABLE IF EXISTS `client_categorys`;
CREATE TABLE `client_categorys` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_name` varchar(255) NOT NULL,
  `cat_desc` varchar(255) DEFAULT NULL,
  `cat_keys` varchar(255) DEFAULT NULL,
  `cat_id` int(11) NOT NULL,
  `cat_uri` varchar(255) NOT NULL,
  `cat_short` varchar(255) NOT NULL,
  `domain` varchar(255) NOT NULL,
  `mid` varchar(255) DEFAULT '',
  `main_name` varchar(255) NOT NULL COMMENT '主关键词',
  PRIMARY KEY (`id`),
  UNIQUE KEY `cat_uri` (`cat_uri`),
  KEY `cat_id` (`cat_id`,`domain`),
  FULLTEXT KEY `fulltext_mid` (`mid`)
) ENGINE=InnoDB AUTO_INCREMENT=13977 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- ----------------------------
--  Table structure for `client_domain`
-- ----------------------------
DROP TABLE IF EXISTS `client_domain`;
CREATE TABLE `client_domain` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `domain` varchar(255) NOT NULL,
  `sitename` varchar(100) NOT NULL,
  `sitedesc` varchar(255) DEFAULT NULL,
  `sitekeys` varchar(255) DEFAULT NULL,
  `seo` varchar(255) DEFAULT NULL,
  `sep` varchar(40) DEFAULT NULL,
  `uri` text NOT NULL,
  `sitemodel` varchar(100) NOT NULL,
  `templater` varchar(50) NOT NULL,
  `user` int(11) NOT NULL,
  `adddate` datetime DEFAULT CURRENT_TIMESTAMP,
  `status` int(11) NOT NULL,
  `sitetype` varchar(255) NOT NULL,
  `tag_uri` char(16) NOT NULL DEFAULT '0',
  `mail` varchar(255) NOT NULL DEFAULT 'admin@gmail.com',
  `tel` char(16) NOT NULL DEFAULT '18888888888',
  `sitetitle` varchar(255) not null default '',
  PRIMARY KEY (`id`),
  KEY `user` (`user`)
) ENGINE=InnoDB AUTO_INCREMENT=1470 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- ----------------------------
--  Table structure for `client_kinds`
-- ----------------------------
DROP TABLE IF EXISTS `client_kinds`;
CREATE TABLE `client_kinds` (
  `type_id` int(11) NOT NULL AUTO_INCREMENT COMMENT '类型id',
  `type_name` varchar(255) NOT NULL COMMENT '类型名称',
  `parent_id` int(11) NOT NULL COMMENT '所属上级',
  `model_id` int(11) NOT NULL DEFAULT '1' COMMENT '模型id',
  `mid` varchar(2000) DEFAULT '',
  `level` tinyint(4) NOT NULL COMMENT '所属层级',
  PRIMARY KEY (`type_id`),
  KEY `level` (`level`),
  KEY `parent_id` (`parent_id`),
  FULLTEXT KEY `mid` (`mid`),
  CONSTRAINT `client_kinds_ibfk_1` FOREIGN KEY (`parent_id`) REFERENCES `client_kinds` (`type_id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1824 DEFAULT CHARSET=utf8;

BEGIN;
INSERT INTO `client_kinds` VALUES (1, '占位记录', 1, 0, 0, 0);
COMMIT;


-- ----------------------------
--  Table structure for `client_longkey`
-- ----------------------------
DROP TABLE IF EXISTS `client_longkey`;
CREATE TABLE `client_longkey` (
  `lid` int(11) NOT NULL AUTO_INCREMENT,
  `keyword` varchar(255) COLLATE utf8mb4_general_ci NOT NULL COMMENT '关键词',
  `mid` varchar(2000) COLLATE utf8mb4_general_ci NOT NULL COMMENT '主关键词id,逗号分隔的字符串,可多个',
  `parent_id` int(11) DEFAULT '0' COMMENT '父长尾词id',
  `traffic_count` int(11) DEFAULT '0' COMMENT '流量指数',
  `collect_count` int(11) DEFAULT '0' COMMENT '收录数量',
  PRIMARY KEY (`lid`),
  UNIQUE KEY `keyword` (`keyword`),
  FULLTEXT KEY `mid_index` (`mid`)
) ENGINE=InnoDB AUTO_INCREMENT=9277695 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
--  Table structure for `client_mainkey`
-- ----------------------------
DROP TABLE IF EXISTS `client_mainkey`;
CREATE TABLE `client_mainkey` (
  `mid` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `keyword` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL COMMENT '关键词',
  `traffic_count` int(11) DEFAULT '0' COMMENT '流量指数',
  `collect_count` int(11) DEFAULT NULL,
  `column_count` int(11) DEFAULT NULL,
  `post_count` int(11) DEFAULT '0' COMMENT '采集关键词的文章数量',
  `longtail_count` int(11) DEFAULT '0',
  `related_count` int(11) DEFAULT '0',
  PRIMARY KEY (`mid`) USING BTREE,
  UNIQUE KEY `keyword` (`keyword`) USING BTREE,
  KEY `traffic_count` (`traffic_count`,`collect_count`,`column_count`) USING BTREE,
  KEY `post_count` (`post_count`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1514251 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci ROW_FORMAT=DYNAMIC;

-- ----------------------------
--  Table structure for `client_options`
-- ----------------------------
DROP TABLE IF EXISTS `client_options`;
CREATE TABLE `client_options`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `option_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '配置名称',
  `option_value` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '配置值',
  `option_desc` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '配置描述',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
--  Records of `client_options`
-- ----------------------------
BEGIN;
INSERT INTO `client_options` VALUES (1, 'update_random_img', '0', '是否更新随机图片', '2020-02-14 19:37:17');
COMMIT;

-- ----------------------------
--  Table structure for `client_relatedkey`
-- ----------------------------
DROP TABLE IF EXISTS `client_relatedkey`;
CREATE TABLE `client_relatedkey` (
  `rid` int(11) NOT NULL AUTO_INCREMENT,
  `keyword` varchar(255) COLLATE utf8mb4_general_ci NOT NULL COMMENT '关键词',
  `type_id` varchar(2000) COLLATE utf8mb4_general_ci DEFAULT '0' COMMENT '分类id,逗号分隔的字符串,可多个',
  `parent_id` int(11) DEFAULT '0' COMMENT '父长尾词id',
  `traffic_count` int(11) DEFAULT '0' COMMENT '流量指数',
  `collect_count` int(11) DEFAULT '0' COMMENT '收录数量',
  `mid` varchar(2000) COLLATE utf8mb4_general_ci DEFAULT '0',
  PRIMARY KEY (`rid`),
  UNIQUE KEY `keyword` (`keyword`),
  KEY `relatedkey` (`parent_id`,`traffic_count`,`collect_count`) USING BTREE,
  FULLTEXT KEY `type_id` (`type_id`),
  FULLTEXT KEY `mid_index` (`mid`)
) ENGINE=InnoDB AUTO_INCREMENT=30001 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- ----------------------------
--  Table structure for `client_tags`
-- ----------------------------
DROP TABLE IF EXISTS `client_tags`;
CREATE TABLE `client_tags` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tag` char(32) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tag` (`tag`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `client_acquisition_config`
-- ----------------------------
DROP TABLE IF EXISTS `client_acquisition_config`;
CREATE TABLE `client_acquisition_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `acquisition_time` time DEFAULT '02:30:00',
  `acquisition_cycle` tinyint(4) DEFAULT '6',
  `acquisitions_num` int(11) DEFAULT '10',
  `is_original` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
--  Records of `client_acquisition_config`
-- ----------------------------
BEGIN;
INSERT INTO `client_acquisition_config` VALUES ('1', '15:48:00', '20', '20', '0');
COMMIT;

-- ----------------------------
--  Table structure for `client_img`
-- ----------------------------
DROP TABLE IF EXISTS `client_img`;
CREATE TABLE `client_img` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;


-- ----------------------------
--  Table structure for `client_site_desc`
-- ----------------------------
DROP TABLE IF EXISTS `client_site_desc`;
CREATE TABLE `client_site_desc` (
  `id` int(11) NOT NULL,
  `web_desc` varchar(512) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


-- ----------------------------
--  Records of `client_img`
-- ----------------------------
BEGIN;
INSERT INTO `client_img` VALUES ('1', 'https://swan-images.oss-cn-shanghai.aliyuncs.com/223MQn9q43RZGyff4Hcsfd');
COMMIT;

-- ----------------------------
--  Table structure for `client_model`
-- ----------------------------
DROP TABLE IF EXISTS `client_model`;
CREATE TABLE `client_model` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `model_id` int(11) NOT NULL,
  `model_name` varchar(255) NOT NULL,
  `model_uri` text NOT NULL,
  `model_structure` json NOT NULL,
  `model_desc` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `model_id` (`model_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;

-- ----------------------------
--  Records of `client_model`
-- ----------------------------
BEGIN;
INSERT INTO `client_model` VALUES ('3', '1', '文章', '/(*)/(*)', '\"{\\\"其他\\\":{\\\"综合\\\":{\\\"3\\\":\\\"体育\\\",\\\"4\\\":\\\"娱乐\\\",\\\"5\\\":\\\"社会\\\",\\\"6\\\":\\\"财经\\\",\\\"7\\\":\\\"时事\\\",\\\"8\\\":\\\"科技\\\",\\\"9\\\":\\\"情感\\\",\\\"10\\\":\\\"汽车\\\",\\\"11\\\":\\\"教育\\\",\\\"12\\\":\\\"时尚\\\",\\\"13\\\":\\\"游戏\\\",\\\"14\\\":\\\"军事\\\",\\\"15\\\":\\\"旅游\\\",\\\"16\\\":\\\"美食\\\",\\\"17\\\":\\\"星座\\\"}}}\"', '文章模型描述');
COMMIT;

-- ----------------------------
--  Table structure for `client_pageupdate_config`
-- ----------------------------
DROP TABLE IF EXISTS `client_pageupdate_config`;
CREATE TABLE `client_pageupdate_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `updatetime` time DEFAULT '07:30:00',
  `amount` int(11) DEFAULT '8',
  `updatecycle` int(11) DEFAULT '6',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
--  Records of `client_pageupdate_config`
-- ----------------------------
BEGIN;
INSERT INTO `client_pageupdate_config` VALUES ('1', '22:10:00', '10', '2');
COMMIT;

SET FOREIGN_KEY_CHECKS = 1;

DROP TABLE IF EXISTS `client_options`;
CREATE TABLE `client_options`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `option_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '配置名称',
  `option_value` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '配置值',
  `option_desc` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL DEFAULT '0' COMMENT '配置描述',
  `update_time` timestamp(0) NOT NULL DEFAULT CURRENT_TIMESTAMP(0),
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of client_options
-- ----------------------------
INSERT INTO `client_options` VALUES (1, 'update_random_img', '0', '是否更新随机图片', '2020-02-14 19:37:17');

SET FOREIGN_KEY_CHECKS = 1;


CREATE TABLE `client_article_temp` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `domain` VARCHAR(255) NOT NULL,
  `article_id` CHAR(16) NOT NULL,
  `author` VARCHAR(50) NOT NULL DEFAULT '0',
  `catid` INT(11) NOT NULL,
  `date` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `tags` VARCHAR(255) NOT NULL,
  `likes` INT(11) NOT NULL DEFAULT '0',
  `clicks` INT(11) NOT NULL DEFAULT '0',
  `hates` INT(11) NOT NULL DEFAULT '0',
  `downloads` INT(11) NOT NULL DEFAULT '0',
  `types` TINYINT(4) NOT NULL DEFAULT '1',
  `area` CHAR(6) NOT NULL DEFAULT '0',
  `flag` CHAR(2) NOT NULL DEFAULT '',
  `img_url` TEXT NULL,
  PRIMARY KEY (`id`),
  INDEX `domain` (`domain`),
  INDEX `article_id` (`article_id`)
)
COLLATE='utf8mb4_general_ci'
ENGINE=InnoDB;