-- domain judge
if not ngx.ctx.domain then
    ngx.exit(ngx.HTTP_FORBIDDEN)
end

if ngx.ctx.domain.s == "0" then
    ngx.exit(ngx.HTTP_FORBIDDEN)
end

local redis_lib = require "resty.redis_iresty"

local redis = redis_lib:new()

local ua_key = 'baned_ua'
local ip_key = 'baned_ip'

local baned_uas = redis:smembers(ua_key)
local baned_ips = redis:smembers(ip_key)

local access_ua = string.lower(ngx.var.http_user_agent)
local access_ip = ngx.var.remote_addr

if ( baned_uas~=nil ) then
	for k, v in pairs(baned_uas) do
		if string.match(access_ua, string.lower(v)) then
			ngx.exit(ngx.HTTP_FORBIDDEN)
			break
		end
	end
end

if ( baned_ips~=nil ) then
	for k, v in pairs(baned_ips) do
		if access_ip == v then
			ngx.exit(ngx.HTTP_FORBIDDEN)
			break
		end
	end
end
