-- 获取域名信息从redis

local redis = require "resty.redis_iresty"
local red = redis:new()
local domain = string.gsub(ngx.var.host,'%.','_')
local key = ngx.md5(domain..ngx.var.request_uri)
local results, err = red:hget("domain",domain)

ngx.ctx.domain=results

-- 如果域名不存在则重定向到随机网站的sitemap

if not ngx.ctx.domain then
    local dlist, err = red:hkeys("domain")
    local randnum = math.random(0, table.getn(dlist))
    local randsite = string.gsub(dlist[randnum],'%_','.')
    return ngx.redirect("http://"..randsite.."/sitemap.xml",301)
end