<?php

/**
 *      【橙创家校通v4.0】 (C)2010-2012 Tuntron Inc.
 *      
 *    	 http://www.tuntron.com   QQ：1121251729
 *
 *      &菜单设置类文件& BY CC
 */

if (!defined('IS_RUN')) die('Forbidden');

class tj_menu extends tj_model {

	var $table = 'dbpre_menus';
    var $key = 'menuid';

    function __construct() {
        parent::__construct();
    }

    function tj_menu() {
		$this->__construct();
    }

    function read_all($parentid=null,$isfolder=FALSE) {
        $parentid = (int) $parentid;

        $this->db->where('parentid', $parentid);
		
        if(!$parentid || $isfolder) {
            $this->db->where('isfolder', '1');
        }
        $this->db->from($this->table);
		$this->db->order_by('listorder');
        $row = $this->db->get();

        $result = array();
        if(!$row) return $result;
        while($value=$row->fetch_array()) {
            $result[] = $value;
        }
        return $result;
    }
	
	function get_left_menu_html($parentid=null,$do,$c) {
        $parentid = (int) $parentid;

        $this->db->where('parentid', $parentid);
        $this->db->where('scriptnav', $do);
        $this->db->from($this->table);
        $menu = $this->db->once_fetch_assoc();
		if($menu['menuid']){
			
			$leftmenu = $this->read_all($menu['menuid']);
			
			$left_arr = array();
			foreach($leftmenu as $key => $val) {
				if($val['isclosed']=='0') {
					$left_arr[$val['title']] = $val['scriptnav'];
					$http[$val['title']]=strstr($val['url'],'http://')?$val['url']:'';
				}
				
      		}
			
			$left_url = SITEURL.$menu['url'].'&';
	 		$left_html = left_html($left_arr,'c',$c,$left_url,$http);
			return $left_html;
			
		}else{
			
			return '';
			}
		
		
       
    }

    function save($post, $id=null, $upcache=TRUE) {
        if($id && $id == $post['parentid']) Note('admincp_menu_parentid_menuid_invalid');
        $id = parent::save($post, $id, $upcache,FALSE);
    }

    function update($post) {
        if(!$post || !is_array($post)) Note('global_op_unselect');
        foreach($post as $menuid => $val) {
            $val['isclosed'] = (int) $val['isclosed'];
            $this->save($val, $menuid, FALSE);
        }
        $this->write_cache();
    }

    function delete($menuids) {
        if(!$menuids) Note('global_op_unselect');
        if(is_array($menuids)) {
            foreach($menuids as $meunid) {
                if(!$meunid) continue;
                $this->delete($meunid);
            }
        } else {
            $list = array();
            $this->_read_child_row($menuids, $list);
            $list[] = $menuids;
            parent::delete($list, FALSE);
        }
        $this->write_cache();
    }

    function read_child_list() {
        $this->db->where('isfolder', 1);
        $this->db->from($this->table);
        $row = $this->db->get();
        while($v=$row->fetch_array()) {
            $result[$v['parentid']][$v['menuid']] = $v['title'];
        }
        return $result;
    }
	
	function read_isfolder_list($menuid,$parentid=0,$level=0) {
        $this->db->where('isfolder', 1);
		$this->db->where('parentid', $parentid);
        $this->db->from($this->table);
        $menulist = $this->db->fetch_all_assoc();
	
		$content='';
         foreach($menulist as $key => $val) {
            $selected = $menuid == $val['menuid'] ? ' selected' : '';
            $content .= "<option value=\"".$val['menuid']."\"$selected>".str_repeat('&nbsp;&nbsp;',$level+1)."☆".$val['title']."</option>";
        }
			
        return $content;
    }

    function create_leve_option($menuid,$parentid=0,$level=0) {
		
		$this->db->from($this->table);
		$this->db->where('parentid', $parentid);
		$this->db->order_by('listorder');
        $menulist = $this->db->fetch_all_assoc();
        $content = '';
        foreach($menulist as $key => $val) {
            $selected = $menuid == $val['menuid'] ? ' selected' : '';
            $content .= "<option value=\"".$val['menuid']."\"$selected>".str_repeat('&nbsp;&nbsp;',$level+1)."└".$val['title']."</option>";
            
            $content .= $this->create_leve_option($menuid,$val['menuid'], $level+1);
        }
        return $content;
    }
	
	 function get_menu_html($parentid,$scriptnav='index',$type='') {
        $this->db->where('parentid', $parentid);
		$this->db->where('isclosed', '0');
        $this->db->from($this->table);
		$this->db->order_by('listorder');
        $this->db->select('title,scriptnav,url');
        $menulist = $this->db->fetch_all_assoc();
		if(!$menulist) return FALSE;
        $menuhtml= '';
        foreach($menulist as $key => $val) {
			$val['url'] = strstr($val['url'],'http://')?$val['url']:SITEURL.$val['url'];
			if($type=='top') {
				$menuhtml .= '<span class=""><a href="'.$val['url'].'" target="_blank">'.$val['title'].'</a></span>';
			}elseif($type=='bottom'){
				$menuhtml .= '<a href="'.$val['url'].'" target="_blank">'.$val['title'].'</a><span style="color:#798699"> | </span>';
			}else{
				$class_on = $scriptnav == $val['scriptnav'] ? ' class="on"' : '';
				$menuhtml .= '<li><a href="'.$val['url'].'"'.$class_on .'>'.$val['title'].'</a></li>';
			}
        }
        return $menuhtml;
    }

    function _read_child_row($parentid, & $list) {
        $this->db->where('parentid', $parentid);
        $this->db->from($this->table);
        $this->db->select('menuid,parentid,isfolder');
        $row = $this->db->get();
        if(!$row) return FALSE;
        while($value=$row->fetch_array()) {
            $list[] = $value['menuid'];
            if($value['isfolder']) {
                if($res = $this->_read_child_row($value['menuid'], $list)) {
                    $result = array_merge($list, $res);
                }
            }
        }
        return $list;
    }

    function check_post(& $post, $edit) {
        if(!$post['title']) Note('菜单名称不能为空！');
        if(!$post['isfolder'] && !$post['url']) Note('菜单地址不能为空！');
    }

    function write_cache() {
       
    }

    function _write_cache($pid) {
       
    }
}
?>