/*
Navicat MySQL Data Transfer

Source Server         : eduwork ali new
Source Server Version : 50173
Source Host           : bdm239013440.my3w.com:3306
Source Database       : bdm239013440_db

Target Server Type    : MYSQL
Target Server Version : 50173
File Encoding         : 65001

Date: 2016-10-12 09:55:33
*/

SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for ew_admin
-- ----------------------------
DROP TABLE IF EXISTS `ew_admin`;
CREATE TABLE `ew_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '管理员用户名',
  `password` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '密码',
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '管理员显示姓名',
  `typeid` int(11) DEFAULT NULL COMMENT '类型',
  `phone` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '电话',
  `mail` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '邮箱',
  `avatar` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '头像',
  `regtime` datetime DEFAULT NULL COMMENT '注册时间',
  `campusid` int(11) DEFAULT NULL COMMENT '校区id',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用户表';

-- ----------------------------
-- Records of ew_admin
-- ----------------------------
INSERT INTO `ew_admin` VALUES ('1', 'ycftxq', 'ycf2016', '徐相林', '1', '15277788899', 'eee@qq.com', '', '2016-08-10 00:00:00', '1');
INSERT INTO `ew_admin` VALUES ('2', 'admin', 'qq694201656', '总管理员哇塞', '0', '13599887766', '4243sufei@qq.com', '', '2016-04-20 00:00:00', null);
INSERT INTO `ew_admin` VALUES ('23', 'cztnq', 'ycf2016', '祁丹丹', '1', '17714198555', '2@2.com', null, '2016-10-11 22:08:31', '4');
INSERT INTO `ew_admin` VALUES ('21', 'ycfqh', 'ycf2016', '蒋浩楠', '1', '13485772433', '1@123.com', null, '2016-10-11 20:51:50', '3');

-- ----------------------------
-- Table structure for ew_admintype
-- ----------------------------
DROP TABLE IF EXISTS `ew_admintype`;
CREATE TABLE `ew_admintype` (
  `id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL COMMENT '类型名称',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='管理员类型表 备用';

-- ----------------------------
-- Records of ew_admintype
-- ----------------------------
INSERT INTO `ew_admintype` VALUES ('0', '总管理员');
INSERT INTO `ew_admintype` VALUES ('1', '校区校长');

-- ----------------------------
-- Table structure for ew_called
-- ----------------------------
DROP TABLE IF EXISTS `ew_called`;
CREATE TABLE `ew_called` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `called_studentid` int(255) DEFAULT NULL COMMENT '学生id',
  `called_scheduleid` int(10) unsigned NOT NULL COMMENT '对应排课表里的id',
  `called_evaluate` varchar(255) DEFAULT NULL COMMENT '上课评价',
  `called_status` int(11) DEFAULT NULL,
  `called_absent` varchar(255) DEFAULT NULL COMMENT '旷课原因',
  `campusid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=gbk;

-- ----------------------------
-- Records of ew_called
-- ----------------------------
INSERT INTO `ew_called` VALUES ('1', '171', '186', '经常旷课', '0', '44', '3');
INSERT INTO `ew_called` VALUES ('2', '172', '185', '很少旷课', '0', '未知', '3');
INSERT INTO `ew_called` VALUES ('3', '173', '185', '变现优异', '1', '', '3');
INSERT INTO `ew_called` VALUES ('4', '174', '185', '表现良好', '1', null, '3');
INSERT INTO `ew_called` VALUES ('5', '175', '186', '表现十分好', '1', null, '3');
INSERT INTO `ew_called` VALUES ('6', '176', '185', '表现差', '0', '未知', '3');
INSERT INTO `ew_called` VALUES ('7', '177', '186', '表现好', '1', null, '3');
INSERT INTO `ew_called` VALUES ('9', '203', '185', '测试评价', '1', null, '3');
INSERT INTO `ew_called` VALUES ('10', '174', '186', '额我热温热', '1', null, '3');
INSERT INTO `ew_called` VALUES ('11', '449', '188', '小伙子不错', '1', null, '3');
INSERT INTO `ew_called` VALUES ('12', '449', '189', '这节课表现也是不错的', '1', null, '3');
INSERT INTO `ew_called` VALUES ('14', '621', '285', '不错', '1', '没旷课', '3');
INSERT INTO `ew_called` VALUES ('16', '623', '285', '', '1', '', '3');
INSERT INTO `ew_called` VALUES ('17', '452', '285', '', '1', '', '3');
INSERT INTO `ew_called` VALUES ('18', '454', '285', '4432', '0', '32434', '3');
INSERT INTO `ew_called` VALUES ('19', '611', '301', '还能', '1', '没', '3');
INSERT INTO `ew_called` VALUES ('20', '621', '286', 'ewqe', '1', 'wqewq', '3');
INSERT INTO `ew_called` VALUES ('21', '623', '286', '324324', '1', '234234', '3');
INSERT INTO `ew_called` VALUES ('22', '454', '286', '324324', '1', '234234', '3');
INSERT INTO `ew_called` VALUES ('23', '452', '286', '', '0', 'qwewqe', '3');
INSERT INTO `ew_called` VALUES ('24', '623', '287', '', '0', '', '3');
INSERT INTO `ew_called` VALUES ('25', '595', '287', '', '0', '', '3');
INSERT INTO `ew_called` VALUES ('26', '454', '287', '', '0', '', '3');
INSERT INTO `ew_called` VALUES ('27', '452', '287', '', '0', '', '3');
INSERT INTO `ew_called` VALUES ('28', '621', '287', '', '0', '', '3');

-- ----------------------------
-- Table structure for ew_campus
-- ----------------------------
DROP TABLE IF EXISTS `ew_campus`;
CREATE TABLE `ew_campus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `campus_name` varchar(255) DEFAULT NULL COMMENT '校区名称',
  `campus_address` varchar(255) DEFAULT NULL COMMENT '校区地址',
  `campus_createtime` date DEFAULT NULL COMMENT '创建时间',
  `campus_remark` varchar(255) DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='校区表';

-- ----------------------------
-- Records of ew_campus
-- ----------------------------
INSERT INTO `ew_campus` VALUES ('1', '铁心桥校区', '铁心大厦', '2016-08-18', '主校区');
INSERT INTO `ew_campus` VALUES ('3', '南京秦淮校区', '琵琶巷小区', '2016-08-20', '琵琶巷小区');
INSERT INTO `ew_campus` VALUES ('4', '常州天宁区校区', '天宁区青龙苑A-9、10号商铺二楼', '2016-08-17', null);

-- ----------------------------
-- Table structure for ew_classes
-- ----------------------------
DROP TABLE IF EXISTS `ew_classes`;
CREATE TABLE `ew_classes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `classes_name` varchar(255) DEFAULT NULL COMMENT '班级名称',
  `classes_headteacher` int(11) DEFAULT NULL COMMENT '班主任 老师ID',
  `classes_lessonteacher` int(11) DEFAULT NULL COMMENT '任课老师 老师ID',
  `classes_courseid` int(11) DEFAULT NULL COMMENT '课程ID',
  `classes_classroomid` int(11) DEFAULT NULL COMMENT '教室ID',
  `classes_planstudents` int(11) DEFAULT NULL COMMENT '预招学生数',
  `classes_plantimes` varchar(255) DEFAULT NULL COMMENT '计划课时次数',
  `campusid` int(11) DEFAULT NULL COMMENT '所属校区',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8 COMMENT='班级表';

-- ----------------------------
-- Records of ew_classes
-- ----------------------------
INSERT INTO `ew_classes` VALUES ('1', '班级一', '1', '1', '1', '1', '10', '18', '1');
INSERT INTO `ew_classes` VALUES ('2', '班级二', '95', '95', '5', '19', '40', '1:0', '3');
INSERT INTO `ew_classes` VALUES ('3', '班级三', '85', '78', '5', '2', '88', '1:50', '3');
INSERT INTO `ew_classes` VALUES ('13', '班级四', '92', '78', '5', '21', '82', '5:25', '3');
INSERT INTO `ew_classes` VALUES ('15', '班级五', '85', '78', '5', '22', '221', '1:30', '3');
INSERT INTO `ew_classes` VALUES ('18', '班级天', '89', null, null, '23', null, '9:45', '3');
INSERT INTO `ew_classes` VALUES ('24', '班级上下', '102', null, '2', '2', '50', '1:40', '3');
INSERT INTO `ew_classes` VALUES ('25', '班级shangxi', '92', null, null, '21', null, '3:50', '3');
INSERT INTO `ew_classes` VALUES ('26', '班级左', null, null, null, null, null, null, '3');
INSERT INTO `ew_classes` VALUES ('27', '测试班级', '92', '95', '14', '22', '60', '30', '3');
INSERT INTO `ew_classes` VALUES ('28', '小学四年级语文班', '92', '145', '10', '2', '50', '1:05', '3');
INSERT INTO `ew_classes` VALUES ('29', '班级1 ', '203', '204', '23', '24', '40', '100', '7');
INSERT INTO `ew_classes` VALUES ('30', '班级2 ', '204', '204', '23', '25', '45', '39', '7');
INSERT INTO `ew_classes` VALUES ('32', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('33', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('34', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('35', '班级shangxi', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('36', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('37', '班级左', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('38', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('39', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('40', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('41', '班级shangxi', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('42', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('43', '班级左', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('44', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('45', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('46', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('47', '班级shangxi', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('48', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('49', '班级左', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('50', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('51', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('52', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('53', '班级shangxi', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('54', '班级二', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('55', '班级左', null, null, null, null, null, null, null);
INSERT INTO `ew_classes` VALUES ('56', '班级3', null, null, '22', null, '60', null, '7');
INSERT INTO `ew_classes` VALUES ('57', '班级二', null, null, null, null, null, null, '6');
INSERT INTO `ew_classes` VALUES ('58', '班级三', null, null, null, null, null, null, '6');
INSERT INTO `ew_classes` VALUES ('59', '班级1', '218', null, '26', '27', '50', '3:15', '4');
INSERT INTO `ew_classes` VALUES ('60', '班级2中间', '219', null, '27', '28', '45', '4:30', '4');
INSERT INTO `ew_classes` VALUES ('61', '班级3是最长的', null, null, '28', null, '65', null, '4');
INSERT INTO `ew_classes` VALUES ('63', '班级二', null, null, null, null, null, null, '9');
INSERT INTO `ew_classes` VALUES ('64', '我试试班级', null, null, null, null, null, null, '9');
INSERT INTO `ew_classes` VALUES ('65', '61336161@qq.com', null, null, null, null, null, null, '3');

-- ----------------------------
-- Table structure for ew_classroom
-- ----------------------------
DROP TABLE IF EXISTS `ew_classroom`;
CREATE TABLE `ew_classroom` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `classroom_name` varchar(255) DEFAULT NULL,
  `classroom_containnum` int(11) DEFAULT NULL COMMENT '可容纳人数',
  `campusid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 COMMENT='教室表';

-- ----------------------------
-- Records of ew_classroom
-- ----------------------------
INSERT INTO `ew_classroom` VALUES ('1', '教室4', '73', '1');
INSERT INTO `ew_classroom` VALUES ('2', '教室2', '22', '3');
INSERT INTO `ew_classroom` VALUES ('3', '教室3', '12', '4');
INSERT INTO `ew_classroom` VALUES ('19', '教室1', '44', '3');
INSERT INTO `ew_classroom` VALUES ('21', '教室3', '50', '3');
INSERT INTO `ew_classroom` VALUES ('22', '教室4', '60', '3');
INSERT INTO `ew_classroom` VALUES ('23', '奇葩教室', '4', '3');
INSERT INTO `ew_classroom` VALUES ('24', '铁心教室1', '40', '7');
INSERT INTO `ew_classroom` VALUES ('25', '贴心教室2', '45', '7');
INSERT INTO `ew_classroom` VALUES ('26', '铁心教室3', '50', '7');
INSERT INTO `ew_classroom` VALUES ('27', '教室1字母', '60', '4');
INSERT INTO `ew_classroom` VALUES ('28', '教室2测试用', '40', '4');

-- ----------------------------
-- Table structure for ew_config
-- ----------------------------
DROP TABLE IF EXISTS `ew_config`;
CREATE TABLE `ew_config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` int(11) DEFAULT '0' COMMENT '类型 0不可修改 1可修改',
  `name` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '名称',
  `value` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '值',
  `remark` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=134 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='全局配置表';

-- ----------------------------
-- Records of ew_config
-- ----------------------------
INSERT INTO `ew_config` VALUES ('58', '1', 'GlobalTitle', 'EduWork ManageMent System', '网站标题');
INSERT INTO `ew_config` VALUES ('59', '1', 'BackGroundTitle', 'EduWork', '后台头部标题');
INSERT INTO `ew_config` VALUES ('60', '1', 'LoginPageTitle', 'EduWork ManageMent System', '登录页面标题(英)');
INSERT INTO `ew_config` VALUES ('61', '1', 'LoginPageSTitle', '培训学校运营管理系统以及服务系统', '登录页面标题(中)');
INSERT INTO `ew_config` VALUES ('62', '0', 'DialogClassSpeed', 'animated-fast', null);
INSERT INTO `ew_config` VALUES ('63', '0', 'DialogClassAnimation', 'bounceIn', null);
INSERT INTO `ew_config` VALUES ('64', '0', 'DialogClassSelect', 'bounce', null);
INSERT INTO `ew_config` VALUES ('65', '0', 'DialogClassSelect', 'flash', null);
INSERT INTO `ew_config` VALUES ('66', '0', 'DialogClassSelect', 'pulse', null);
INSERT INTO `ew_config` VALUES ('67', '0', 'DialogClassSelect', 'rubberBand', null);
INSERT INTO `ew_config` VALUES ('68', '0', 'DialogClassSelect', 'shake', null);
INSERT INTO `ew_config` VALUES ('69', '0', 'DialogClassSelect', 'swing', null);
INSERT INTO `ew_config` VALUES ('70', '0', 'DialogClassSelect', 'tada', null);
INSERT INTO `ew_config` VALUES ('71', '0', 'DialogClassSelect', 'wobble', null);
INSERT INTO `ew_config` VALUES ('72', '0', 'DialogClassSelect', 'bounceIn', null);
INSERT INTO `ew_config` VALUES ('73', '0', 'DialogClassSelect', 'bounceInDown', null);
INSERT INTO `ew_config` VALUES ('74', '0', 'DialogClassSelect', 'bounceInLeft', null);
INSERT INTO `ew_config` VALUES ('75', '0', 'DialogClassSelect', 'bounceInRight', null);
INSERT INTO `ew_config` VALUES ('76', '0', 'DialogClassSelect', 'bounceInUp', null);
INSERT INTO `ew_config` VALUES ('77', '0', 'DialogClassSelect', 'bounceOut', null);
INSERT INTO `ew_config` VALUES ('78', '0', 'DialogClassSelect', 'bounceOutDown', null);
INSERT INTO `ew_config` VALUES ('79', '0', 'DialogClassSelect', 'bounceOutLeft', null);
INSERT INTO `ew_config` VALUES ('80', '0', 'DialogClassSelect', 'bounceOutRight', null);
INSERT INTO `ew_config` VALUES ('81', '0', 'DialogClassSelect', 'bounceOutUp', null);
INSERT INTO `ew_config` VALUES ('82', '0', 'DialogClassSelect', 'fadeIn', null);
INSERT INTO `ew_config` VALUES ('83', '0', 'DialogClassSelect', 'fadeInDown', null);
INSERT INTO `ew_config` VALUES ('84', '0', 'DialogClassSelect', 'fadeInLeft', null);
INSERT INTO `ew_config` VALUES ('85', '0', 'DialogClassSelect', 'fadeInRight', null);
INSERT INTO `ew_config` VALUES ('86', '0', 'DialogClassSelect', 'fadeInUp', null);
INSERT INTO `ew_config` VALUES ('87', '0', 'DialogClassSelect', 'fadeOut', null);
INSERT INTO `ew_config` VALUES ('88', '0', 'DialogClassSelect', 'fadeOutDown', null);
INSERT INTO `ew_config` VALUES ('89', '0', 'DialogClassSelect', 'fadeOutLeft', null);
INSERT INTO `ew_config` VALUES ('90', '0', 'DialogClassSelect', 'fadeOutRight', null);
INSERT INTO `ew_config` VALUES ('91', '0', 'DialogClassSelect', 'fadeOutUp', null);
INSERT INTO `ew_config` VALUES ('92', '0', 'DialogClassSelect', 'flipInX', null);
INSERT INTO `ew_config` VALUES ('93', '0', 'DialogClassSelect', 'flipInY', null);
INSERT INTO `ew_config` VALUES ('94', '0', 'DialogClassSelect', 'flipOutX', null);
INSERT INTO `ew_config` VALUES ('95', '0', 'DialogClassSelect', 'flipOutY', null);
INSERT INTO `ew_config` VALUES ('96', '0', 'DialogClassSelect', 'lightSpeedIn', null);
INSERT INTO `ew_config` VALUES ('97', '0', 'DialogClassSelect', 'lightSpeedOut', null);
INSERT INTO `ew_config` VALUES ('98', '0', 'DialogClassSelect', 'rotateIn', null);
INSERT INTO `ew_config` VALUES ('99', '0', 'DialogClassSelect', 'rotateInDownLeft', null);
INSERT INTO `ew_config` VALUES ('100', '0', 'DialogClassSelect', 'rotateInDownRight', null);
INSERT INTO `ew_config` VALUES ('101', '0', 'DialogClassSelect', 'rotateInUpLeft', null);
INSERT INTO `ew_config` VALUES ('102', '0', 'DialogClassSelect', 'rotateInUpRight', null);
INSERT INTO `ew_config` VALUES ('103', '0', 'DialogClassSelect', 'rotateOut', null);
INSERT INTO `ew_config` VALUES ('104', '0', 'DialogClassSelect', 'rotateOutDownLeft', null);
INSERT INTO `ew_config` VALUES ('105', '0', 'DialogClassSelect', 'rotateOutDownRight', null);
INSERT INTO `ew_config` VALUES ('106', '0', 'DialogClassSelect', 'rotateOutUpLeft', null);
INSERT INTO `ew_config` VALUES ('107', '0', 'DialogClassSelect', 'rotateOutUpRight', null);
INSERT INTO `ew_config` VALUES ('108', '0', 'DialogClassSelect', 'hinge', null);
INSERT INTO `ew_config` VALUES ('109', '0', 'DialogClassSelect', 'rollIn', null);
INSERT INTO `ew_config` VALUES ('110', '0', 'DialogClassSelect', 'rollOut', null);
INSERT INTO `ew_config` VALUES ('111', '0', 'DialogClassSelect', 'zoomIn', null);
INSERT INTO `ew_config` VALUES ('112', '0', 'DialogClassSelect', 'zoomInDown', null);
INSERT INTO `ew_config` VALUES ('113', '0', 'DialogClassSelect', 'zoomInLeft', null);
INSERT INTO `ew_config` VALUES ('114', '0', 'DialogClassSelect', 'zoomInRight', null);
INSERT INTO `ew_config` VALUES ('115', '0', 'DialogClassSelect', 'zoomInUp', null);
INSERT INTO `ew_config` VALUES ('116', '0', 'DialogClassSelect', 'zoomOut', null);
INSERT INTO `ew_config` VALUES ('117', '0', 'DialogClassSelect', 'zoomOutDown', null);
INSERT INTO `ew_config` VALUES ('118', '0', 'DialogClassSelect', 'zoomOutLeft', null);
INSERT INTO `ew_config` VALUES ('119', '0', 'DialogClassSelect', 'zoomOutRight', null);
INSERT INTO `ew_config` VALUES ('120', '0', 'DialogClassSelect', 'zoomOutUp', null);
INSERT INTO `ew_config` VALUES ('121', '0', 'DialogClassSelect', 'slideInDown', null);
INSERT INTO `ew_config` VALUES ('123', '0', 'DialogClassSelect', 'slideInLeft', null);
INSERT INTO `ew_config` VALUES ('124', '0', 'DialogClassSelect', 'slideInRight', null);
INSERT INTO `ew_config` VALUES ('125', '0', 'DialogClassSelect', 'slideInUp', null);
INSERT INTO `ew_config` VALUES ('126', '0', 'DialogClassSelect', 'slideOutDown', null);
INSERT INTO `ew_config` VALUES ('127', '0', 'DialogClassSelect', 'slideOutLeft', null);
INSERT INTO `ew_config` VALUES ('128', '0', 'DialogClassSelect', 'slideOutRight', null);
INSERT INTO `ew_config` VALUES ('129', '0', 'DialogClassSelect', 'slideOutUp', null);
INSERT INTO `ew_config` VALUES ('130', '1', 'openAnimation', '0', '动画效果');
INSERT INTO `ew_config` VALUES ('131', '1', 'coursegridsize', '15', '课程列表每页显示数');
INSERT INTO `ew_config` VALUES ('132', '1', 'studentgridsize', '15', '学生列表每页显示数');
INSERT INTO `ew_config` VALUES ('133', '1', 'teachergridsize', '15', '教师列表每页显示数');

-- ----------------------------
-- Table structure for ew_course
-- ----------------------------
DROP TABLE IF EXISTS `ew_course`;
CREATE TABLE `ew_course` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `course_name` varchar(255) COLLATE utf8_unicode_ci DEFAULT '' COMMENT '课程名称',
  `course_grade_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '年级id',
  `course_subject_id` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '科目ID',
  `course_type` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '类型',
  `course_unitprice` double(11,0) DEFAULT NULL COMMENT '一课时的价钱',
  `course_periodnum` int(11) DEFAULT NULL COMMENT '课时数',
  `course_status` tinyint(4) DEFAULT '0' COMMENT '0停用 1启用',
  `course_total` int(11) DEFAULT NULL,
  `campusid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='课程表';

-- ----------------------------
-- Records of ew_course
-- ----------------------------
INSERT INTO `ew_course` VALUES ('1', '测试2', '1', '1', '类型', '807', '88', '1', null, '1');
INSERT INTO `ew_course` VALUES ('2', '数学测试', '9', '2', '类型2', '100', '100', '0', '10000', '3');
INSERT INTO `ew_course` VALUES ('5', '一年级数学提高班', '9', '2', '提高班', '222', '22', '0', '4884', '3');
INSERT INTO `ew_course` VALUES ('11', '12', '9', '2', '2123', '321', '32', '0', null, '1');
INSERT INTO `ew_course` VALUES ('10', '的武器', '9', '2', '', '221', '2', '1', '442', '3');
INSERT INTO `ew_course` VALUES ('22', '数学测试', '17', '22', null, '100', '30', '1', '3000', '7');
INSERT INTO `ew_course` VALUES ('14', '语文', '9', '2', '类型？', '60', '10', '1', '600', '3');
INSERT INTO `ew_course` VALUES ('15', '13', null, null, null, null, null, '0', null, '3');
INSERT INTO `ew_course` VALUES ('16', '数试', null, null, null, null, null, '0', null, '3');
INSERT INTO `ew_course` VALUES ('17', '55667766545', null, null, null, null, null, '0', null, '3');
INSERT INTO `ew_course` VALUES ('18', '13485772433', null, null, null, null, null, '0', null, '3');
INSERT INTO `ew_course` VALUES ('19', '11111111111', null, null, null, null, null, '0', null, '3');
INSERT INTO `ew_course` VALUES ('20', '12121111111', null, null, null, null, null, '0', null, '3');
INSERT INTO `ew_course` VALUES ('21', '11011011011', null, null, null, null, null, '0', null, '3');
INSERT INTO `ew_course` VALUES ('23', '英语提高', '17', '24', null, '200', '30', '1', '6000', '7');
INSERT INTO `ew_course` VALUES ('25', '数学测', null, null, null, null, null, '0', null, '3');
INSERT INTO `ew_course` VALUES ('26', '一年级数学提高班', '45', '25', null, '120', '30', '1', '3600', '4');
INSERT INTO `ew_course` VALUES ('27', '二年级语文基础班', '2', '27', null, '80', '30', '1', '2400', '4');
INSERT INTO `ew_course` VALUES ('28', '二年级英语变态班', '2', '26', null, '250', '38', '1', '9500', '4');
INSERT INTO `ew_course` VALUES ('30', '数学测试', null, null, null, null, null, '0', null, '9');
INSERT INTO `ew_course` VALUES ('31', '我再试一哈', null, null, null, null, null, '0', null, '9');
INSERT INTO `ew_course` VALUES ('32', '数学', null, null, null, null, null, '0', null, '3');

-- ----------------------------
-- Table structure for ew_feedback
-- ----------------------------
DROP TABLE IF EXISTS `ew_feedback`;
CREATE TABLE `ew_feedback` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `feedback_classid` int(11) DEFAULT NULL COMMENT '班级ID',
  `feedback_teacherid` int(11) DEFAULT NULL COMMENT '老师ID',
  `feedback_studentid` int(11) DEFAULT NULL COMMENT '学生ID',
  `feedback_type` tinyint(1) DEFAULT '0' COMMENT '类型 默认0老师给学生 1学生给老师',
  `feedback_content` varchar(255) DEFAULT NULL COMMENT '评论内容',
  `feedback_gradeid` int(11) DEFAULT NULL COMMENT '评价等级 备用',
  `feedback_time` datetime DEFAULT NULL COMMENT '评论时间',
  `campusid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 COMMENT='师生评价表';

-- ----------------------------
-- Records of ew_feedback
-- ----------------------------
INSERT INTO `ew_feedback` VALUES ('1', '2', '1', '160', '0', '还行', '9', '0000-00-00 00:00:00', '3');
INSERT INTO `ew_feedback` VALUES ('2', '1', '1', '136', '0', 'eqwe', '1', '2016-08-16 17:07:42', '1');
INSERT INTO `ew_feedback` VALUES ('3', '1', '1', '136', '0', 'erwr', '1', '2016-08-08 17:08:04', '1');
INSERT INTO `ew_feedback` VALUES ('4', '30', '204', '621', '0', '人人网', '9', '2016-09-29 17:22:26', '3');
INSERT INTO `ew_feedback` VALUES ('5', '30', '204', '623', '0', '特尔', '9', '2016-09-29 17:29:07', '3');
INSERT INTO `ew_feedback` VALUES ('6', '2', '95', '611', '1', '这个老师不一般，不一般啊不一般', '9', '2016-09-29 18:32:42', '3');
INSERT INTO `ew_feedback` VALUES ('7', '30', '204', '595', '0', '好孩子', '3', '2016-10-08 14:38:54', '3');
INSERT INTO `ew_feedback` VALUES ('8', '2', '95', '611', '1', '貌似评价一会了吧', '9', '2016-10-08 17:39:29', '3');
INSERT INTO `ew_feedback` VALUES ('9', '30', '204', '452', '0', 'wewqe', '9', '2016-10-09 15:20:01', '3');
INSERT INTO `ew_feedback` VALUES ('10', '30', '204', '454', '0', 'ewrwer', '17', '2016-10-09 15:44:49', '3');
INSERT INTO `ew_feedback` VALUES ('11', '2', '95', '611', '1', '我再试一下', '9', '2016-10-09 17:00:26', '3');
INSERT INTO `ew_feedback` VALUES ('12', '2', '95', '611', '1', '最后', '9', '2016-10-09 17:12:31', '3');
INSERT INTO `ew_feedback` VALUES ('13', '2', '95', '611', '1', 'shoujimoshou ', '9', '2016-10-09 17:50:29', '3');

-- ----------------------------
-- Table structure for ew_grade
-- ----------------------------
DROP TABLE IF EXISTS `ew_grade`;
CREATE TABLE `ew_grade` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '年级ID',
  `grade_name` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '年级名称',
  `grade_remark` varchar(255) CHARACTER SET utf8 DEFAULT NULL COMMENT '备注',
  `campusid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='年级表';

-- ----------------------------
-- Records of ew_grade
-- ----------------------------
INSERT INTO `ew_grade` VALUES ('1', '一年级', '', '1');
INSERT INTO `ew_grade` VALUES ('2', '二年级', null, '4');
INSERT INTO `ew_grade` VALUES ('9', '三年级', '哈哈', '3');
INSERT INTO `ew_grade` VALUES ('3', '二年级', null, '3');
INSERT INTO `ew_grade` VALUES ('13', '八年级', null, '3');
INSERT INTO `ew_grade` VALUES ('14', '一年级', null, '3');
INSERT INTO `ew_grade` VALUES ('16', '铁心一年级', '铁心', '7');
INSERT INTO `ew_grade` VALUES ('17', '贴心二年级', '', '7');
INSERT INTO `ew_grade` VALUES ('18', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('19', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('20', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('21', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('22', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('23', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('24', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('25', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('26', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('27', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('28', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('29', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('30', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('31', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('32', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('33', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('34', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('35', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('36', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('37', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('38', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('39', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('40', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('41', '二年级', null, null);
INSERT INTO `ew_grade` VALUES ('42', '二年级', null, '6');
INSERT INTO `ew_grade` VALUES ('43', '三年级', null, '6');
INSERT INTO `ew_grade` VALUES ('44', '9年级', null, '3');
INSERT INTO `ew_grade` VALUES ('45', '一年级', '木有备注', '4');
INSERT INTO `ew_grade` VALUES ('47', '木有年级', null, '9');
INSERT INTO `ew_grade` VALUES ('48', '我靠', null, '9');
INSERT INTO `ew_grade` VALUES ('49', '二年级', null, '9');
INSERT INTO `ew_grade` VALUES ('50', '我再试试', null, '9');
INSERT INTO `ew_grade` VALUES ('51', '一年级', null, '6');
INSERT INTO `ew_grade` VALUES ('52', '全职', null, '3');
INSERT INTO `ew_grade` VALUES ('53', '女', null, '3');

-- ----------------------------
-- Table structure for ew_menus
-- ----------------------------
DROP TABLE IF EXISTS `ew_menus`;
CREATE TABLE `ew_menus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_menuid` int(11) NOT NULL,
  `menu_value` varchar(255) COLLATE utf8_bin NOT NULL,
  `menu_name` varchar(255) COLLATE utf8_bin NOT NULL,
  `menu_iconclass` varchar(255) COLLATE utf8_bin NOT NULL,
  `status` int(11) DEFAULT '1' COMMENT '0 禁用 1启用 默认启用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1005 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='菜单表';

-- ----------------------------
-- Records of ew_menus
-- ----------------------------
INSERT INTO `ew_menus` VALUES ('1', '0', 'menu', 'Menu', 'fa', '1');
INSERT INTO `ew_menus` VALUES ('2', '1', 'dashboard', '系统概况', 'fa fa-dashboard', '1');
INSERT INTO `ew_menus` VALUES ('3', '1', 'campus_manage', '校区管理', 'fa fa-group', '0');
INSERT INTO `ew_menus` VALUES ('4', '1', 'student', '学员管理', 'fa fa-calculator', '1');
INSERT INTO `ew_menus` VALUES ('5', '1', 'teacher', '老师管理', 'fa fa-group', '1');
INSERT INTO `ew_menus` VALUES ('6', '1', 'academic_manage', '教务管理', 'fa fa-suitcase', '1');
INSERT INTO `ew_menus` VALUES ('7', '1', 'teachers_students', '师生消息', 'fa fa-group', '1');
INSERT INTO `ew_menus` VALUES ('8', '1', 'form_count', '报表统计', 'fa fa-calculator', '1');
INSERT INTO `ew_menus` VALUES ('9', '1', 'notice_manage', '公告管理', 'fa fa-volume-up ', '1');
INSERT INTO `ew_menus` VALUES ('10', '1', 'system_settings', '系统设置', 'fa fa-cogs', '1');
INSERT INTO `ew_menus` VALUES ('31', '3', 'campus_manage', '校区管理', 'fa fa-building', '0');
INSERT INTO `ew_menus` VALUES ('32', '3', 'principal_manage', '校长管理', 'fa fa-male', '0');
INSERT INTO `ew_menus` VALUES ('41', '4', 'student_registration', '新学员报名', 'fa fa-paper-plane-o', '1');
INSERT INTO `ew_menus` VALUES ('42', '4', 'student_manage', '学员信息管理', 'fa fa-file-archive-o', '1');
INSERT INTO `ew_menus` VALUES ('43', '5', 'teacher_registration', '新老师注册', 'fa fa-paper-plane-o', '1');
INSERT INTO `ew_menus` VALUES ('44', '5', 'teacher_manage', '老师信息管理', 'fa fa-file-archive-o', '1');
INSERT INTO `ew_menus` VALUES ('61', '6', 'course_manage', '课程管理', 'fa fa-rub', '1');
INSERT INTO `ew_menus` VALUES ('62', '6', 'class_manage', '班级管理', 'fa fa-archive', '1');
INSERT INTO `ew_menus` VALUES ('63', '6', 'course_arrange', '排课管理', 'fa fa-pie-chart', '1');
INSERT INTO `ew_menus` VALUES ('64', '6', 'schedule_rollcall', '课表和点名', 'fa fa-paypal', '1');
INSERT INTO `ew_menus` VALUES ('65', '6', 'makeup_lessons', '补课管理', 'fa fa-slideshare', '1');
INSERT INTO `ew_menus` VALUES ('71', '7', 'feedback_manage', '师生评价', 'fa fa-eyedropper', '1');
INSERT INTO `ew_menus` VALUES ('91', '10', 'department_manage', '部门设置', 'fa fa-clipboard', '0');
INSERT INTO `ew_menus` VALUES ('92', '10', 'subject_manage', '科目设置', 'fa fa-ruble', '1');
INSERT INTO `ew_menus` VALUES ('93', '10', 'grade_manage', '年级设置', 'fa fa-copyright', '1');
INSERT INTO `ew_menus` VALUES ('94', '10', 'classroom_manage', '教室设置', 'fa fa-group', '1');
INSERT INTO `ew_menus` VALUES ('95', '10', 'classtime_manage', '上课时间设置', 'fa fa-key', '0');
INSERT INTO `ew_menus` VALUES ('96', '10', 'common_settings', '基础参数设置', 'fa fa-clipboard', '0');
INSERT INTO `ew_menus` VALUES ('97', '10', 'personal_settings', '个性化设置', 'fa fa-anchor', '1');
INSERT INTO `ew_menus` VALUES ('98', '10', 'menu_manage', '菜单管理', 'fa fa-server', '1');
INSERT INTO `ew_menus` VALUES ('99', '10', 'global_config', '系统设置', 'fa fa-cog', '0');
INSERT INTO `ew_menus` VALUES ('1000', '1', 'javascript:logout();', '退出', 'fa fa-sign-out', '1');
INSERT INTO `ew_menus` VALUES ('1001', '0', '', '', '', '1');
INSERT INTO `ew_menus` VALUES ('1003', '8', 'gate_card', '班级出勤率', 'fa fa-google-wallet', '1');
INSERT INTO `ew_menus` VALUES ('1004', '8', 'school_lession', '课消率', 'fa fa-paypal', '1');

-- ----------------------------
-- Table structure for ew_menus_copy
-- ----------------------------
DROP TABLE IF EXISTS `ew_menus_copy`;
CREATE TABLE `ew_menus_copy` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_menuid` int(11) NOT NULL,
  `menu_value` varchar(255) COLLATE utf8_bin NOT NULL,
  `menu_name` varchar(255) COLLATE utf8_bin NOT NULL,
  `menu_iconclass` varchar(255) COLLATE utf8_bin NOT NULL,
  `status` int(11) DEFAULT '1' COMMENT '0 禁用 1启用 默认启用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1005 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='菜单表';

-- ----------------------------
-- Records of ew_menus_copy
-- ----------------------------
INSERT INTO `ew_menus_copy` VALUES ('1', '0', 'menu', 'Menu', 'fa', '1');
INSERT INTO `ew_menus_copy` VALUES ('2', '1', 'dashboard', '系统概况', 'fa fa-dashboard', '1');
INSERT INTO `ew_menus_copy` VALUES ('3', '1', 'campus_manage', '校区管理', 'fa fa-group', '0');
INSERT INTO `ew_menus_copy` VALUES ('4', '1', 'student', '学员管理', 'fa fa-calculator', '1');
INSERT INTO `ew_menus_copy` VALUES ('5', '1', 'teacher', '老师管理', 'fa fa-group', '1');
INSERT INTO `ew_menus_copy` VALUES ('6', '1', 'academic_manage', '教务管理', 'fa fa-suitcase', '1');
INSERT INTO `ew_menus_copy` VALUES ('7', '1', 'teachers_students', '师生消息', 'fa fa-group', '1');
INSERT INTO `ew_menus_copy` VALUES ('8', '1', 'form_count', '报表统计', 'fa fa-calculator', '1');
INSERT INTO `ew_menus_copy` VALUES ('9', '1', 'notice_manage', '公告管理', 'fa fa-volume-up ', '1');
INSERT INTO `ew_menus_copy` VALUES ('10', '1', 'system_settings', '系统设置', 'fa fa-cogs', '1');
INSERT INTO `ew_menus_copy` VALUES ('31', '3', 'campus_manage', '校区管理', 'fa fa-building', '0');
INSERT INTO `ew_menus_copy` VALUES ('32', '3', 'principal_manage', '校长管理', 'fa fa-male', '0');
INSERT INTO `ew_menus_copy` VALUES ('41', '4', 'student_registration', '新学员报名', 'fa fa-paper-plane-o', '1');
INSERT INTO `ew_menus_copy` VALUES ('42', '4', 'student_manage', '学员信息管理', 'fa fa-file-archive-o', '1');
INSERT INTO `ew_menus_copy` VALUES ('43', '5', 'teacher_registration', '新老师注册', 'fa fa-paper-plane-o', '1');
INSERT INTO `ew_menus_copy` VALUES ('44', '5', 'teacher_manage', '老师信息管理', 'fa fa-file-archive-o', '1');
INSERT INTO `ew_menus_copy` VALUES ('61', '6', 'course_manage', '课程管理', 'fa fa-rub', '1');
INSERT INTO `ew_menus_copy` VALUES ('62', '6', 'class_manage', '班级管理', 'fa fa-archive', '1');
INSERT INTO `ew_menus_copy` VALUES ('63', '6', 'course_arrange', '排课管理', 'fa fa-pie-chart', '1');
INSERT INTO `ew_menus_copy` VALUES ('64', '6', 'schedule_rollcall', '课表和点名', 'fa fa-paypal', '1');
INSERT INTO `ew_menus_copy` VALUES ('65', '6', 'makeup_lessons', '补课管理', 'fa fa-slideshare', '1');
INSERT INTO `ew_menus_copy` VALUES ('71', '7', 'feedback_manage', '师生评价', 'fa fa-eyedropper', '1');
INSERT INTO `ew_menus_copy` VALUES ('91', '10', 'department_manage', '部门设置', 'fa fa-clipboard', '0');
INSERT INTO `ew_menus_copy` VALUES ('92', '10', 'subject_manage', '科目设置', 'fa fa-ruble', '1');
INSERT INTO `ew_menus_copy` VALUES ('93', '10', 'grade_manage', '年级设置', 'fa fa-copyright', '1');
INSERT INTO `ew_menus_copy` VALUES ('94', '10', 'classroom_manage', '教室设置', 'fa fa-group', '1');
INSERT INTO `ew_menus_copy` VALUES ('95', '10', 'classtime_manage', '上课时间设置', 'fa fa-key', '0');
INSERT INTO `ew_menus_copy` VALUES ('96', '10', 'common_settings', '基础参数设置', 'fa fa-clipboard', '0');
INSERT INTO `ew_menus_copy` VALUES ('97', '10', 'personal_settings', '个性化设置', 'fa fa-anchor', '1');
INSERT INTO `ew_menus_copy` VALUES ('98', '10', 'menu_manage', '菜单管理', 'fa fa-server', '1');
INSERT INTO `ew_menus_copy` VALUES ('99', '10', 'global_config', '系统设置', 'fa fa-cog', '0');
INSERT INTO `ew_menus_copy` VALUES ('1000', '1', 'javascript:logout();', '退出', 'fa fa-sign-out', '1');
INSERT INTO `ew_menus_copy` VALUES ('1001', '0', '', '', '', '1');
INSERT INTO `ew_menus_copy` VALUES ('1003', '8', 'gate_card', '班级出勤率', 'fa fa-google-wallet', '1');
INSERT INTO `ew_menus_copy` VALUES ('1004', '8', 'school_lession', '课消率', 'fa fa-paypal', '1');

-- ----------------------------
-- Table structure for ew_notice
-- ----------------------------
DROP TABLE IF EXISTS `ew_notice`;
CREATE TABLE `ew_notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `creator` int(11) DEFAULT NULL COMMENT '创建人',
  `title` varchar(255) DEFAULT NULL COMMENT '公告标题',
  `contents` varchar(255) DEFAULT NULL COMMENT '公告内容',
  `time` datetime DEFAULT NULL COMMENT '发布时间',
  `type` int(11) DEFAULT NULL COMMENT '公告类型 1分区后台公告 2学生端公告 3老师端公告',
  `status` int(11) DEFAULT '0' COMMENT '是否发布 0否 1是',
  `campusid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 COMMENT='公告表';

-- ----------------------------
-- Records of ew_notice
-- ----------------------------
INSERT INTO `ew_notice` VALUES ('3', '2', '通知去问去问我去额为全额', '实打实大都是', '2016-06-06 11:11:11', '1', '1', '3');
INSERT INTO `ew_notice` VALUES ('6', '2', '好消息', '按时打他个人算的撒的', '2016-08-18 18:23:40', '1', '1', '3');
INSERT INTO `ew_notice` VALUES ('9', '16', 'sssssssssss', 'sssssssssssss', '2016-08-19 19:06:31', '1', '1', '3');
INSERT INTO `ew_notice` VALUES ('11', '1', '卧槽特大消息饿我去恶趣味我去饿我去问·', '哈时间看到哈市的看见爱上的', '2016-08-25 00:00:00', '1', '1', '3');
INSERT INTO `ew_notice` VALUES ('13', '1', '王企鹅', '而且我', '2016-08-29 15:30:30', '1', '1', '3');
INSERT INTO `ew_notice` VALUES ('14', '2', '地区看网页护卫犬我去额为全额委屈恶趣味', '前五个结合全国五金和气温高', '2016-09-01 16:49:05', '1', '1', '3');
INSERT INTO `ew_notice` VALUES ('16', '1', '大厦', '瓦大大的', '2016-09-20 15:45:47', '1', '1', '3');
INSERT INTO `ew_notice` VALUES ('17', '2', 'EduWork 1.0版本初步成形中', 'EduWork 1.0版本初步成形中\r\nEduWork 1.0版本初步成形中\r\nEduWork 1.0版本初步成形中', '2016-09-21 07:01:45', '2', '1', '3');
INSERT INTO `ew_notice` VALUES ('18', '16', '铁心桥炸了', '我靠，咋了咋了，炸了炸了', '2016-09-22 11:25:42', '2', '1', '3');
INSERT INTO `ew_notice` VALUES ('20', '17', '我是qq校长', 'qq校长就是我，新官上任三把火', '2016-09-26 15:56:51', '3', '1', '4');
INSERT INTO `ew_notice` VALUES ('22', '1', '杀毒', '阿斯达多所', '2016-10-08 21:41:16', '1', '1', '3');

-- ----------------------------
-- Table structure for ew_permission
-- ----------------------------
DROP TABLE IF EXISTS `ew_permission`;
CREATE TABLE `ew_permission` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parentid` int(11) DEFAULT NULL COMMENT '父节点ID',
  `name` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '名称',
  `user_typeid` int(11) DEFAULT NULL COMMENT '用户类型id',
  `authname` varchar(20) COLLATE utf8_bin DEFAULT '1' COMMENT '权限名',
  `authvalue` int(11) DEFAULT '0' COMMENT '权限值',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='权限表 备用';

-- ----------------------------
-- Records of ew_permission
-- ----------------------------
INSERT INTO `ew_permission` VALUES ('1', '0', '权限表', '0', '1', '1');
INSERT INTO `ew_permission` VALUES ('2', '1', '登录', '1', 'Login', '1');

-- ----------------------------
-- Table structure for ew_personalconfig
-- ----------------------------
DROP TABLE IF EXISTS `ew_personalconfig`;
CREATE TABLE `ew_personalconfig` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userid` int(11) NOT NULL,
  `name` varchar(255) COLLATE utf8_bin NOT NULL,
  `value` int(11) NOT NULL,
  `remark` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=62 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='个性化设置表';

-- ----------------------------
-- Records of ew_personalconfig
-- ----------------------------
INSERT INTO `ew_personalconfig` VALUES ('2', '2', 'openAnimation', '1', '动画效果');
INSERT INTO `ew_personalconfig` VALUES ('3', '2', 'coursegridsize', '15', '课程列表每页显示数');
INSERT INTO `ew_personalconfig` VALUES ('4', '2', 'studentgridsize', '15', '学生列表每页显示数');
INSERT INTO `ew_personalconfig` VALUES ('5', '2', 'teachergridsize', '15', '教师列表每页显示数');
INSERT INTO `ew_personalconfig` VALUES ('50', '1', 'openAnimation', '1', '动画效果');
INSERT INTO `ew_personalconfig` VALUES ('51', '1', 'coursegridsize', '10', '课程列表每页显示数');
INSERT INTO `ew_personalconfig` VALUES ('52', '1', 'studentgridsize', '13', '学生列表每页显示数');
INSERT INTO `ew_personalconfig` VALUES ('53', '1', 'teachergridsize', '14', '教师列表每页显示数');
INSERT INTO `ew_personalconfig` VALUES ('54', '16', 'openAnimation', '1', '动画效果');
INSERT INTO `ew_personalconfig` VALUES ('55', '16', 'coursegridsize', '15', '课程列表每页显示数');
INSERT INTO `ew_personalconfig` VALUES ('56', '16', 'studentgridsize', '15', '学生列表每页显示数');
INSERT INTO `ew_personalconfig` VALUES ('57', '16', 'teachergridsize', '12', '教师列表每页显示数');
INSERT INTO `ew_personalconfig` VALUES ('58', '17', 'openAnimation', '1', '动画效果');
INSERT INTO `ew_personalconfig` VALUES ('59', '17', 'coursegridsize', '12', '课程列表每页显示数');
INSERT INTO `ew_personalconfig` VALUES ('60', '17', 'studentgridsize', '15', '学生列表每页显示数');
INSERT INTO `ew_personalconfig` VALUES ('61', '17', 'teachergridsize', '15', '教师列表每页显示数');

-- ----------------------------
-- Table structure for ew_schedule
-- ----------------------------
DROP TABLE IF EXISTS `ew_schedule`;
CREATE TABLE `ew_schedule` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `schedule_classid` int(11) NOT NULL COMMENT '班级ID',
  `schedule_courseid` int(11) NOT NULL,
  `schedule_gradeid` int(11) NOT NULL,
  `schedule_teacherid` int(11) NOT NULL COMMENT '任课老师ID',
  `schedule_classroomid` int(11) NOT NULL COMMENT '教室ID',
  `schedule_starttime` datetime DEFAULT NULL COMMENT '开始时间',
  `schedule_endtime` datetime DEFAULT NULL COMMENT '结束时间',
  `schedule_classover` varchar(100) DEFAULT NULL,
  `schedule_classbegin` varchar(100) DEFAULT NULL,
  `schedule_classlength` int(11) DEFAULT '0' COMMENT '上课时长 单位分',
  `schedule_perweek` int(11) DEFAULT NULL COMMENT '每周几 1周一 2周二  7 周日',
  `schedule_prenum` varchar(100) DEFAULT '' COMMENT '可上课学生数/应到上课学生数',
  `schedule_actnum` int(11) DEFAULT '0' COMMENT '实到人数',
  `schedule_sctnum` varchar(255) DEFAULT '0' COMMENT '实招人数',
  `schedule_status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态 0未上课 1已上课 2取消上课',
  `schedule_content` varchar(255) DEFAULT NULL COMMENT '上课内容',
  `schedule_remark` varchar(255) DEFAULT NULL COMMENT '备注',
  `campusid` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=369 DEFAULT CHARSET=utf8 COMMENT='班级排课表';

-- ----------------------------
-- Records of ew_schedule
-- ----------------------------
INSERT INTO `ew_schedule` VALUES ('285', '30', '23', '17', '204', '25', '2016-09-26 00:00:00', '2016-09-30 00:00:00', '13:45', '10:00', '225', '1', '1/45', '2', '4', '1', 'wq', 'wqe', '7');
INSERT INTO `ew_schedule` VALUES ('286', '30', '23', '17', '204', '25', '2016-09-27 00:00:00', '2016-09-30 00:00:00', '13:45', '10:00', '225', '2', '1/45', '3', '5', '1', 'eww', 'erwrsadaad', '7');
INSERT INTO `ew_schedule` VALUES ('287', '30', '23', '17', '204', '25', '2016-09-28 00:00:00', '2016-09-30 00:00:00', '13:45', '10:00', '225', '3', '1/45', '0', '0', '0', '开始旋转', '很好玩的一节课', '7');
INSERT INTO `ew_schedule` VALUES ('288', '30', '23', '17', '204', '25', '2016-09-29 00:00:00', '2016-09-30 00:00:00', '13:45', '10:00', '225', '4', '1/45', '0', '0', '0', null, null, '7');
INSERT INTO `ew_schedule` VALUES ('289', '30', '23', '17', '204', '25', '2016-09-30 00:00:00', '2016-09-30 00:00:00', '13:45', '10:00', '225', '5', '1/45', '0', '0', '2', null, null, '7');
INSERT INTO `ew_schedule` VALUES ('290', '29', '23', '17', '203', '24', '2016-09-24 00:00:00', '2016-09-30 00:00:00', '14:50', '13:05', '105', '6', '1/40', '0', '0', '0', null, null, '7');
INSERT INTO `ew_schedule` VALUES ('291', '29', '23', '17', '203', '24', '2016-09-25 00:00:00', '2016-09-30 00:00:00', '14:50', '13:05', '105', '0', '1/40', '0', '0', '0', null, null, '7');
INSERT INTO `ew_schedule` VALUES ('301', '2', '5', '9', '95', '19', '2016-09-28 00:00:00', '2016-09-30 00:00:00', '11:05', '09:00', '125', '3', '1/44', '0', '1', '1', '', '', '3');
INSERT INTO `ew_schedule` VALUES ('337', '2', '5', '9', '95', '2', '2016-09-19 00:00:00', '2016-09-24 00:00:00', '06:30', '05:25', '65', '1', '1/44', '0', '0', '0', null, null, '3');
INSERT INTO `ew_schedule` VALUES ('338', '2', '5', '9', '95', '2', '2016-09-20 00:00:00', '2016-09-24 00:00:00', '06:30', '05:25', '65', '2', '1/44', '0', '0', '0', null, null, '3');
INSERT INTO `ew_schedule` VALUES ('339', '2', '5', '9', '95', '2', '2016-09-21 00:00:00', '2016-09-24 00:00:00', '06:30', '05:25', '65', '3', '1/44', '0', '0', '0', null, null, '3');
INSERT INTO `ew_schedule` VALUES ('340', '59', '26', '45', '218', '27', '2016-09-26 00:00:00', '2016-09-30 00:00:00', '06:30', '05:25', '65', '1', '1/60', '0', '0', '2', null, null, '4');
INSERT INTO `ew_schedule` VALUES ('345', '60', '27', '2', '219', '28', '2016-09-27 00:00:00', '2016-09-30 00:00:00', '10:30', '09:00', '90', '2', '0/40', '0', '0', '0', null, null, '4');
INSERT INTO `ew_schedule` VALUES ('346', '60', '27', '2', '219', '28', '2016-09-28 00:00:00', '2016-09-30 00:00:00', '10:30', '09:00', '90', '3', '0/40', '0', '0', '0', null, null, '4');
INSERT INTO `ew_schedule` VALUES ('347', '60', '27', '2', '219', '28', '2016-09-29 00:00:00', '2016-09-30 00:00:00', '10:30', '09:00', '90', '4', '0/40', '0', '0', '0', null, null, '4');
INSERT INTO `ew_schedule` VALUES ('355', '59', '26', '45', '218', '27', '2016-09-26 00:00:00', '2016-09-29 00:00:00', '06:30', '05:25', '65', '1', '1/60', '0', '0', '0', null, null, '4');
INSERT INTO `ew_schedule` VALUES ('356', '59', '26', '45', '218', '27', '2016-09-27 00:00:00', '2016-09-29 00:00:00', '06:30', '05:25', '65', '2', '1/60', '0', '0', '0', null, null, '4');
INSERT INTO `ew_schedule` VALUES ('357', '59', '26', '45', '218', '27', '2016-09-28 00:00:00', '2016-09-29 00:00:00', '06:30', '05:25', '65', '3', '1/60', '0', '0', '0', null, null, '4');
INSERT INTO `ew_schedule` VALUES ('358', '13', '5', '9', '92', '21', '2016-10-10 00:00:00', '2016-10-15 00:00:00', '03:15', '02:10', '65', '1', '1/50', '0', '0', '0', null, null, '3');
INSERT INTO `ew_schedule` VALUES ('359', '13', '5', '9', '92', '21', '2016-10-11 00:00:00', '2016-10-15 00:00:00', '03:15', '02:10', '65', '2', '1/50', '0', '0', '0', null, null, '3');
INSERT INTO `ew_schedule` VALUES ('360', '13', '5', '9', '92', '21', '2016-10-12 00:00:00', '2016-10-15 00:00:00', '03:15', '02:10', '65', '3', '1/50', '0', '0', '0', null, null, '3');
INSERT INTO `ew_schedule` VALUES ('361', '13', '5', '9', '92', '21', '2016-10-13 00:00:00', '2016-10-15 00:00:00', '03:15', '02:10', '65', '4', '1/50', '0', '0', '0', null, null, '3');
INSERT INTO `ew_schedule` VALUES ('362', '13', '5', '9', '92', '21', '2016-10-14 00:00:00', '2016-10-15 00:00:00', '03:15', '02:10', '65', '5', '1/50', '0', '0', '0', null, null, '3');
INSERT INTO `ew_schedule` VALUES ('363', '2', '5', '9', '95', '2', '2016-10-11 00:00:00', '2016-10-11 00:00:00', '14:55', '13:55', '60', '2', '6/22', '0', '0', '0', null, null, '3');
INSERT INTO `ew_schedule` VALUES ('364', '15', '5', '9', '85', '22', '2016-10-11 00:00:00', '2016-10-11 00:00:00', '19:35', '06:50', '765', '2', '15/60', '0', '0', '0', null, null, '3');
INSERT INTO `ew_schedule` VALUES ('365', '3', '5', '9', '88', '19', '2016-10-11 00:00:00', '2016-10-11 00:00:00', '11:00', '07:35', '205', '2', '1/44', '0', '0', '0', null, null, '3');
INSERT INTO `ew_schedule` VALUES ('366', '2', '5', '9', '95', '19', '2016-10-17 00:00:00', '2016-10-19 00:00:00', '14:25', '13:25', '60', '1', '6/44', '0', '0', '0', null, null, '3');
INSERT INTO `ew_schedule` VALUES ('367', '3', '5', '9', '85', '2', '2016-10-17 00:00:00', '2016-10-21 00:00:00', '15:25', '14:30', '55', '1', '1/22', '0', '0', '0', null, null, '3');
INSERT INTO `ew_schedule` VALUES ('368', '3', '5', '9', '85', '2', '2016-10-18 00:00:00', '2016-10-21 00:00:00', '15:25', '14:30', '55', '2', '1/22', '0', '0', '0', null, null, '3');

-- ----------------------------
-- Table structure for ew_student
-- ----------------------------
DROP TABLE IF EXISTS `ew_student`;
CREATE TABLE `ew_student` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `campusid` int(11) DEFAULT NULL COMMENT '所属校区',
  `student_studentid` int(11) NOT NULL COMMENT '学号（年+几年级+班级+递增号）10位',
  `student_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL COMMENT '姓名',
  `student_classid` int(11) NOT NULL COMMENT '培训班级',
  `student_courseid` int(11) NOT NULL COMMENT '课程ID',
  `student_school` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '毕业学校',
  `student_gradeid` int(11) NOT NULL COMMENT '学校年级',
  `student_idcard` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '身份证',
  `student_phone` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '手机号码',
  `student_sex` tinyint(1) DEFAULT '0' COMMENT '性别 0男 1女',
  `student_cardnum` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '支付宝账号',
  `student_chargetime` date DEFAULT NULL COMMENT '收费日期',
  `student_createtime` datetime DEFAULT NULL COMMENT '报名创建时间',
  `student_status` int(4) DEFAULT '0' COMMENT '学生状态 0在读 1毕业',
  `student_remark` varchar(255) COLLATE utf8_bin DEFAULT NULL COMMENT '备注',
  PRIMARY KEY (`id`),
  KEY `index1` (`student_createtime`),
  KEY `index2` (`campusid`)
) ENGINE=MyISAM AUTO_INCREMENT=655 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='学员表';

-- ----------------------------
-- Records of ew_student
-- ----------------------------
INSERT INTO `ew_student` VALUES ('625', '4', '2016026101', '前期学生1', '61', '28', '', '2', '998877665544556677', '15288776655', '0', '', null, '2016-09-25 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('159', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('160', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '1', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('161', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '1', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('163', '3', '2016090201', 'chys', '13', '2', '', '3', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('164', '3', '2016090201', 'chys', '13', '2', '阜师院', '3', '341181199210131011', '13485772433', '1', '15655899016', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('165', '3', '2016090201', 'chys', '13', '2', 'td', '3', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('166', '3', '2016090201', 'chys', '13', '2', '', '3', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('167', '3', '2016090201', 'chys', '13', '2', '', '3', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('168', '3', '2016090201', 'chys', '13', '2', '', '3', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('169', '3', '2016090201', 'chys', '2', '2', '', '3', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('170', '3', '2016090201', 'chys', '13', '5', '45454555', '3', '341181199210131311', '13485772344', '1', '13485772344', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('171', '3', '2016090201', 'shu2', '15', '5', '', '3', '341181199210131011', '13485772433', '1', '13485772344', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('172', '3', '2016090201', '好玩', '15', '5', '', '3', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('173', '3', '2016090201', '某某某2', '15', '5', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('174', '3', '2016090201', '刘德华', '15', '5', '65656', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('175', '3', '2016090201', '张学友', '15', '5', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('176', '3', '2016090201', '达到', '15', '5', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('177', '3', '2016090201', '黎明', '15', '5', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('178', '3', '2016090201', 'chys', '13', '2', '', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('179', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('180', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('601', '3', '2016032607', 'll', '26', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('603', '3', '2016032608', 'll', '26', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('604', '3', '2016440202', 'll', '2', '2', '麻省理工2', '44', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('605', '3', '2016032609', 'll', '26', '25', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('606', '3', '2016440203', 'll', '2', '2', '麻省理工2', '44', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-24 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('607', '3', '2016032610', 'll', '26', '25', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-24 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('608', '3', '2016440204', 'll', '2', '2', '麻省理工2', '44', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-24 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('609', '3', '2016032611', 'll', '26', '25', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-24 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('610', '3', '2016090227', '派克测试', '2', '5', '', '9', '009988776787876565', '13566778899', '0', '', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('611', '3', '2016090228', '派克测试', '2', '5', '清华牌北大', '9', '009988776787876565', '13577778899', '0', '', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('612', '3', '2016090229', '派克测试', '2', '5', '', '9', '009988776787876565', '13566778899', '0', '', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('613', '3', '2016090230', '排课测试', '2', '5', '', '9', '009988776655443322', '13455667788', '0', '', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('614', '3', '2016090231', '排课测试', '2', '5', '', '9', '009988776655443322', '13455667788', '0', '', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('615', '3', '2016090232', '排课测试', '2', '5', '', '9', '009988776655443322', '13455667788', '0', '', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('616', '3', '2016092401', '反倒是', '24', '2', '', '9', '167889898765442534', '15677887788', '0', '', null, '2016-09-24 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('617', '3', '2016092402', '反倒是', '24', '2', '', '9', '167889898765442534', '15677887788', '0', '', null, '2016-09-24 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('618', '3', '2016092403', '反倒是', '24', '2', '', '9', '167889898765442534', '15677887788', '0', '', null, '2016-09-24 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('619', '3', '2016092404', '反倒是', '24', '2', '', '9', '167889898765442534', '15677887788', '0', '', null, '2016-09-24 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('620', '3', '2016092405', '一天是', '24', '2', '', '9', '009988990099009900', '15699887766', '0', '', null, '2016-09-17 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('621', '3', '2016092804', '很多事', '30', '10', '', '9', '009988776677554455', '15877665544', '1', '', null, '2016-09-21 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('622', '3', '2016092805', '我是女', '28', '10', '', '9', '009988776655443322', '18677779999', '1', '', null, '2016-09-14 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('623', '3', '2016092806', '我靠', '30', '10', '', '9', '990088776655555555', '15699887766', '1', '', null, '2016-09-14 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('624', '3', '2016092406', 's', '24', '2', '111', '9', '111111111111111111', '15852636595', '0', '', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('626', '4', '2016455901', '前期学生2', '59', '26', '', '45', '998877665544556677', '15666667777', '1', '', null, '2016-09-20 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('628', '9', '2016496301', 'chys', '63', '30', '麻省理工2', '49', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-26 00:00:00', '0', '走后门的大神');
INSERT INTO `ew_student` VALUES ('629', '9', '2016506401', '嘎多睡', '64', '31', 'WWI', '50', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-09-26 00:00:00', '0', '单身狗');
INSERT INTO `ew_student` VALUES ('630', '3', '2016440205', 'll', '2', '2', '麻省理工2', '44', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-28 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('631', '3', '2016032612', 'll', '26', '25', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-28 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('632', '3', '2016092407', 'x', '24', '2', '111', '9', '320623198805013369', '15852636595', '0', '', null, '2016-10-09 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('633', '3', '2016440206', 'll', '2', '2', '麻省理工2', '44', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('634', '3', '2016032612', 'll', '26', '25', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('635', '3', '2016440207', 'll', '2', '2', '麻省理工2', '44', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('636', '3', '2016032613', 'll', '26', '25', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('637', '3', '2016440208', 'll', '2', '2', '麻省理工2', '44', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('638', '3', '2016032614', 'll', '26', '25', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('449', '3', '2016092801', '潘永欣', '28', '10', 'wqewqe', '9', '111111111111111111', '11111111111', '0', '11111111111', null, '2016-09-27 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('450', '3', '2016032801', '小明', '28', '10', '特心情', '3', '320623155202013312', '15852938235', '0', '110', null, '2016-09-21 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('451', '3', '2016092802', '李福林', '28', '10', '特心情', '9', '320623152236202235', '13910232564', '0', '112', null, '2016-09-21 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('452', '3', '2016092803', '麻微微', '30', '10', '特心情', '9', '320623911205013354', '15852695362', '1', '113', null, '2016-09-21 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('453', '7', '2016162901', '阿凡达', '29', '23', '', '16', '888888888888888888', '13456767678', '0', '', null, '2016-09-22 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('454', '3', '2016173001', '卡扎菲', '30', '23', '', '17', '999444994499449944', '15494949494', '1', '', null, '2016-09-21 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('456', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('457', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('458', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('459', '3', '2016010201', 'll', '25', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('460', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('552', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('553', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('554', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('555', '3', '2016010201', 'll', '25', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('556', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('557', '3', '2016010201', 'll', '26', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('558', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('559', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('560', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('561', '3', '2016010201', 'll', '25', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('562', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('563', '3', '2016010201', 'll', '26', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('576', '3', '2016030246', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('577', '3', '2016030247', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('578', '3', '2016030248', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('579', '3', '2016032505', 'll', '25', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('580', '3', '2016030249', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('581', '3', '2016032604', 'll', '26', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('582', '3', '2016030250', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('583', '3', '2016030251', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('584', '3', '2016030252', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('585', '3', '2016032506', 'll', '25', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('586', '3', '2016030253', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('587', '3', '2016032605', 'll', '26', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('588', '6', '2016425701', 'chys', '57', '0', '麻省理工2', '42', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '走后门的大神');
INSERT INTO `ew_student` VALUES ('589', '6', '2016435801', 'lily', '58', '0', '南京', '43', '4.1052619920302E+17', '17093759032', '1', '15236895456', null, '2016-09-22 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('590', '3', '2016030254', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('591', '3', '2016030255', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('592', '3', '2016030256', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('593', '3', '2016032507', 'll', '25', '14', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('594', '3', '2016030257', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('595', '3', '2016032606', 'll', '30', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('596', '3', '2016030258', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('597', '3', '2016030259', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('598', '3', '2016030260', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('602', '3', '2016440201', 'll', '2', '2', '麻省理工2', '44', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('600', '3', '2016030261', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-09-22 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('291', '3', '2016090201', '张学友', '15', '5', '', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('292', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('293', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('294', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('295', '3', '2016090201', 'chys', '13', '2', '', '3', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('296', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('297', '3', '2016090201', '好玩', '15', '5', '', '3', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('298', '3', '2016090201', 'chys', '13', '2', '', '3', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('299', '3', '2016090201', 'chys', '13', '2', '', '3', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('300', '3', '2016090201', 'chys', '13', '2', '', '3', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('301', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('302', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('303', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('304', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('305', '3', '2016090201', '某某某2', '15', '5', '', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('306', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('307', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('308', '3', '2016090201', 'chys', '13', '2', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('309', '3', '2016090201', '黎明', '15', '5', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('310', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('311', '3', '2016090201', 'chys', '2', '2', '', '3', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('312', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('313', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('314', '3', '2016090201', 'chys', '13', '2', '', '3', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('315', '3', '2016090201', '某某某2', '15', '5', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('316', '3', '2016090201', 'shu2', '15', '5', '', '3', '341181199210131011', '13485772433', '0', '13485772344', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('317', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('318', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('319', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('320', '3', '2016090201', '达到', '15', '5', '', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('321', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('322', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('323', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('324', '3', '2016090201', 'shu2', '15', '5', '', '3', '341181199210131011', '13485772433', '1', '13485772344', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('325', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('326', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('327', '3', '2016090201', 'chys', '13', '2', 'td', '3', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('328', '3', '2016090201', 'chys', '13', '2', '阜师院', '3', '341181199210131011', '13485772433', '0', '15655899016', null, '2016-09-01 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('341', '3', '2016010201', 'll', '2', '2', '麻省理工2', '0', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('330', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('331', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '0', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('332', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '1', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('333', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '1', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('334', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '0', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('335', '3', '2016020305', '看看', '3', '2', '', '3', '123456789009876543', '98989898098', '1', '', null, '2016-08-16 14:56:19', '0', '');
INSERT INTO `ew_student` VALUES ('336', '3', '2016020305', '看看', '3', '2', '', '3', '123456789009876543', '98989898098', '0', '', null, '2016-08-16 14:56:19', '0', '');
INSERT INTO `ew_student` VALUES ('337', '3', '2016031304', '212', '13', '2', 'fefew', '9', '222111111111111111', '12111111111', '1', '11111111111', null, '2016-09-05 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('338', '3', '2016031304', '212', '13', '2', 'fefew', '9', '222111111111111111', '12111111111', '0', '11111111111', null, '2016-09-05 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('339', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '0', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('340', '3', '2016090201', 'chys', '2', '2', '', '9', '341181199210131011', '13485772433', '1', '13485772433', null, '2016-09-01 14:59:08', '0', '');
INSERT INTO `ew_student` VALUES ('353', '3', '2016010201', 'll', '2', '2', '麻省理工2', '0', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('354', '3', '2016010201', 'll', '2', '2', '麻省理工2', '2', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('355', '3', '2016010202', 'wwqew', '13', '2', 'db', '2', '222222222222222222', '11111111111', '0', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('377', '3', '2016010201', 'll', '2', '2', '麻省理工2', '13', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('378', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('379', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '0', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('380', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '1', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('381', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '1', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('382', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '0', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('383', '3', '2016010201', 'll', '2', '2', '麻省理工2', '13', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('384', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('385', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '0', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('386', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '1', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('387', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '1', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('388', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '0', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('389', '3', '2016010201', 'll', '2', '2', '麻省理工2', '13', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('390', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('391', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '0', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('392', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '1', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('393', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '1', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('394', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '0', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('395', '3', '2016010201', 'll', '2', '15', '麻省理工2', '13', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('396', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('397', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '0', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('398', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '1', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('399', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '1', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('400', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '0', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('401', '3', '2016010201', 'll', '2', '16', '麻省理工2', '13', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('402', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('403', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '0', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('404', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '1', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('405', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '1', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('406', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '0', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('407', '3', '2016010201', 'll', '18', '16', '麻省理工2', '13', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('408', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('409', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '0', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('410', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '1', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('411', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '1', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('412', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '0', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('413', '3', '2016010201', 'll', '18', '16', '麻省理工2', '13', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('414', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('415', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '0', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('416', '3', '2016010202', 'wwqew', '13', '2', 'db', '3', '222222222222222222', '11111111111', '1', '11111111111', null, '2016-08-29 00:00:00', '0', '1');
INSERT INTO `ew_student` VALUES ('417', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '1', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('418', '3', '2016020201', '测试', '13', '2', '121212121212121121', '3', '121212121212121121', '12345678900', '0', '121212121212', null, '2016-08-29 00:00:00', '0', '是');
INSERT INTO `ew_student` VALUES ('419', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('420', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('421', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('422', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('423', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('424', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('425', '3', '2016010201', 'll', '2', '16', '麻省理工2', '13', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('426', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('427', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('428', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('429', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('430', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('431', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('432', '3', '2016010201', 'll', '2', '16', '麻省理工2', '13', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('433', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('434', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('435', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('436', '3', '2016010201', 'll', '24', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('437', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('438', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('439', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('440', '3', '2016010201', 'll', '3', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('441', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('442', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '1', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('443', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('444', '3', '2016010201', 'll', '25', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('445', '3', '2016010201', 'll', '2', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('446', '3', '2016010201', 'll', '26', '2', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-08-29 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('447', '3', '2016090281', 'ds', '2', '2', '11', '9', '111111111111111111', '15852636595', '0', '', null, '2016-09-20 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('448', '3', '2016090302', 'dddddd', '3', '5', '111', '9', '111111111111111111', '15852636595', '0', '', null, '2016-09-20 00:00:00', '0', '');
INSERT INTO `ew_student` VALUES ('639', '3', '2016440209', 'll', '2', '2', '麻省理工2', '44', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('640', '3', '2016032615', 'll', '26', '25', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('641', '3', '2016440210', 'll', '2', '2', '麻省理工2', '44', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('644', '3', '2016032617', 'll', '26', '25', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('645', '3', '2016440212', 'll', '2', '2', '麻省理工2', '44', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('646', '3', '2016032618', 'll', '26', '25', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('647', '3', '2016440213', 'll', '2', '2', '麻省理工2', '44', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('648', '3', '2016032619', 'll', '26', '25', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('649', '3', '2016440214', 'll', '2', '2', '麻省理工2', '44', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('650', '3', '2016032620', 'll', '26', '25', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('651', '3', '2016440215', 'll', '2', '2', '麻省理工2', '44', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('652', '3', '2016032621', 'll', '26', '25', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('653', '3', '2016440216', 'll', '2', '2', '麻省理工2', '44', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');
INSERT INTO `ew_student` VALUES ('654', '3', '2016032622', 'll', '26', '25', '麻省理工2', '3', '341181100213101013', '13222222221', '0', '13222222221', null, '2016-10-10 00:00:00', '0', '大大');

-- ----------------------------
-- Table structure for ew_subject
-- ----------------------------
DROP TABLE IF EXISTS `ew_subject`;
CREATE TABLE `ew_subject` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `campusid` int(11) DEFAULT NULL,
  `subject_name` varchar(255) DEFAULT NULL COMMENT '科目名称',
  `subject_remark` varchar(255) DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8 COMMENT='科目表';

-- ----------------------------
-- Records of ew_subject
-- ----------------------------
INSERT INTO `ew_subject` VALUES ('1', '1', '数学', '');
INSERT INTO `ew_subject` VALUES ('2', '3', '英语', null);
INSERT INTO `ew_subject` VALUES ('3', '1', '语文', null);
INSERT INTO `ew_subject` VALUES ('4', '3', '语文', '');
INSERT INTO `ew_subject` VALUES ('20', '3', '数学', null);
INSERT INTO `ew_subject` VALUES ('21', '3', '英', null);
INSERT INTO `ew_subject` VALUES ('22', '7', '铁心数学', '');
INSERT INTO `ew_subject` VALUES ('23', '7', '铁心语文', '贴心的');
INSERT INTO `ew_subject` VALUES ('24', '7', '贴心英语', '');
INSERT INTO `ew_subject` VALUES ('25', '4', '数学', '提高逻辑');
INSERT INTO `ew_subject` VALUES ('26', '4', '英语', '提高口语水平');
INSERT INTO `ew_subject` VALUES ('27', '4', '语文', '提高素质');
INSERT INTO `ew_subject` VALUES ('29', '9', '数学', null);
INSERT INTO `ew_subject` VALUES ('30', '9', '我擦', null);
INSERT INTO `ew_subject` VALUES ('31', '6', '数学', null);
INSERT INTO `ew_subject` VALUES ('32', '3', '数学测试', null);

-- ----------------------------
-- Table structure for ew_teacher
-- ----------------------------
DROP TABLE IF EXISTS `ew_teacher`;
CREATE TABLE `ew_teacher` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `campusid` int(11) NOT NULL COMMENT '所属校区',
  `teacher_name` varchar(255) DEFAULT NULL COMMENT '姓名',
  `teacher_gender` int(11) DEFAULT '0' COMMENT '性别 0男 1女',
  `teacher_idcard` varchar(255) DEFAULT NULL COMMENT '身份证号码',
  `teacher_bankaccount` varchar(255) DEFAULT NULL,
  `teacher_jobtype` int(11) DEFAULT '0' COMMENT '在职类型 0兼职 1全职',
  `teacher_subject_id` int(11) NOT NULL COMMENT '科目id',
  `teacher_grade_id` int(11) NOT NULL COMMENT '级别（年级）id',
  `teacher_telphone` varchar(255) DEFAULT NULL COMMENT '联系方式（手机号码）',
  `teacher_email` varchar(255) DEFAULT NULL COMMENT '邮箱',
  `teacher_qq` varchar(255) DEFAULT NULL COMMENT 'QQ号码',
  `teacher_joindate` date DEFAULT NULL COMMENT '入职日期',
  `teacher_status` int(11) DEFAULT '0' COMMENT '状态 是否正式员工 0不是 1是',
  `teacher_befulldate` date DEFAULT NULL COMMENT '转正日期',
  `teacher_remark` varchar(255) NOT NULL COMMENT '备注',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=282 DEFAULT CHARSET=utf8 COMMENT='老师表';

-- ----------------------------
-- Records of ew_teacher
-- ----------------------------
INSERT INTO `ew_teacher` VALUES ('1', '1', '隔壁老王', '0', '888888887788778877', '87878888888888888', '1', '1', '1', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('95', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('92', '3', '宋老师不是人', '0', '987654321012345678', '62476854702546957', '1', '4', '3', '15896853256', 'song12@126.com', '26512352', '2016-09-19', '1', '2016-09-19', 'fhdksahf;ldsahf');
INSERT INTO `ew_teacher` VALUES ('85', '3', 'chys', '0', '341181199210131011', '626260022222222222', '1', '2', '9', '13485772433', '762264605@qq.com', '762264605', '2016-09-01', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('88', '3', '你是谁', '0', '121111111111111111', '2111111111111111111', '1', '4', '3', '12121111111', '45454584@qq.com', '41111111', '2016-09-15', '1', '2016-09-20', '');
INSERT INTO `ew_teacher` VALUES ('89', '3', '234234', '0', '444444444444444444', '1112222222222222222', '1', '4', '9', '11111111111', '454545@qq.com', '121212111', '2016-09-28', '0', '2016-09-27', '4254');
INSERT INTO `ew_teacher` VALUES ('93', '1', '宋老师', '0', '320623199205013369', '3206665229636233', '1', '1', '1', '11011011011', 'sss@qq.com', '15151515', '2016-09-19', '0', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('90', '3', 'choujie女生', '1', '333333333333333333', '2111111111111111111', '1', '4', '9', '11111111111', '5454545@qq.com', '122222222', '2016-09-12', '1', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('94', '3', '黄飞鸿', '0', '876536456746546547', '13131312312312312', '0', '2', '3', '18655443322', '56478236@qq.com', '3789123', '2016-09-21', '0', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('96', '3', 'chys', '0', '341181199210131011', '626260022222222222', '1', '2', '9', '13485772433', '762264605@qq.com', '762264605', '2016-09-01', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('97', '3', 'choujie女生', '1', '333333333333333333', '2111111111111111111', '1', '4', '9', '11111111111', '5454545@qq.com', '122222222', '2016-09-12', '1', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('98', '3', '你是谁', '0', '121111111111111111', '2111111111111111111', '1', '4', '3', '12121111111', '45454584@qq.com', '41111111', '2016-09-15', '1', '2016-09-20', '');
INSERT INTO `ew_teacher` VALUES ('99', '3', '宋老师', '0', '320623199205013369', '3206665229636233', '1', '20', '14', '11011011011', 'sss@qq.com', '15151515', '2016-09-19', '0', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('100', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('101', '3', 'chys', '0', '341181199210131011', '626260022222222222', '1', '21', '9', '13485772433', '762264605@qq.com', '762264605', '2016-09-01', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('102', '3', 'choujie女生', '1', '333333333333333333', '2111111111111111111', '1', '4', '9', '11111111111', '5454545@qq.com', '122222222', '2016-09-12', '1', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('103', '3', '你是谁', '0', '121111111111111111', '2111111111111111111', '1', '4', '3', '12121111111', '45454584@qq.com', '41111111', '2016-09-15', '1', '2016-09-20', '');
INSERT INTO `ew_teacher` VALUES ('104', '3', '宋老师', '0', '320623199205013369', '3206665229636233', '1', '20', '14', '11011011011', 'sss@qq.com', '15151515', '2016-09-19', '0', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('105', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('106', '3', 'chys', '0', '341181199210131011', '626260022222222222', '1', '21', '9', '13485772433', '762264605@qq.com', '762264605', '2016-09-01', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('107', '3', 'choujie女生', '1', '333333333333333333', '2111111111111111111', '1', '4', '9', '11111111111', '5454545@qq.com', '122222222', '2016-09-12', '1', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('108', '3', '你是谁', '0', '121111111111111111', '2111111111111111111', '1', '4', '3', '12121111111', '45454584@qq.com', '41111111', '2016-09-15', '1', '2016-09-20', '');
INSERT INTO `ew_teacher` VALUES ('109', '3', '宋老师', '0', '320623199205013369', '3206665229636233', '1', '20', '14', '11011011011', 'sss@qq.com', '15151515', '2016-09-19', '0', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('110', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('111', '3', 'chys', '0', '341181199210131011', '626260022222222222', '1', '21', '9', '13485772433', '762264605@qq.com', '762264605', '2016-09-01', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('112', '3', 'choujie女生', '1', '333333333333333333', '2111111111111111111', '1', '4', '9', '11111111111', '5454545@qq.com', '122222222', '2016-09-12', '1', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('113', '3', '你是谁', '0', '121111111111111111', '2111111111111111111', '1', '4', '3', '12121111111', '45454584@qq.com', '41111111', '2016-09-15', '1', '2016-09-20', '');
INSERT INTO `ew_teacher` VALUES ('114', '3', '宋老师', '0', '320623199205013369', '3206665229636233', '1', '20', '14', '11011011011', 'sss@qq.com', '15151515', '2016-09-19', '0', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('115', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('116', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('117', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('118', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('119', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('120', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('121', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('145', '3', '是最骚的', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('146', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('147', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('148', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('149', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('150', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('151', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('152', '3', 'chys', '0', '341181199210131011', '626260022222222222', '1', '21', '9', '13485772433', '762264605@qq.com', '762264605', '2016-09-01', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('153', '3', 'chys', '0', '341181199210131011', '626260022222222222', '1', '2', '9', '13485772433', '762264605@qq.com', '762264605', '2016-09-01', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('154', '3', 'chys', '0', '341181199210131011', '626260022222222222', '1', '21', '9', '13485772433', '762264605@qq.com', '762264605', '2016-09-01', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('155', '3', 'chys', '0', '341181199210131011', '626260022222222222', '1', '2', '9', '13485772433', '762264605@qq.com', '762264605', '2016-09-01', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('156', '3', 'chys', '0', '341181199210131011', '626260022222222222', '1', '21', '9', '13485772433', '762264605@qq.com', '762264605', '2016-09-01', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('157', '3', 'choujie女生', '1', '333333333333333333', '2111111111111111111', '1', '4', '9', '11111111111', '5454545@qq.com', '122222222', '2016-09-12', '1', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('158', '3', 'choujie女生', '1', '333333333333333333', '2111111111111111111', '1', '4', '9', '11111111111', '5454545@qq.com', '122222222', '2016-09-12', '1', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('159', '3', 'choujie女生', '1', '333333333333333333', '2111111111111111111', '1', '4', '9', '11111111111', '5454545@qq.com', '122222222', '2016-09-12', '1', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('160', '3', 'choujie女生', '1', '333333333333333333', '2111111111111111111', '1', '4', '9', '11111111111', '5454545@qq.com', '122222222', '2016-09-12', '1', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('161', '3', 'choujie女生', '1', '333333333333333333', '2111111111111111111', '1', '4', '9', '11111111111', '5454545@qq.com', '122222222', '2016-09-12', '1', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('162', '3', '你是谁', '0', '121111111111111111', '2111111111111111111', '1', '4', '3', '12121111111', '45454584@qq.com', '41111111', '2016-09-15', '1', '2016-09-20', '');
INSERT INTO `ew_teacher` VALUES ('163', '3', '你是谁', '0', '121111111111111111', '2111111111111111111', '1', '4', '3', '12121111111', '45454584@qq.com', '41111111', '2016-09-15', '1', '2016-09-20', '');
INSERT INTO `ew_teacher` VALUES ('164', '3', '你是谁', '0', '121111111111111111', '2111111111111111111', '1', '4', '3', '12121111111', '45454584@qq.com', '41111111', '2016-09-15', '1', '2016-09-20', '');
INSERT INTO `ew_teacher` VALUES ('165', '3', '你是谁', '0', '121111111111111111', '2111111111111111111', '1', '4', '3', '12121111111', '45454584@qq.com', '41111111', '2016-09-15', '1', '2016-09-20', '');
INSERT INTO `ew_teacher` VALUES ('166', '3', '你是谁', '0', '121111111111111111', '2111111111111111111', '1', '4', '3', '12121111111', '45454584@qq.com', '41111111', '2016-09-15', '1', '2016-09-20', '');
INSERT INTO `ew_teacher` VALUES ('167', '3', '宋老师', '0', '320623199205013369', '3206665229636233', '1', '20', '14', '11011011011', 'sss@qq.com', '15151515', '2016-09-19', '0', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('168', '3', '宋老师', '0', '320623199205013369', '3206665229636233', '1', '20', '14', '11011011011', 'sss@qq.com', '15151515', '2016-09-19', '0', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('169', '3', '宋老师', '0', '320623199205013369', '3206665229636233', '1', '20', '14', '11011011011', 'sss@qq.com', '15151515', '2016-09-19', '0', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('170', '3', '宋老师不是人', '0', '987654321012345678', '62476854702546957', '1', '4', '3', '15896853256', 'song12@126.com', '26512352', '2016-09-19', '1', '2016-09-19', 'fhdksahf;ldsahf');
INSERT INTO `ew_teacher` VALUES ('171', '3', '宋老师', '0', '320623199205013369', '3206665229636233', '1', '20', '14', '11011011011', 'sss@qq.com', '15151515', '2016-09-19', '0', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('172', '3', '宋老师', '0', '320623199205013369', '3206665229636233', '1', '20', '14', '11011011011', 'sss@qq.com', '15151515', '2016-09-19', '0', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('173', '3', '是最骚的', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('174', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('175', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('176', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('177', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('178', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('179', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '15', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('180', '3', 'chys', '0', '341181199210131011', '626260022222222222', '1', '21', '9', '13485772433', '762264605@qq.com', '762264605', '2016-09-01', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('181', '3', 'chys', '0', '341181199210131011', '626260022222222222', '1', '2', '9', '13485772433', '762264605@qq.com', '762264605', '2016-09-01', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('182', '3', 'chys', '0', '341181199210131011', '626260022222222222', '1', '21', '9', '13485772433', '762264605@qq.com', '762264605', '2016-09-01', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('183', '3', 'chys', '0', '341181199210131011', '626260022222222222', '1', '2', '9', '13485772433', '762264605@qq.com', '762264605', '2016-09-01', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('184', '3', 'chys', '0', '341181199210131011', '626260022222222222', '1', '21', '9', '13485772433', '762264605@qq.com', '762264605', '2016-09-01', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('185', '3', 'choujie女生', '1', '333333333333333333', '2111111111111111111', '1', '4', '9', '11111111111', '5454545@qq.com', '122222222', '2016-09-12', '1', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('186', '3', 'choujie女生', '1', '333333333333333333', '2111111111111111111', '1', '4', '9', '11111111111', '5454545@qq.com', '122222222', '2016-09-12', '1', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('187', '3', 'choujie女生', '1', '333333333333333333', '2111111111111111111', '1', '4', '9', '11111111111', '5454545@qq.com', '122222222', '2016-09-12', '1', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('188', '3', 'choujie女生', '1', '333333333333333333', '2111111111111111111', '1', '4', '9', '11111111111', '5454545@qq.com', '122222222', '2016-09-12', '1', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('189', '3', 'choujie女生', '1', '333333333333333333', '2111111111111111111', '1', '4', '9', '11111111111', '5454545@qq.com', '122222222', '2016-09-12', '1', '2016-09-21', '');
INSERT INTO `ew_teacher` VALUES ('190', '3', '你是谁', '0', '121111111111111111', '2111111111111111111', '1', '4', '3', '12121111111', '45454584@qq.com', '41111111', '2016-09-15', '1', '2016-09-20', '');
INSERT INTO `ew_teacher` VALUES ('201', '3', '刘德华', '0', '434343434343434343', '', '1', '4', '13', '13245678967', '', '', '2016-09-21', '1', '0000-00-00', '');
INSERT INTO `ew_teacher` VALUES ('202', '3', '王菲', '1', '343443434343434343', '', '0', '20', '9', '15466778899', '', '', '2016-09-24', '0', '0000-00-00', '');
INSERT INTO `ew_teacher` VALUES ('203', '7', '铁蜈蚣', '0', '767676767676767676', '', '1', '24', '17', '13288877766', '', '', '2016-09-22', '1', '2016-10-22', '');
INSERT INTO `ew_teacher` VALUES ('204', '7', '铁人十三', '1', '123465678787655678', '', '0', '23', '16', '15299998888', '415454545@163.com', '', '2016-09-24', '1', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('212', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('213', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('214', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('215', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('216', '3', '是最骚的', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('217', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('218', '4', '前期老师1', '0', '667766778899889900', '', '0', '25', '2', '15277778888', '', '', '2016-09-26', '0', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('219', '4', '前期老师2 ', '1', '667766778899889900', '', '1', '26', '45', '13499889988', '', '', '2016-09-25', '0', '2016-09-30', '');
INSERT INTO `ew_teacher` VALUES ('221', '9', '问我', '0', '888888887788778877', '87878888888888888', '1', '29', '47', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '1', '2016-08-08', '走后门的大神');
INSERT INTO `ew_teacher` VALUES ('222', '9', '让人', '1', '889900776655443322', '87878888888888888', '0', '30', '48', '55667766545', '61336161@qq.com', '434324', '0000-00-00', '1', '0000-00-00', '我是谁');
INSERT INTO `ew_teacher` VALUES ('223', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('224', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('225', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('226', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('227', '3', '是最骚的', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('228', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('229', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('230', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('231', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('232', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('233', '3', '是最骚的', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('234', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('235', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('236', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('237', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('238', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('239', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('240', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('241', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('242', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('243', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('244', '6', '王五', '0', '888888887788778877', '87878888888888888', '1', '31', '51', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '1', '2016-08-08', '走后门的大神');
INSERT INTO `ew_teacher` VALUES ('245', '6', '张三', '0', '888888887788778875', '6217002270000115678', '1', '31', '42', '15236549687', '3246792@qq.com', '23423423', '2016-10-08', '1', '2016-10-31', '');
INSERT INTO `ew_teacher` VALUES ('246', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('247', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('248', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('249', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('250', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('251', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('252', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('253', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('254', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('255', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('256', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('257', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('258', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('259', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('260', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('261', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('262', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('263', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('264', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('265', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('266', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('267', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('268', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('269', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('270', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('271', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('272', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('273', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('274', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('275', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('276', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('277', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('278', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('279', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('280', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');
INSERT INTO `ew_teacher` VALUES ('281', '3', '王五', '0', '888888887788778877', '87878888888888888', '1', '20', '14', '55667766545', '61336161@qq.com', '6666666', '2016-08-01', '0', '2016-08-08', '');

-- ----------------------------
-- Table structure for ew_user
-- ----------------------------
DROP TABLE IF EXISTS `ew_user`;
CREATE TABLE `ew_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `campusid` int(11) DEFAULT NULL COMMENT '校区id',
  `username` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `password` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '姓名',
  `typeid` int(11) DEFAULT NULL COMMENT '类型',
  `phone` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '电话',
  `mail` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '邮箱',
  `avatar` varchar(255) CHARACTER SET utf8 COLLATE utf8_bin DEFAULT NULL COMMENT '头像',
  `redtime` datetime DEFAULT NULL COMMENT '注册时间',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=158 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='用户表 学员和老师';

-- ----------------------------
-- Records of ew_user
-- ----------------------------
INSERT INTO `ew_user` VALUES ('1', '1', 'test', 'test', 'test', '1', '111', 'ee@qq.com', '', '2016-04-19 15:29:26');
INSERT INTO `ew_user` VALUES ('2', '1', 'Admin', 'admin', 'admin', '3', '111', null, '', '2016-04-20 10:09:25');
INSERT INTO `ew_user` VALUES ('3', '3', 'Teacher', 'teacher', 'Teacher', '2', '11122233312', '', '', '2016-04-20 10:31:17');
INSERT INTO `ew_user` VALUES ('5', '1', ' test2', 'test2', '测试2', '1', '22222222222', '', null, '2016-08-18 20:58:56');
INSERT INTO `ew_user` VALUES ('6', '1', ' 测试', '123456', '测试', '1', '12535625689', 'asa@qq', null, '2016-08-19 10:55:52');
INSERT INTO `ew_user` VALUES ('95', '3', '000241', '000241', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('96', '3', '000242', '000242', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('13', '3', '000158', '000158', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('15', '3', '000159', '000159', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('16', '3', '000081', '000081', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('17', '3', '000160', '000160', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('18', '3', '000082', '000082', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('19', '3', '000083', '000083', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('20', '3', '000161', '000161', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('21', '3', '000084', '000084', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('22', '3', '000162', '000162', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('23', '3', '000085', '000085', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('24', '3', '000086', '000086', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('25', '3', '000087', '000087', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('26', '3', '000163', '000163', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('27', '3', '000088', '000088', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('28', '3', '000200', '000200', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('29', '3', '000201', '000201', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('30', '3', '000089', '000089', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('100', '3', '000247', '000247', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('97', '3', '000243', '000243', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('31', '3', '000202', '000202', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('32', '3', '000090', '000090', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('33', '3', '000203', '000203', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('34', '3', '000204', '000204', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('35', '3', '000205', '000205', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('36', '3', '000206', '000206', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('37', '3', '000207', '000207', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('38', '3', '000208', '000208', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('39', '3', '000209', '000209', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('40', '3', '000210', '000210', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('41', '3', '000091', '000091', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('42', '3', '000211', '000211', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('43', '3', '000092', '000092', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('44', '1', '000093', '000093', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('45', '3', '000094', '000094', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('46', '3', '000201', '000201', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('47', '3', '000202', '000202', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('48', '3', '000447', '000447', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('49', '3', '000448', '000448', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('50', '3', '000449', '000449', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('51', '3', '000450', '000450', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('52', '3', '000451', '000451', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('53', '3', '000452', '000452', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('54', '3', '000203', '000203', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('55', '3', '000204', '000204', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('56', '3', '000453', '000453', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('57', '3', '000454', '000454', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('58', '3', '000455', '000455', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('59', '3', '000205', '000205', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('60', '3', '000610', '000610', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('61', '3', '000611', '000611', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('62', '3', '000612', '000612', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('63', '3', '000613', '000613', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('64', '3', '000614', '000614', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('65', '3', '000615', '000615', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('66', '3', '000616', '000616', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('67', '3', '000617', '000617', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('68', '3', '000618', '000618', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('69', '3', '000619', '000619', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('70', '3', '000620', '000620', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('71', '3', '000621', '000621', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('72', '3', '000622', '000622', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('73', '3', '000623', '000623', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('74', '3', '000624', '000624', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('75', '4', '000625', '000625', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('76', '4', '000626', '000626', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('77', '4', '000218', '000218', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('78', '4', '000219', '000219', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('79', '4', '000627', '000627', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('80', '4', '000220', '000220', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('98', '6', '000245', '000245', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('99', '3', '000246', '000246', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('87', '3', '000630', '000630', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('88', '3', '000631', '000631', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('101', '3', '000248', '000248', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('102', '3', '000632', '000632', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('103', '3', '000249', '000249', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('104', '3', '000250', '000250', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('105', '3', '000251', '000251', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('106', '3', '000252', '000252', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('107', '3', '000253', '000253', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('108', '3', '000254', '000254', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('109', '3', '000255', '000255', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('110', '3', '000256', '000256', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('111', '3', '000257', '000257', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('112', '3', '000258', '000258', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('113', '3', '000259', '000259', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('114', '3', '000260', '000260', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('115', '3', '000261', '000261', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('116', '3', '000262', '000262', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('117', '3', '000263', '000263', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('118', '3', '000264', '000264', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('119', '3', '000265', '000265', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('120', '3', '000266', '000266', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('121', '3', '000267', '000267', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('122', '3', '000268', '000268', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('123', '3', '000269', '000269', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('124', '3', '000633', '000633', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('125', '3', '000634', '000634', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('126', '3', '000635', '000635', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('127', '3', '000636', '000636', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('128', '3', '000637', '000637', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('129', '3', '000638', '000638', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('130', '3', '000639', '000639', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('131', '3', '000640', '000640', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('132', '3', '000641', '000641', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('133', '3', '000642', '000642', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('134', '3', '000643', '000643', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('135', '3', '000644', '000644', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('136', '3', '000645', '000645', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('137', '3', '000646', '000646', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('138', '3', '000647', '000647', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('139', '3', '000648', '000648', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('140', '3', '000649', '000649', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('141', '3', '000650', '000650', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('142', '3', '000270', '000270', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('143', '3', '000271', '000271', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('144', '3', '000272', '000272', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('145', '3', '000651', '000651', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('146', '3', '000652', '000652', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('147', '3', '000273', '000273', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('148', '3', '000274', '000274', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('149', '3', '000275', '000275', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('150', '3', '000276', '000276', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('151', '3', '000277', '000277', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('152', '3', '000278', '000278', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('153', '3', '000279', '000279', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('154', '3', '000280', '000280', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('155', '3', '000281', '000281', null, '2', null, null, null, null);
INSERT INTO `ew_user` VALUES ('156', '3', '000653', '000653', null, '1', null, null, null, null);
INSERT INTO `ew_user` VALUES ('157', '3', '000654', '000654', null, '1', null, null, null, null);

-- ----------------------------
-- Table structure for ew_usertype
-- ----------------------------
DROP TABLE IF EXISTS `ew_usertype`;
CREATE TABLE `ew_usertype` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_bin COMMENT='用户类型';

-- ----------------------------
-- Records of ew_usertype
-- ----------------------------
INSERT INTO `ew_usertype` VALUES ('1', '学生');
INSERT INTO `ew_usertype` VALUES ('2', '教师');
INSERT INTO `ew_usertype` VALUES ('3', '校长');

-- ----------------------------
-- Table structure for ew_versionlog
-- ----------------------------
DROP TABLE IF EXISTS `ew_versionlog`;
CREATE TABLE `ew_versionlog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fun_version` varchar(255) NOT NULL,
  `build_version` varchar(255) NOT NULL,
  `version` varchar(255) NOT NULL,
  `update_comment` varchar(255) NOT NULL,
  `update_time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of ew_versionlog
-- ----------------------------
