﻿var openImg = new Image();
var closedImg = new Image();

function showBranch(branch) {
    var objBranch = document.getElementById(branch).style;
    if (objBranch.display == "block")
        objBranch.display = "none";
    else
        objBranch.display = "block";
    swapFolder('I' + branch);
}

function swapFolder(img) {
    objImg = document.getElementById(img);
    if (objImg.src.indexOf('closed.gif') > -1)
        objImg.src = openImg.src;
    else
        objImg.src = closedImg.src;
}
function tree() {
    this.branches = new Array();
    this.add = addBranch;
    this.write = writeTree;

    this.GetBranchSize = GetBranchSize;
}

function GetBranchSize() {
    return this.branches.length;
}

function addBranch(branch) {
    this.branches[this.branches.length] = branch;
}

function writeTree() {
    var treeString = '';
    var numBranches = this.branches.length;
    for (var i = 0; i < numBranches; i++)
        treeString += this.branches[i].write();
    document.write(treeString);
}
function branch(id, text) {
    this.id = id;
    this.text = text;
    this.write = writeBranch;
    this.add = addLeaf;
    this.leaves = new Array();
}
function addLeaf(leaf) {
    this.leaves[this.leaves.length] = leaf;
}

function writeBranch() {
    var branchString = '<span  class="branch"' + 'onClick="showBranch(\'' + this.id + '\')"';
    branchString += '><img width=15 height=15 src="images/closed.gif" id="I' + this.id + '" />&nbsp;&nbsp;' + this.text;

    branchString += '</span>';
    branchString += '<span class="leaf" id="';
    branchString += this.id + '">';
    var numLeaves = this.leaves.length;
    for (var j = 0; j < numLeaves; j++) branchString += this.leaves[j].write();
    branchString += '</span>';
    return branchString;
}
function leaf(text, link) {
    this.text = text;
    this.link = link;
    this.write = writeLeaf;
}
function writeLeaf() {
    var leafString = '<img src="images/doc.gif" border="0" />&nbsp;&nbsp;<a onmouseover="ChangeBackColor(this,true)" onmouseout="ChangeBackColor(this,false)" href="' + this.link + '" target="OfficeMain">';
    leafString += this.text;
    leafString += '</a><br/>';
    return leafString;
}

/*此函数用于当用户选择顶部的菜单导航时展开某个菜单*/
function ShowTreeNode(index) {
    var branches_length = myTree.GetBranchSize();
    for (var i = 1; i < branches_length; i++) {
        var objBranch = document.getElementById("branch" + i).style;
        objImg = document.getElementById("Ibranch" + i);
        if (index == i) {
            objBranch.display = "block";
            objImg.src = openImg.src;
        }
        else {
            objBranch.display = "none";
            objImg.src = closedImg.src;
        }
    }
}

/*当鼠标移进或移出某个菜单上面时改变背景颜色*/
function ChangeBackColor(object, flag) {
    if (flag) {
        object.style.backgroundColor = "#FF0000";
        object.style.color = "#30F";
    }
    else {
        object.style.backgroundColor = "";
        object.style.color = "#F0F";
    }
}

var myTree = new tree();

/*向html页面写入菜单导航树*/
function WriteTreeInfo() {
    openImg.src =  "images/open.gif";
    closedImg.src =  "images/closed.gif"; 

    var branches = new Array();
    branches[1] = new branch('branch1', '学院信息管理');
    var branch1_leaf1 = new leaf('学院信息登记', 'CollegeInfo/collegeInfoAdd.php');
    var branch1_leaf2 = new leaf('学院信息维护', 'controller/CollegeInfoAction.php?action=query');
    branches[1].add(branch1_leaf1);
    branches[1].add(branch1_leaf2);
    myTree.add(branches[1]);
    branches[2] = new branch('branch2', '专业信息管理');
    var branch2_leaf1 = new leaf('专业信息登记', 'SpecialFieldInfo/specialFieldInfoAdd.php');
    var branch2_leaf2 = new leaf('专业信息维护', 'controller/SpecialFieldInfoAction.php?action=query');
    branches[2].add(branch2_leaf1);
    branches[2].add(branch2_leaf2);
    myTree.add(branches[2]);
    branches[3] = new branch('branch3', '班级信息管理');
    var branch3_leaf1 = new leaf('班级信息登记', 'ClassInfo/classInfoAdd.php');
    var branch3_leaf2 = new leaf('班级信息维护', 'controller/ClassInfoAction.php?action=query');
    branches[3].add(branch3_leaf1);
    branches[3].add(branch3_leaf2);
    myTree.add(branches[3]);
    branches[4] = new branch('branch4', '学生信息管理');
    var branch4_leaf1 = new leaf('学生信息登记', 'Student/studentAdd.php');
    var branch4_leaf2 = new leaf('学生信息维护', 'controller/StudentAction.php?action=query');
    branches[4].add(branch4_leaf1);
    branches[4].add(branch4_leaf2);
    myTree.add(branches[4]);
    branches[5] = new branch('branch5', '教师信息管理');
    var branch5_leaf1 = new leaf('教师信息登记', 'Teacher/teacherAdd.php');
    var branch5_leaf2 = new leaf('教师信息维护', 'controller/TeacherAction.php?action=query');
    branches[5].add(branch5_leaf1);
    branches[5].add(branch5_leaf2);
    myTree.add(branches[5]);
    branches[6] = new branch('branch6', '课程信息管理');
    var branch6_leaf1 = new leaf('课程信息登记', 'CourseInfo/courseInfoAdd.php');
    var branch6_leaf2 = new leaf('课程信息维护', 'controller/CourseInfoAction.php?action=query');
    branches[6].add(branch6_leaf1);
    branches[6].add(branch6_leaf2);
    myTree.add(branches[6]);
    branches[7] = new branch('branch7', '选课信息管理');
    var branch7_leaf1 = new leaf('选课信息登记', 'StudentSelectCourseInfo/studentSelectCourseInfoAdd.php');
    var branch7_leaf2 = new leaf('选课信息维护', 'controller/StudentSelectCourseInfoAction.php?action=query');
    branches[7].add(branch7_leaf1);
    branches[7].add(branch7_leaf2);
    myTree.add(branches[7]);
    branches[8] = new branch('branch8', '成绩信息管理');
    var branch8_leaf1 = new leaf('成绩信息登记', 'ScoreInfo/scoreInfoAdd.php');
    var branch8_leaf2 = new leaf('成绩信息维护', 'controller/ScoreInfoAction.php?action=query');
    branches[8].add(branch8_leaf1);
    branches[8].add(branch8_leaf2);
    myTree.add(branches[8]);
    branches[9] = new branch('branch9', '新闻信息管理');
    var branch9_leaf1 = new leaf('新闻信息登记', 'News/newsAdd.php');
    var branch9_leaf2 = new leaf('新闻信息维护', 'controller/NewsAction.php?action=query');
    branches[9].add(branch9_leaf1);
    branches[9].add(branch9_leaf2);
    myTree.add(branches[9]);
    branches[11] = new branch('branch11', '系统管理');
    var branch11_leaf1 = new leaf('修改密码', '/changePassword.php');
    var branch11_leaf2 = new leaf('系统说明',  'desk.php');
    var branch11_leaf3 = new leaf('关于系统',  'about.html');
    branches[11].add(branch11_leaf1)
    branches[11].add(branch11_leaf2);
    branches[11].add(branch11_leaf3);
    myTree.add(branches[11]);



    myTree.add(new leaf('退出系统',  'logout.php'));

    myTree.write();
}




 
