<title><?php
	global $page, $paged;
	$site_description = get_bloginfo( 'description', 'display' );
 	if ($site_description && ( is_home() || is_front_page() )) {
		bloginfo('name');
		echo " - $site_description";
	} else {
		echo trim(wp_title('',0));
		if ( $paged >= 2 || $page >= 2 )
			echo ' - ' . sprintf( __( '第%s页' ), max( $paged, $page ) );
		echo '_' ;
		bloginfo('name');
	}
?></title>
<?php if (is_home() || is_front_page())
	{
	$description = get_option('binhow_description');
	$keywords = get_option('binhow_keywords');

	}
	elseif (is_category())
	{
	$description = strip_tags(trim(category_description()));
	$keywords = single_cat_title('', false);
	}
	elseif (is_tag())
	{
	$description = sprintf( __( '与标签 %s 相关联的文章列表'), single_tag_title('', false));
    $keywords = single_tag_title('', false);
	}
	elseif (is_single())
	{
     if ($post->post_excerpt) {$description = $post->post_excerpt;} 
	 else {$description = mb_strimwidth(strip_tags($post->post_content),0,110,"",'utf-8');}
    $keywords = "";
    $tags = wp_get_post_tags($post->ID);
    foreach ($tags as $tag ) {$keywords = $keywords . $tag->name . ", ";}
	}
	elseif (is_page())
	{
	$keywords = get_post_meta($post->ID, "keywords", true);
	$description = get_post_meta($post->ID, "description", true);
	}
	?>
<meta name="keywords" content="<?php echo $keywords; ?>" />
<meta name="description" content="<?php echo $description; ?>" />