<?php
/****************************************************************/
/* ATutor                                                       */
/****************************************************************/
/* Copyright (c) 2002-2010                                      */
/* Inclusive Design Institute                                   */
/* http://atutor.ca                                             */
/*                                                              */
/* This program is free software. You can redistribute it and/or*/
/* modify it under the terms of the GNU General Public License  */
/* as published by the Free Software Foundation.                */
/****************************************************************/
// $Id$

define('AT_INCLUDE_PATH', '../../../include/');
require(AT_INCLUDE_PATH.'vitals.inc.php');
require(AT_INCLUDE_PATH.'../mods/_standard/tests/lib/test_question_queries.inc.php');

authenticate(AT_PRIV_TESTS);
require(AT_INCLUDE_PATH.'../mods/_standard/tests/lib/test_result_functions.inc.php');

if (isset($_POST['cancel'])) {
    $msg->addFeedback('CANCELLED');
    header('Location: question_db.php');
    exit;
} else if ($_POST['submit']) {
    $missing_fields = array();

    $_POST['feedback']            = trim($_POST['feedback']);
    $_POST['question']            = trim($_POST['question']);
    $_POST['category_id']         = intval($_POST['category_id']);
    $_POST['remedial_content']    = trim($_POST['remedial_content']);

    if ($_POST['question'] == ''){
        $missing_fields[] = _AT('question');
    }

    if (trim($_POST['choice'][0]) == '') {
        $missing_fields[] = _AT('item').' 1';
    }
    if (trim($_POST['choice'][1]) == '') {
        $missing_fields[] = _AT('item').' 2';
    }

    if ($missing_fields) {
        $missing_fields = implode(', ', $missing_fields);
        $msg->addError(array('EMPTY_FIELDS', $missing_fields));
    }

    if (!$msg->containsErrors()) {
        $choice_new = array(); // stores the non-blank choices
        $answer_new = array(); // stores the non-blank answers
        $order = 0; // order count
        for ($i=0; $i<10; $i++) {
            /**
             * Db defined it to be 255 length, chop strings off it it's less than that
             * @harris
             */
            $_POST['choice'][$i] = validate_length($_POST['choice'][$i], 255);
            $_POST['choice'][$i] = $addslashes(trim($_POST['choice'][$i]));

            if ($_POST['choice'][$i] != '') {
                /* filter out empty choices/ remove gaps */
                $choice_new[] = $_POST['choice'][$i];
                $answer_new[] = $order++;
            }
        }

        $_POST['choice']              = array_pad($choice_new, 10, '');
        $answer_new                   = array_pad($answer_new, 10, 0);
        $_POST['feedback']            = $addslashes($_POST['feedback']);
        $_POST['question']            = $addslashes($_POST['question']);
        $_POST['remedial_content']    = $addslashes($_POST['remedial_content']);
    
        $sql_params = array(    $_POST['category_id'], 
                                $_SESSION['course_id'],
                                $_POST['feedback'], 
                                $_POST['question'], 
                                $_POST['choice'][0], 
                                $_POST['choice'][1], 
                                $_POST['choice'][2], 
                                $_POST['choice'][3], 
                                $_POST['choice'][4], 
                                $_POST['choice'][5], 
                                $_POST['choice'][6], 
                                $_POST['choice'][7], 
                                $_POST['choice'][8], 
                                $_POST['choice'][9], 
                                $answer_new[0], 
                                $answer_new[1], 
                                $answer_new[2], 
                                $answer_new[3], 
                                $answer_new[4], 
                                $answer_new[5], 
                                $answer_new[6], 
                                $answer_new[7], 
                                $answer_new[8], 
                                $answer_new[9],
                                $_POST['remedial_content']);
        $sql = vsprintf(AT_SQL_QUESTION_ORDERING, $sql_params);

        $result    = mysql_query($sql, $db);

        $msg->addFeedback('ACTION_COMPLETED_SUCCESSFULLY');
        header('Location: question_db.php');
        exit;
    }
}

$onload = 'document.form.category_id.focus();';

require(AT_INCLUDE_PATH.'header.inc.php');

?>
<form action="<?php echo $_SERVER['PHP_SELF']; ?>" method="post" name="form">
<input type="hidden" name="required" value="1" />
<div class="input-form">
    <div class="row">
        <span class="required" title="<?php echo _AT('required_field'); ?>">*</span><label for="cats"><?php echo _AT('category'); ?></label><br />
        <select name="category_id" id="cats">
            <?php print_question_cats($_POST['category_id']); ?>
        </select>
    </div>

    <div class="row">
        <span class="required" title="<?php echo _AT('required_field'); ?>">*</span><label for="question"><?php echo _AT('question'); ?></label>
        <?php print_VE('question'); ?>
        <textarea id="question" cols="50" rows="6" name="question"><?php echo htmlspecialchars(stripslashes($_POST['question'])); ?></textarea>
    </div>
    
    <?php for ($i=0; $i<10; $i++): ?>
        <div class="row">
            <?php if ($i < 2): ?>
                <span class="required" title="<?php echo _AT('required_field'); ?>">*</span>
            <?php endif; ?> <?php echo _AT('item'); ?> <?php echo ($i+1); ?>
            
            <?php print_VE('choice_' . $i); ?>
            
            <br />
    
            <textarea id="choice_<?php echo $i; ?>" cols="50" rows="2" name="choice[<?php echo $i; ?>]"><?php echo htmlspecialchars(stripslashes($_POST['choice'][$i])); ?></textarea> 
        </div>
    <?php endfor; ?>
    
    <?php require('question_footer.php'); ?>
    
</div>
</form>

<?php require (AT_INCLUDE_PATH.'footer.inc.php'); ?>