﻿/*************************************************************************
* @name: DropList
* @author: BOSSMA
* @version: 1.1
* @date: 2010-01-27
* @description: 一个可以更快制作无限级下拉列表的Javascript程序
* @website: http://www.bossma.cn
* @copyright: 本程序遵守LGPL开源协议
**************************************************************************/

/*****************************************************
用来定义下拉列表中的选择项：DropSelectItem
参数：
	text:选择项的文本
	parentvalue：上级值
	value：选择项的值
	selected: 是否选中 
返回值：DropSelectItem对象
*****************************************************/
function DropSelectItem(text,value,parentValue,isSelected){
	this.text=text;
	this.parentValue=parentValue;
	this.value=value;
	this.selected=isSelected;
};

/*****************************************************
用来定义下拉列表：DropSelect
参数：
	name:下拉列表的Name属性
	id：下拉列表的ID属性
	tip：选择提示，例如：-请选择-
返回值：DropSelect对象
 ****************************************************/
function DropSelect(name,id,tip){
	this.name=name;
	this.id=id;
	this.tip=tip;
};

/*****************************************************
用来定义：DropList
参数：
	objName:对象名称 字符
	topparent: 最顶级下拉列表的上级值
	iscookie: 是否使用cookie
返回值：DropList对象
******************************************************/
function DropList(objId,topParentValue,isCookie){
	this.id=objId;
	this.dropSelectItems=[];
	this.dropSelect=[];
	this.topParentValue=topParentValue;
	this.useCookie=(isCookie==null)?true:isCookie;
};

/*****************************************************
用于添加下拉列表:AddSelect
参数：
	name:下拉列表的Name属性
	id：下拉列表的ID属性
	tip：选择提示，例如：-请选择-
返回值：无
*****************************************************/
DropList.prototype.AddSelect = function(name,id,tip){
	this.dropSelect[this.dropSelect.length] = new DropSelect(name,id,tip);
};

/*****************************************************
用于添加下拉列表的选择项:AddSelectItem
参数：
	text:显示文本
	value：值
	parentValue：上级值
	isSelected：是否选中项
返回值：无
******************************************************/
DropList.prototype.AddSelectItem = function(text,value,parentValue,isSelected){
	this.dropSelectItems[this.dropSelectItems.length] = new DropSelectItem(text,parentValue,value,isSelected);
};

/*****************************************************
用于添加下拉列表的选择项:InitControl
参数：
	text:显示文本
	value：值
	parentValue：上级值
	isSelected：是否选中项
返回值：无 或 false
 *****************************************************/
DropList.prototype.InitControl = function(){ 
	if(this.dropSelect.length<=0){//没有添加下拉列表
		return false;
	}
	
	this.InitSelect(null,this.topParentValue);//初始化填充下拉列表
};

/*****************************************************
设置Select选项，并设置选中项，选中项Cookie优先:InitSelect
参数：
	nowDropSelect: 当前要设置的选择项
	parentValue：上级值,最上级不能为空，否则会出现问题
返回值：无
******************************************************/
DropList.prototype.InitSelect = function(nowDropSelect,parentValue){

	if(nowDropSelect==null){//如果当前下拉列表ID为空，则为第一个
		nowDropSelect=this.dropSelect[0];
	}
    
	document.write("<select id='"+nowDropSelect.id+"' name='"+nowDropSelect.name+"' onChange=javascript:eval(\""+this.id+".ChangeSelect('"+nowDropSelect.id+"');\")></select>");//输出下拉列表
	
	var curDropSelect = document.getElementById(nowDropSelect.id);//初始化下拉列表
	curDropSelect.length = 0;
	
	if(curDropSelect.tip!=""){//如果有选择提示，则显示出来
		curDropSelect.options[curDropSelect.length] = new Option(nowDropSelect.tip,'');
	}
	
	if(parentValue!=""){//上级值不为空
		for(i=0;i<this.dropSelectItems.length; i++){//循环填充下拉列表
			if (this.dropSelectItems[i].parentValue == parentValue){       
				curDropSelect.options[curDropSelect.length] = new Option(this.dropSelectItems[i].text, this.dropSelectItems[i].value);
				
				if(this.dropSelectItems[i].selected){//设置选中项
					curDropSelect.value = this.dropSelectItems[i].value;
				}
			}
		}
		
		if(this.useCookie){//如果使用Cookie,则设置Cookie中保存的选中项
		    var cookieSelectValue=this.GetSelect(nowDropSelect.id);
			if(cookieSelectValue!=null&&cookieSelectValue!=''){
				curDropSelect.value = cookieSelectValue;	 
			}
		}
	}
	
	var nextDropSelectItem=this.NextDropSelect(nowDropSelect);
	if(nextDropSelectItem!=null){//递归下一级下拉列表的选择项目
	   this.InitSelect(nextDropSelectItem,curDropSelect.value);
	}
};

/*****************************************************
变换选择项时填充下级:ChangeSelect
参数：
	nowDropSelect: 当前要设置的选择项
	parentValue：上级值
返回值：无
******************************************************/
DropList.prototype.ChangeSelect = function(nowDropSelectId){
	
	var nowDropSelect = document.getElementById(nowDropSelectId);//当前Html中下拉列表
	var nowDropSelectValue=nowDropSelect.options[nowDropSelect.selectedIndex].value;//当前下拉列表的值
	
	if(this.useCookie){//如果使用Cookie,将值设置到Cookie
		var cookiename = this.id + nowDropSelectId;
		this.setCookie(cookiename,nowDropSelectValue);
	}
	
	var nextDropSelectItem = this.NextDropSelectById(nowDropSelectId);
	
	if(nextDropSelectItem!=null){//如果不是最后一个下拉列表
		var nextDropSelect = document.getElementById(nextDropSelectItem.id);//获取html中的下拉列表
		nextDropSelect.length = 0;//初始长度
		nextDropSelect.options[0] = new Option(nextDropSelectItem.tip,'');//设置下拉选择提示
		
		for(var i=0;i<this.dropSelectItems.length; i++){
			if (this.dropSelectItems[i].parentValue == nowDropSelectValue){
				nextDropSelect.options[nextDropSelect.length] = new Option(this.dropSelectItems[i].text, this.dropSelectItems[i].value);
			}
		}
		
		this.ChangeSelect(nextDropSelect.id);
	}
};

//从Cookie中获取当前select的选择项
DropList.prototype.GetSelect= function(nowid) {
	var sn = this.getCookie(this.id+nowid);
	return (sn) ? sn : null;
};

//设置Cookie
DropList.prototype.setCookie = function(cookieName, cookieValue, expires, path, domain, secure) {

	document.cookie =
		escape(cookieName) + '=' + escape(cookieValue)
		+ (expires ? '; expires=' + expires.toGMTString() : '')
		+ (path ? '; path=' + path : '')
		+ (domain ? '; domain=' + domain : '')
		+ (secure ? '; secure' : '');
};

//获取Cookie
DropList.prototype.getCookie = function(cookieName) {

	var cookieValue = '';
	var posName = document.cookie.indexOf(escape(cookieName) + '=');
	if (posName != -1) {
		var posValue = posName + (escape(cookieName) + '=').length;
		var endPos = document.cookie.indexOf(';', posValue);
		if (endPos != -1) cookieValue = unescape(document.cookie.substring(posValue, endPos));
		else cookieValue = unescape(document.cookie.substring(posValue));
	}
	return (cookieValue);
};

/*****************************************************
通过当前下拉列表获取下一个下拉列表:NextDropSelect
参数：
	nowDropSelect: 当前的的下拉列表
返回值：下拉列表
******************************************************/
DropList.prototype.NextDropSelect = function(nowDropSelect){
	
	for(var j=0;j<this.dropSelect.length;j++){
		if(this.dropSelect[j]==nowDropSelect){
			if(j+1<this.dropSelect.length){
				return this.dropSelect[j+1];
			}
		}
	}
	return null;
};

/*****************************************************
通过当前下拉列表ID获取下一个下拉列表对象:NextDropSelectById
参数：
	nowDropSelectId: 当前的的下拉列表的Id
返回值：下拉列表
******************************************************/
DropList.prototype.NextDropSelectById = function(nowDropSelectId){
	
	for(var j=0;j<this.dropSelect.length;j++){
		if(this.dropSelect[j].id==nowDropSelectId){
			if(j+1<this.dropSelect.length){
				return this.dropSelect[j+1];
			}
		}
	}
	return null;
};