
function getWindowSize() {
  var myWidth = 0, myHeight = 0;
  if( typeof( window.innerWidth ) == 'number' ) {
    //Non-IE
    myWidth = window.innerWidth;
    myHeight = window.innerHeight;
  } else if( document.documentElement && ( document.documentElement.clientWidth || document.documentElement.clientHeight ) ) {
    //IE 6+ in 'standards compliant mode'
    myWidth = document.documentElement.clientWidth;
    myHeight = document.documentElement.clientHeight;
  } else if( document.body && ( document.body.clientWidth || document.body.clientHeight ) ) {
    //IE 4 compatible
    myWidth = document.body.clientWidth;
    myHeight = document.body.clientHeight;
  }

  return [myWidth, myHeight];
  //window.alert( 'Width = ' + myWidth );
  //window.alert( 'Height = ' + myHeight );
}

//Chat functions that are globally used
function stopAjaxChat() {
	if (chatroomIntervalId > 0) {
		disableChat();
		clearInterval(chatroomIntervalId);
		// Start a new interval to check for room movement every 60 seconds
		// This periodic call is used to check for activity during the last 60 seconds.
		// We note here that the restart_session flag is sent to denote that we want all messages of the last 5 minutes
		// If none are found then the image of messages will dissapear - if it had appeared before
		if (chatactivityIntervalId > 0) {
			clearInterval(chatactivityIntervalId);
		}
		chatactivityIntervalId = setInterval("makeAjaxRequest('ask_chat.php?chatrooms_ID='+$('current_chatroom_id').value+'&any_activity=1','special_get_request','chat')", 60000);
	}
}

//Function to get the room's messages. During the first time the room is loaded ($('first_time_messages').value =1) and
//all messages from the last five minutes should be brought.
function ajaxGetMessages() {
	// The check here is used for synchronization. If $('current_chatroom_id').value==-1 then value have not been set correctly yet.
	if ($('current_chatroom_id').value != -1) {
		if ($('first_time_messages').value == 1) {
			makeAjaxRequest('ask_chat.php?chatrooms_ID='+$('current_chatroom_id').value+'&restart_session=1','special_get_request','chat')
			$('first_time_messages').value = 0;
		} else {
			makeAjaxRequest('ask_chat.php?chatrooms_ID='+$('current_chatroom_id').value,'special_get_request','chat')
		}
	}
}

function startAjaxChat() {
	// Stop the previous Ajax Chat if the chatting is enabled for this user
	// otherwise the chatroomIntervalid will remain 0;
	if (chatOptionIsEnabled) {
		if (chatactivityIntervalId > 0) {
			clearInterval(chatactivityIntervalId);
			Effect.Fade($('new_chat_messages'));
		}

		// No idea, why this initialization was put here. Maybe should leave
		if (chatroomIntervalId > 0) {
			disableChat();
			clearInterval(chatroomIntervalId);
		}

		enableChat();
		chatroomIntervalId = setInterval("ajaxGetMessages()",2500);
	}
}

// Function to resize the Chat iframe
function resize_iframe()
{
	if (chatOptionIsEnabled) {
		//fixCurtains();
		var height= $('listmenu'+menuCount).getHeight();//window.innerWidth;//Firefox

		var offset_to_subtract = onlyViewChat == 1 ? 50 : 72;
		if (browser == 'IE6' || browser == 'IE7') {
			offset_to_subtract = offset_to_subtract - 2;
		} else if (browser == 'Safari') {
			offset_to_subtract = offset_to_subtract + 4;
		} else if (browser == 'Chrome') {
			offset_to_subtract = offset_to_subtract + 22;
		}

		//resize the iframe according to the size of the
		//window (all these should be on the same line)
		var diff = height-offset_to_subtract;
		
		if ($('glu')) {	
			if (browser == 'IE6' || browser == 'IE7') {
				$('glu').height = diff;
			} else {
				$('glu').setStyle({'height': diff+'px'});
			}
		}
		//$('glu').up().setStyle({height: (height-offset_to_subtract) + 'px'});
		//test.document.getElementById("chat_content").style.height = parseInt(height-offset_to_subtract)+ "px";
		if (test && test.document && test.document.getElementById("chat_content")) {
			if (browser == 'IE6' || browser == 'IE7') {
				test.document.getElementById("chat_content").height = diff+ "px";
			} else {
				test.document.getElementById("chat_content").style.height = diff+ "px";
			}	
			
		}
	}
}

//The following functions are used to highlight the correct menu on page load or refresh
function enableChat() {
	chatEnabled = 1;
}
function disableChat() {
	chatEnabled = 0;
}

// Function to make a certain menu item appear as activated 
function changeTDcolor(id) {

	if (!id) {
		return false;
	}
	if(active_id != id)
	{
		if(document.getElementById(active_id))
		{
			$(active_id).className = "menuOption";
		}

		if(document.getElementById(active_id+"_a"))
		{
			$(active_id+"_a").className = "menuOption"; //"menuLinkInactive";
		}
		active_id = id;

		// If the chat menu is enabled then do not automatically move the menus
		if(document.getElementById(id)) {
			$(id).className = "selectedTopTitle";// rightAlign";
			if ( $(id).up() && $(id).up().up() && chatEnabled == 0) {
				document.move($(id).up().up());
			}
		}
		if(document.getElementById(id+"_a") && chatEnabled == 0)
		{
			$(active_id+"_a").className = "selectedTopTitle";
			if ( $(active_id+"_a").up() && $(active_id+"_a").up().up()) {
				document.move($(active_id+"_a").up().up());
			}
		}
	}
}

function hideLoadingDiv() {
    $('tabmenu').style.visibility = "visible";
    $('menu').style.visibility = "visible";
    $('utility_images').style.visibility = "visible";

	if ($('loading_sidebar')) {
		$('loading_sidebar').setStyle({display:'none'});
	}
}

function initArrows() {
     var windowSize = getWindowSize();
     var windowHeight = parseInt(windowSize[1]);
     scrollHeight = parseInt(document.documentElement.scrollHeight);
     //alert("windowHeight = "+windowHeight+" scrollHeight = "+scrollHeight);
     
     
     //hideLoadingDiv();
     
}
window.onresize = resizeFunction;

function setArrowStatus(status) {
      arrow_status = status;
      initArrows();
}


function miniFixCurtains() {

      var windowSize = getWindowSize();
      var windowHeight = parseInt(windowSize[1]);

      var menus = $('menu').childElements().length - 1; // we do not take "logout" into account
      var offset;

      var i = menus;
      for (i = menus; i > 0; i--) {

		    offset = windowHeight - $('tabmenu').getHeight() - $('logout').getHeight() -1;
		    for (k = 1; k <= i; k++) {
		        offset -= ($('tabmenu'+k).getHeight()+1);
		    }
		
		    j = i + 1;
		     // Check the next menus
		    while ( $('menu'+j) ) {
		         if ($('menu'+j).status =='down') {
		            offset = offset - $('tabmenu'+j).getHeight() - 1;
		        }
		        j = j + 1;
		    }
		
		    if (offset > 0) {
		        $('listmenu'+i).setStyle("height: " +(offset+1)+"px;");
		    }
	  }
}

// Function to fix the height of the curtains used to hide underlying menus - the menus must follow an order menu = <menu1,menu2...,menuN,logout>
function fixCurtains() {

      var windowSize = getWindowSize();
      var windowHeight = parseInt(windowSize[1]);

      var menus = $('menu').childElements().length - 1; // we do not take "logout" into account
      var offset;

      var i = menus;
      for (i = menus; i > 0; i--) {

	    offset = windowHeight - $('tabmenu').getHeight() - $('logout').getHeight() -1;
	    for (k = 1; k <= i; k++) {
	        offset -= ($('tabmenu'+k).getHeight()+1);
	    }
	
	    j = i + 1;
	     // Check the next menus
	    while ( $('menu'+j) ) {
	         if ($('menu'+j).status =='down') {
	            offset = offset - $('tabmenu'+j).getHeight() - 1;
	        }
	        j = j + 1;
	    }
	
	    if (offset > 0) {
	        $('listmenu'+i).setStyle("height: " +(offset)+"px;");
	    }
    }

    // Hiding all menus above the selected one: chech menus 1...menus-1
   	for (i = 1; i < menus; i++) {
       if ( (Object.isUndefined($('menu'+i).status) || $('menu'+i).status == "up") && (Object.isUndefined($('menu'+(i+1)).status) || $('menu'+(i+1)).status != "down")) {
           if(i==1) {
               $('listmenu'+i).hide();
           } else {
               $('menu'+i).down(1).hide();
           }
       } else {
           break;
       }
    }

    // Code to correct sizes of the iframe.
    resize_iframe();
}

// Function called on resizing the window. Changes the position of the tabheaders and fixes the Curtains by calling fixCurtain
function resizeFunction() {

        var windowSize = getWindowSize();
        var windowHeight = parseInt(windowSize[1]);

        // Adjust the menu size
        var menus = $('menu').childElements().length - 1; // we do not take "logout" into account
        var wholeMenuSize = windowHeight - $('tabmenu').getHeight();
        var i = 2;

        for (i = 2; i <= menus; i++) {
            if ($('menu'+i).status == "down") {
                wholeMenuSize = wholeMenuSize - $('menu'+i).getHeight();
            }
        }

        if (browser == 'IE6') {
            $('menu').setAttribute("height", (wholeMenuSize) + 'px');
        } else {
            if (wholeMenuSize > 0) {
                $('menu').setStyle({height: (wholeMenuSize) + 'px'});
            }
        }

        // Adjust logout position
        //$('logout').setStyle({marginTop: '0px'});
        var newTop = (windowHeight-$('logout').getHeight());
        $('logout').setStyle({top: (newTop)+'px'});

        var logoutLogout = $('logout').style.top.split("px");
        logoutLogout  = parseInt(logoutLogout[0]);

        var temp;

        // Adjust all other menus
        var i = 2;
        for (i = 2; i <= menus; i++) {
            if(Object.isUndefined($('menu'+i).status) || $('menu'+i).status == 'up') {
                newTop = $('tabmenu').getHeight();
                temp =(i-2) * $('tabmenu2').getHeight();
                temp += $('tabmenu'+i).getHeight();
                newTop = newTop + temp;
            } else {
                temp = (menus - i + 2);
                temp = temp * ($('tabmenu2').getHeight()+1);
                newTop = windowHeight - temp;
            }
            $('menu'+i).setStyle({marginTop: (0)+'px'});
            $('menu'+i).setStyle({top: (newTop)+'px'});
        }

        // Fix the curtains used to hide the menus
        fixCurtains();
}


var lessonsName = "";
function hideAllLessonSpecific() {

	$('loading_sidebar').setStyle({display:'block'});
	// The first menu is built, so as to have all lesson specific and general elements
	allMenuOptions = $('listmenu1').childElements();

	// Hide lesson specific options												
	lessonsSpecificOptions = new Array();
	for (i=0; i<allMenuOptions.length; i++) {
		if (allMenuOptions[i].getAttribute("name") == "lessonSpecific") { 
			lessonsSpecificOptions.push(allMenuOptions[i]);
		}
	}
						
	for (i=0; i<lessonsSpecificOptions.length; i++) {
		lessonsSpecificOptions[i].style.display = "none";
	}
	
	// Show lesson general options (lessons link and skillgap tests if they exist)
	lessonsGeneralOptions = new Array();
	for (i=0; i<allMenuOptions.length; i++) {
		if (allMenuOptions[i].getAttribute("name") == "lessonGeneral") { 
			lessonsGeneralOptions.push(allMenuOptions[i]);
		}
	}	
	
	for (i=0; i<lessonsGeneralOptions.length; i++) {
		lessonsGeneralOptions[i].style.display = "block";
	}
	
	// Change the name of the header
	lessonsName = $('tabmenu1').innerHTML;
	$('tabmenu1').innerHTML = translations['lessons'];
	
}


// The opposite function than hideAllLessonSpecific
function hideAllLessonGeneral() {
	allMenuOptions = $('listmenu1').childElements();

	// Show lesson general options (lessons link and skillgap tests if they exist)
	lessonsGeneralOptions = new Array();
	for (i=0; i<allMenuOptions.length; i++) {
		if (allMenuOptions[i].getAttribute("name") == "lessonGeneral") { 
			lessonsGeneralOptions.push(allMenuOptions[i]);
		}
	}
	
	for (i=0; i<lessonsGeneralOptions.length; i++) {
		lessonsGeneralOptions[i].style.display = "none";
	}

	lessonsSpecificOptions = new Array();
	for (i=0; i<allMenuOptions.length; i++) {
		if (allMenuOptions[i].getAttribute("name") == "lessonSpecific") { 
			lessonsSpecificOptions.push(allMenuOptions[i]);
		}
	}
	
	for (i=0; i<lessonsSpecificOptions.length; i++) {
		lessonsSpecificOptions[i].style.display = "block";
	}			
	
	$('tabmenu1').innerHTML = lessonsName;
}


var lock = 0;	// used to avoid overlapping effects
 // Function to move menus up and down
document.move = function(element) {
    if (!lock) {
        lock = 1;
        // Check whether you are moving the chatmenu so that you start or stop the ajax requests for the chat
        if ($('tab'+element.id).getAttribute("name") && $('tab'+element.id).getAttribute("name") == "chatmenu") {
            startAjaxChat();
            $('list'+element.id).style.display = "block";
        } else {
            stopAjaxChat();
            if (chat_listmenu != -1) {
            	$(chat_listmenu).style.display = "none";  
            }
        }

        //alert("down"+element.up().name);
        if (Object.isUndefined(element.status) || element.status == 'up') {

        //Calculating from the last element to the current one
        var newPos = element.nextSiblings().last().positionedOffset().top - element.positionedOffset().top - (element.nextSiblings().last().getHeight() * (element.nextSiblings().length));

        for (var i = 0; i < element.nextSiblings().length - 1; i++) {
            if (Object.isUndefined(element.next(i).status) || element.next(i).status == 'up') {
                newPos = element.next(i).nextSiblings().last().positionedOffset().top - element.next(i).positionedOffset().top - (element.next(i).nextSiblings().last().getHeight() * element.next(i).nextSiblings().length);
                element.next(i).status = 'down';
                element.next(i).down(1).hide();
                effect = new Effect.MoveUpDown(element.next(i), newPos);
            }
        }

            if (element.id == 'menu1') {
                setTimeout(function(){$('listmenu1').show();}, 200);
            } else {
                setTimeout(function(){element.down(1).show();}, 200); //element.down(1).show();
            }
        } else {

        for (var i = element.previousSiblings().length - 1; i>=0; i--) {
            if (element.previous(i).status == 'down') {

                newPos = -(element.previous(i).positionedOffset().top - element.previous(i).previousSiblings().last().positionedOffset().top);
                size = element.previous(i).previousSiblings().length;
                for (var j = 1; j <= size; j++) {
                    newPos += $('tabmenu'+j).getHeight();
                }


                //newPos += $('tabmenu1').getHeight() - 1;
                element.previous(i).status = 'up';
                element.previous(i).down(1).hide();
                effect = new Effect.MoveUpDown(element.previous(i), newPos);
            }
        }
        //alert(element.previousSiblings().last().id + ' edw ' + element.getDimensions().height + ' element ID ' + element.id);
        //alert(element.positionedOffset().top + ' <= element.top , last.top => ' +  element.previousSiblings().last().positionedOffset().top);
        var newPos = -(element.positionedOffset().top - element.previousSiblings().last().positionedOffset().top);

        size = element.previousSiblings().length;
        for (j = 1; j <= size; j++) {
            newPos += $('tabmenu'+j).getHeight();
        }
        //newPos += $('tabmenu1').getHeight() - 1;

        element.status = 'up';

        effect = new Effect.MoveUpDown(element, newPos);

        setTimeout(function(){$('listmenu1').hide();element.down(1).show();}, 250);

        }

        setTimeout(function(){fixCurtains();}, 250);
        setTimeout(function(){lock = 0;}, 250);
    }

}

Effect.MoveUpDown = function(element, offset) {
	element = $(element);
	var oldStyle = {opacity: element.getInlineOpacity() };
	return new Effect.Parallel(
	[ new Effect.Move(element, {x: 0, y: offset, sync: true }),
	  new Effect.Opacity(element, { sync: true, to: 0.5 }) ],
	Object.extend(
	  { duration: 0.25,
	    beforeSetup: function(effect) {
	      //effect.effects[0].element.makePositioned();
	    },
	    afterFinishInternal: function(effect) {
	      effect.effects[0].element.setStyle(oldStyle);
	    }
	  }, arguments[1] || { }));
};


var initUpperTabHeight;
var photoHeight;
document.fixUpperMenu = function() {

        var windowSize = getWindowSize();
        var windowHeight = parseInt(windowSize[1]);
        if ($('tabmenu')) {
            initUpperTabHeight = $('tabmenu').getHeight();
        }
        if ($('topPhoto')) {
            photoHeight = $('topPhoto').getHeight();
        }
        if (browser == 'IE6') {
            if ($('tabmenu')) {
                var tempSize = windowHeight - $('tabmenu').getHeight();
                if ($('menu')) {
                    $('menu').setAttribute("height", (tempSize) + 'px');
                }
            }
        }
       	
       	if ($('menu')) {
     	   $('menu').setStyle({height: (windowHeight - $('tabmenu').getHeight()) + 'px'});
        }
	
        if ($('logout')) {
            $('logout').setStyle({top: (windowHeight-$('logout').getHeight())+'px'});
            
            // The following code is used to move the logout button to the bottom of the page
            $('logout').status = "down";


            // The following code is used to set the active menu appearing and the rest to their correct positions
            var i = 2;
            var offset =$('logout').style.top.split("px");
            offset = offset[0];
        } else {
            offset = windowHeight - 26;
        }

        if ($('menu')) {
            var menus = $('menu').childElements().length - 1; // we do not take "logout" into account
            var active_menu = activeMenu;

            if (active_menu == 1) {
                // All menu tabs go down, except the top (which is stable)
                for (i = menus; i >= 2; i--) {
                    if ($('tabmenu'+i) && $('menu'+i)) {
                        offset = offset - $('tabmenu' + i).getHeight() - 1;
                        $('menu'+i).setStyle({top: (offset)+'px'});
                        $('menu'+i).status = 'down';
                        $('menu'+i).down(1).hide();
                    }
                }
            } else {

                // Only menu tabs after the active menu go down, the rest remain up
                for (i = menus; i > active_menu; i--) {
                    if ($('tabmenu'+i) && $('menu'+i)) {
                        offset = offset - $('tabmenu' + i).getHeight() - 1;
                        $('menu'+i).setStyle({top: (offset)+'px'});
                        $('menu'+i).status = 'down';
                        $('menu'+i).down(1).hide();
                    }
                }

                offset =initUpperTabHeight;

                for (i = 2; i <= active_menu; i++) {
                    if ($('tabmenu'+(i-1)) && $('menu'+i)) {
                        offset = offset + $('tabmenu' + (i-1)).getHeight() + 1;
                        $('menu'+i).setStyle({top: (offset)+'px'});
                        $('menu'+i).status = 'up';
                    }
                }
            }
        }
        
        
        hideLoadingDiv();
}

// Function used to hide and show the upper part of the sidebar
document.myhide = function() {
    var element = $('tabmenu');
    var tempHeight;
    // Adjust the height of the top frame
    if (element.status == 'hidden') {
        element.status = 'visible';
        $('topPhoto').show();
    } else {
        element.status = 'hidden';
        $('topPhoto').hide();
        tempHeight = initUpperTabHeight-photoHeight;
    }

    var menus = $('menu').childElements().length - 1; // we do not take "logout" into account
    var offset, menuTopOffset;
   
    // Adjust all other menus
    var i =2;
    for (i = 2; i <= menus; i++) {
        if (Object.isUndefined($('menu'+i).status) || $('menu'+i).status == 'up') {
            menuTopOffset = $('menu'+i).style.top.split("px");
            //eeeedw
            // SWSTI SOLUTION: offset = $('tabmenu').getHeight() + (i-1) * $('tabmenu1').getHeight();
            offset = $('tabmenu').getHeight() + (i-2) * $('tabmenu2').getHeight();
            offset += $('tabmenu1').getHeight();
            $('menu'+i).setStyle({top: (offset)+'px'});
        }
    }

    // Adjust logout menu
    var windowSize = getWindowSize();
    var windowHeight = parseInt(windowSize[1]);
    $('logout').setStyle({top: (windowHeight-$('logout').getHeight())+'px'});

    fixCurtains();

};


function ajaxBringRooms() {

    var url = translations['servername']+"ask_chat.php?bring_chatrooms=1";

    //$('chat_message
    new Ajax.Request(url, {
            method:'get',
            asynchronous:true,
            onSuccess: function (transport) {
                var select_item = document.getElementById('chat_rooms');
                // Delete all exept from the default room
                while(select_item.length > 1) {
                    select_item.remove(1);
                }

                var temp = transport.responseText.split('special_splitter');
                var elOptNew;
                var i;
                var j = 1;
                var selIndex = 0;
                current_room = $('current_chatroom_id').value;
                for (i = 0; i < temp.length-2; i = i + 3,j++) {
                    elOptNew = document.createElement('option');
                    // The "_" is appended to the id of the room to denote that
                    // this room's administration belongs to this user
                    isOwned = temp[i].lastIndexOf("_");
                    if (isOwned > 0) {
                        elOptNew.value = temp[i].substr(0,isOwned);
                        // This attribute denotes that the room belongs to this user
                        // and so can be deleted by him. Create the delete link and display it
                        elOptNew.setAttribute("isOwned", "1");
                    } else {
                        elOptNew.value = temp[i];

                    }

                    if (elOptNew.value == current_room) {
                        elOptNew.selected = true;
                        selIndex = j;

                    }

                    // Keep the 40 characters of the room's name
                    if(temp[i+1].length > 25) {
                        temp[i+1] = temp[i+1].substr(0,24) + "...";
                    }
                    elOptNew.text = temp[i+1]; // + ' (' + temp[i+2] + ')';//parenthesis

                    try {
                        select_item.add(elOptNew,null);
                    } catch(ex) {
                        select_item.add(elOptNew); // IE only
                    }

                }

                if (selIndex) {
                    select_item.selIndex = selIndex;
                    select_item.selectedIndex = selIndex; //always exists - 'No specific job description' in the branch
                }
            }
        });

}

// Only JS: get name from the chat_room select list
function getChatRoomName() {
    var allText = $('chat_rooms').options[$('chat_rooms').selectedIndex].text;
    name = allText.lastIndexOf("(");

    if (name > 0) {
        return allText.substr(0,name - 1); // the minus one for the space before the bracket
    } else {
        return allText;
    }

}

function ajaxEnterRoom(el) {

    var room = $('chat_rooms').value;
    var url = translations['servername']+"ask_chat.php?chatrooms_ID="+room+"&add_user=<?php echo $_SESSION['s_login'];?>&add_user_type=<?php echo $_SESSION['s_type'];?>";
    //alert(url);
    new Ajax.Request(url, {
            method:'get',
            asynchronous:false,
            onSuccess: function (transport) {
                $('current_chatroom_id').value = -1;    // used for sync
                $('last_spoken_login').value = "";
                $('first_time_messages').value = 1;
                test.document.getElementById("chat_content").innerHTML="";
                $('current_chatroom_id').value = $('chat_rooms').value;  // sync over all values correct

                isOwned = $('chat_rooms').options[$('chat_rooms').selectedIndex].getAttribute("isOwned");

                if (isOwned == 1) {
                    $('delete_room').setStyle({display:'block'});
                    $('delete_room_image').setStyle({display:'block'});
                } else {
                    $('delete_room').setStyle({display:'none'});
                }

                //alert($('current_chatroom_id').value);
           }
     });
}

function ajaxGetRoomUsers(el, event) {
    Element.extend(el);
    url = 'ask_chat.php?chatrooms_ID='+$('chat_rooms').value+'&get_users=1';
    $('room_users_image').writeAttribute({src:'images/others/progress1.gif'}).show();

    new Ajax.Request(url, {
        method:'get',
        asynchronous:true,
        onSuccess: function (transport) {


            name = getChatRoomName();
            $('room_users').innerHTML = '<b>' + name + "&nbsp;" + translations['onlineusers']+ ' </b><br>';
            if (transport.responseText == "") {
                $('room_users').innerHTML += translations['nousersinroom'];
            } else {
                $('room_users').innerHTML += transport.responseText;
            }
            eF_js_showHideDiv(el, 'room_users', event);
            $('room_users_image').writeAttribute({src:'images/16x16/users3.gif'}).show();
            $('room_users').setStyle({top:'20px',left:'1px'});

        }
    });

}

function inviteChatRoom(el) {
    el.href = "forum/new_message.php?chat_invite=" + $('current_chatroom_id').value;
}

function exportChatRoomHistory(el) {
    el.href = "chat/chat_room_options.php?past_messages=1&chat_room=" + $('current_chatroom_id').value;
}

function returnToMainRoom() {
    $('current_chatroom_id').value = -1;    // used for sync - lock acquired
    $('last_spoken_login').value = "";
    $('first_time_messages').value = 1;
    $('chat_rooms').value = 0;
    $('delete_room').setStyle({display:'none'});
    test.document.getElementById("chat_content").innerHTML += '<span style="font-size:10px;color:red;">' + translations['redirectedtomain'] + '</span>';
    $('current_chatroom_id').value = 0;     // sync complete - lock released
}

function ajaxDeleteRoom() {
    url = 'ask_chat.php?chatrooms_ID='+$('chat_rooms').value+'&delete_room=1';
    $('delete_room_image').writeAttribute({src:'images/others/progress1.gif'}).show();

    new Ajax.Request(url, {
        method:'get',
        asynchronous:true,
        onSuccess: function (transport) {

            $('delete_room_image').hide().setAttribute('src', 'images/16x16/check.png');
            new Effect.Appear($('delete_room_image'));
            window.setTimeout('Effect.Fade("delete_room_image")', 2000);
            window.setTimeout("$('delete_room').setStyle({display:'none'})", 3000);
            window.setTimeout("$('delete_room_image').writeAttribute({src:'images/16x16/delete.png'})", 3200);

            //$('delete_room').setStyle({display:'none'});
            name = getChatRoomName();
            test.document.getElementById("chat_content").innerHTML =  '<span style="font-size:10px;color:red;">' + name + ': ' + translations['chatroomdeleted'] + '<br>{literal}</span>';

            returnToMainRoom();

        }
    });
}


// Change the font size from 10->11->12->10...
// for element with id
function increaseChatboxFontSize() {

    font_size = parseInt($('current_font_size').value);

    if (++font_size > 12) {
        font_size = 10;
    }
    $('current_font_size').value = font_size;
    var all_cells = test.document.getElementById("chat_content").getElementsByTagName('td');
    for (var i =0 ; i< all_cells.length; i++) {
        all_cells[i].style.fontSize = $('current_font_size').value + 'px';

    }

    $('chat_rooms').style.fontSize = $('current_font_size').value + 'px';

    // Get sidebar to the end
    test.document.getElementById('chat_content').scrollTop=test.document.getElementById('chat_content').scrollHeight + 100;

}

function changeAccount(login) {
    new Ajax.Request('change_account.php?login='+login, {
        method:'get',
        asynchronous:true,
        onFailure: function (transport) {
            showMessage(transport.responseText, 'failure');
        },
        onSuccess: function (transport) {
            top.location = transport.responseText;
        }
    });
}


function checkSidebarMode(s_login) {
    var value = readCookie(s_login+'_sidebar');
    var valueMode = readCookie(s_login+'_sidebarMode');
    var unit = top.mainframe.location.toString().match('view_unit');

    if(unit=='view_unit' && value == 'hidden') {
        createCookie(s_login+'_sidebarMode','automatic',30);
    } else {
        createCookie(s_login+'_sidebarMode','manual',30);
    }
}