<?php
/*
 * Lesson settings
 */

    $options = array(
                   0 => array('image' => '16x16/gear.png',           'title' => _LESSONOPTIONS, 'link' => basename($_SERVER['PHP_SELF']).'?'.$baseUrl,                  'selected' => !isset($_GET['op'])                                  ? true : false),
                   1 => array('image' => '16x16/layout_center.png',  'title' => _LAYOUT,        'link' => basename($_SERVER['PHP_SELF']).'?'.$baseUrl.'&op=lesson_layout', 'selected' => isset($_GET['op']) && $_GET['op'] == 'lesson_layout' ? true : false),
                   2 => array('image' => '16x16/refresh.png',        'title' => _RESTARTLESSON, 'link' => basename($_SERVER['PHP_SELF']).'?'.$baseUrl.'&op=reset_lesson' , 'selected' => isset($_GET['op']) && $_GET['op'] == 'reset_lesson'  ? true : false),
                   3 => array('image' => '16x16/import2.png',        'title' => _IMPORTLESSON,  'link' => basename($_SERVER['PHP_SELF']).'?'.$baseUrl.'&op=import_lesson', 'selected' => isset($_GET['op']) && $_GET['op'] == 'import_lesson' ? true : false),
                   4 => array('image' => '16x16/export1.png',        'title' => _EXPORTLESSON,  'link' => basename($_SERVER['PHP_SELF']).'?'.$baseUrl.'&op=export_lesson', 'selected' => isset($_GET['op']) && $_GET['op'] == 'export_lesson' ? true : false),
                   5 => array('image' => '16x16/users3.png',         'title' => _LESSONUSERS,   'link' => basename($_SERVER['PHP_SELF']).'?'.$baseUrl.'&op=lesson_users',  'selected' => isset($_GET['op']) && $_GET['op'] == 'lesson_users'  ? true : false));
    //Unset values based on user's type restrictions
    if (isset($currentUser -> coreAccess['content']) && $currentUser -> coreAccess['content'] != 'change') {
        unset($options[2]);
        unset($options[3]);
        unset($options[4]);
    }
    if (isset($currentUser -> coreAccess['users']) && $currentUser -> coreAccess['users'] == 'hidden') {
        unset($options[5]);
    }
    //Reindex options so that indices are serial starting from 0 (this way they display correctly)
    $options = array_values($options);

    $smarty -> assign("T_TABLE_OPTIONS", $options);

    if ($_GET['op'] == 'reset_lesson') {
        if (isset($currentUser -> coreAccess['content']) && $currentUser -> coreAccess['content'] != 'change') {
            header("location:".basename($_SERVER['PHP_SELF'])."?ctg=control_panel&message=".urlencode(_UNAUTHORIZEDACCESS)."&message_type=failure");
        }
        /*Reset lesson part*/
        $form = new HTML_QuickForm("reset_lesson_form", "post", basename($_SERVER['PHP_SELF']).'?'.$baseUrl.'&op=reset_lesson', "", null, true);

        $form -> addElement('checkbox', 'options[content]',    _CONTENT,          null, 'class = "inputCheckBox" id = "content" onclick = "$$(\'input.contentDerivative\').each(function (s) {s.checked = $(\'content\').checked})"');
        $form -> addElement('checkbox', 'options[tests]',      _TESTS,            '<span class = "infoCell">('._DEPENDSONCONTENT.')</span>', 'class = "inputCheckBox contentDerivative" style = "vertical-align:middle" onclick = "if ($(\'content\').checked) this.checked = 1"');
        $form -> addElement('checkbox', 'options[questions]',  _QUESTIONS,        '<span class = "infoCell">('._DEPENDSONCONTENT.')</span>', 'class = "inputCheckBox contentDerivative" style = "vertical-align:middle" onclick = "if ($(\'content\').checked) this.checked = 1"');
        $form -> addElement('checkbox', 'options[rules]',      _ACCESSRULES,      '<span class = "infoCell">('._DEPENDSONCONTENT.')</span>', 'class = "inputCheckBox contentDerivative" style = "vertical-align:middle" onclick = "if ($(\'content\').checked) this.checked = 1"');
        $form -> addElement('checkbox', 'options[conditions]', _LESSONCONDITIONS, '<span class = "infoCell">('._DEPENDSONCONTENT.')</span>', 'class = "inputCheckBox contentDerivative" style = "vertical-align:middle" onclick = "if ($(\'content\').checked) this.checked = 1"');
        $form -> addElement('checkbox', 'options[comments]',   _COMMENTS,         '<span class = "infoCell">('._DEPENDSONCONTENT.')</span>', 'class = "inputCheckBox contentDerivative" style = "vertical-align:middle" onclick = "if ($(\'content\').checked) this.checked = 1"');

        $form -> addElement('checkbox', 'options[users]',      _USERS,                   null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[news]',       _ANNOUNCEMENTS,           null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[files]',      _FILES,                   null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[calendar]',   _CALENDAR,                null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[glossary]',   _GLOSSARY,                null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[projects]',   _PROJECTS,                null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[tracking]',   _USERTRACKINGINFORMATION, null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[scheduling]', _SCHEDULING,              null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[surveys]',    _SURVEYS,                 null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[modules]',    _MODULES,                 null, 'class = "inputCheckBox"');

        $form -> addElement('submit', 'submit_reset_lesson', _SUBMIT, 'class = "flatButton"');

        if ($form -> isSubmitted() && $form -> validate()) {
            $values         = $form -> exportValues();
            $currentLesson -> initialize(array_keys($values['options']));

            $message      = _RESTARTLESSONCOMPLETED;
            $message_type = 'success';
        }

        $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);
        $form -> accept($renderer);
        $smarty -> assign('T_RESET_LESSON_FORM', $renderer -> toArray());
    } elseif ($_GET['op'] == 'import_lesson') {
        if (isset($currentUser -> coreAccess['content']) && $currentUser -> coreAccess['content'] != 'change') {
            header("location:".basename($_SERVER['PHP_SELF'])."?ctg=control_panel&message=".urlencode(_UNAUTHORIZEDACCESS)."&message_type=failure");
        }
        /* Import part */
        $form = new HTML_QuickForm("import_lesson_form", "post", basename($_SERVER['PHP_SELF']).'?'.$baseUrl.'&op=import_lesson', "", null, true);

        $form -> addElement('checkbox', 'options[content]',    _CONTENT,          null, 'class = "inputCheckBox" id = "content" onclick = "$$(\'input.contentDerivative\').each(function (s) {s.checked = $(\'content\').checked})"');
        $form -> addElement('checkbox', 'options[tests]',      _TESTS,            '<span class = "infoCell">('._DEPENDSONCONTENT.')</span>', 'class = "inputCheckBox contentDerivative" style = "vertical-align:middle" onclick = "if ($(\'content\').checked) this.checked = 1"');
        $form -> addElement('checkbox', 'options[questions]',  _QUESTIONS,        '<span class = "infoCell">('._DEPENDSONCONTENT.')</span>', 'class = "inputCheckBox contentDerivative" style = "vertical-align:middle" onclick = "if ($(\'content\').checked) this.checked = 1"');
        $form -> addElement('checkbox', 'options[rules]',      _ACCESSRULES,      '<span class = "infoCell">('._DEPENDSONCONTENT.')</span>', 'class = "inputCheckBox contentDerivative" style = "vertical-align:middle" onclick = "if ($(\'content\').checked) this.checked = 1"');
        $form -> addElement('checkbox', 'options[conditions]', _LESSONCONDITIONS, '<span class = "infoCell">('._DEPENDSONCONTENT.')</span>', 'class = "inputCheckBox contentDerivative" style = "vertical-align:middle" onclick = "if ($(\'content\').checked) this.checked = 1"');
        $form -> addElement('checkbox', 'options[comments]',   _COMMENTS,         '<span class = "infoCell">('._DEPENDSONCONTENT.')</span>', 'class = "inputCheckBox contentDerivative" style = "vertical-align:middle" onclick = "if ($(\'content\').checked) this.checked = 1"');

        $form -> addElement('checkbox', 'options[users]',      _USERS,                   null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[news]',       _ANNOUNCEMENTS,           null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[files]',      _FILES,                   null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[calendar]',   _CALENDAR,                null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[glossary]',   _GLOSSARY,                null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[projects]',   _PROJECTS,                null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[tracking]',   _USERTRACKINGINFORMATION, null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[scheduling]', _SCHEDULING,              null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[surveys]',    _SURVEYS,                 null, 'class = "inputCheckBox"');
        $form -> addElement('checkbox', 'options[modules]',    _MODULES,                 null, 'class = "inputCheckBox"');

        $form -> addElement('file', 'file_upload', null, 'class = "inputText"');                    //Lesson file
        $form -> setMaxFileSize(FileSystemTree :: getUploadMaxSize() * 1024);            //getUploadMaxSize returns size in KB
        $form -> addElement('submit', 'submit_import_lesson', _SUBMIT, 'class = "flatButton"');

        $smarty -> assign("T_MAX_FILESIZE", FileSystemTree :: getUploadMaxSize());

        if ($form -> isSubmitted() && $form -> validate()) {
            try {
                $values         = $form -> exportValues();
                $currentLesson -> initialize(array_keys($values['options']));

                $filesystem     = new FileSystemTree($currentLesson -> getDirectory());
                $uploadedFile   = $filesystem -> uploadFile('file_upload', $currentLesson -> getDirectory());
                $currentLesson -> import($uploadedFile);

                $smarty -> assign("T_REFRESH_SIDE", 1);

                $message      = _LESSONIMPORTEDSUCCESFULLY;
                $message_type = 'success';
            } catch (Exception $e) {
                $smarty -> assign("T_EXCEPTION_TRACE", $e -> getTraceAsString());
                $message      = _PROBLEMIMPORTINGFILE.': '.$e -> getMessage().' ('.$e -> getCode().') &nbsp;<a href = "javascript:void(0)" onclick = "eF_js_showDivPopup(\''._ERRORDETAILS.'\', 2, \'error_details\')">'._MOREINFO.'</a>';
                $message_type = 'failure';
            }
        }

        $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);
        $form -> accept($renderer);
        $smarty -> assign('T_IMPORT_LESSON_FORM', $renderer -> toArray());
    } elseif ($_GET['op'] == 'export_lesson') {
        if (isset($currentUser -> coreAccess['content']) && $currentUser -> coreAccess['content'] != 'change') {
            header("location:".basename($_SERVER['PHP_SELF'])."?ctg=control_panel&message=".urlencode(_UNAUTHORIZEDACCESS)."&message_type=failure");
        }

        /* Export part */
        $form = new HTML_QuickForm("export_lesson_form", "post", basename($_SERVER['PHP_SELF']).'?'.$baseUrl.'&op=export_lesson', "", null, true);
        $form -> addElement('submit', 'submit_export_lesson', _EXPORT, 'class = "flatButton"');

        try {
            $currentExportedFile = new EfrontFile($currentUser -> user['directory'].'/temp/'.EfrontFile :: encode($currentLesson -> lesson['name']).'.zip');
            $smarty -> assign("T_EXPORTED_FILE", $currentExportedFile);
        } catch (Exception $e) {}

        if ($form -> isSubmitted() && $form -> validate()) {
            try {
                $file   = $currentLesson -> export('all');
                $smarty -> assign("T_NEW_EXPORTED_FILE", $file);

                $message      = _LESSONEXPORTEDSUCCESFULLY;
                $message_type = 'success';
            } catch (Exception $e) {
                $smarty -> assign("T_EXCEPTION_TRACE", $e -> getTraceAsString());
                $message = $e -> getMessage().' ('.$e -> getCode().') &nbsp;<a href = "javascript:void(0)" onclick = "eF_js_showDivPopup(\''._ERRORDETAILS.'\', 2, \'error_details\')">'._MOREINFO.'</a>';
            }
        }

        $renderer =& new HTML_QuickForm_Renderer_ArraySmarty($smarty);
        $form -> accept($renderer);
        $smarty -> assign('T_EXPORT_LESSON_FORM', $renderer -> toArray());

    } elseif ($_GET['op'] == 'lesson_users') {
        if (isset($currentUser -> coreAccess['users']) && $currentUser -> coreAccess['users'] == 'hidden') {
            header("location:".basename($_SERVER['PHP_SELF'])."?ctg=control_panel&message=".urlencode(_UNAUTHORIZEDACCESS)."&message_type=failure");
        }
        try {
            $lessonUsers    = $currentLesson -> getUsers();                    //Get all users that have this lesson
            unset($lessonUsers[$currentUser -> login]);                        //Remove the current user from the list, he can't set parameters for his self!
            $nonLessonUsers = $currentLesson -> getNonUsers();                 //Get all the users that can, but don't, have this lesson
            $users          = array_merge($lessonUsers, $nonLessonUsers);      //Merge users to a single array, which will be useful for displaying them

            foreach ($users as $key => $user) {
                in_array($key, array_keys($nonLessonUsers)) ? $users[$key]['in_lesson'] = false : $users[$key]['in_lesson'] = true;
            }

            $roles = eF_getTableDataFlat("user_types","name","active=1 AND basic_user_type!='administrator'");    //Get available roles
            if (sizeof($roles) > 0) {
                $roles = array_combine($roles['name'], $roles['name']);                                          //Match keys with values, it's more practical this way
            }
            $roles = array_merge(array('student' => _STUDENT, 'professor' => _PROFESSOR), $roles);                     //Append basic user types to the beginning of the array

            if (isset($_GET['ajax']) && $_GET['ajax'] == 'usersTable') {
                isset($_GET['limit']) && eF_checkParameter($_GET['limit'], 'uint') ? $limit = $_GET['limit'] : $limit = G_DEFAULT_TABLE_SIZE;

                if (isset($_GET['sort']) && eF_checkParameter($_GET['sort'], 'text')) {
                    $sort = $_GET['sort'];
                    isset($_GET['order']) && $_GET['order'] == 'desc' ? $order = 'desc' : $order = 'asc';
                } else {
                    $sort = 'login';
                }
                $users = eF_multiSort($users, $sort, $order);
                $smarty -> assign("T_USERS_SIZE", sizeof($users));
                if (isset($_GET['filter'])) {
                    $users = eF_filterData($users, $_GET['filter']);
                }
                if (isset($_GET['limit']) && eF_checkParameter($_GET['limit'], 'int')) {
                    isset($_GET['offset']) && eF_checkParameter($_GET['offset'], 'int') ? $offset = $_GET['offset'] : $offset = 0;
                    $users = array_slice($users, $offset, $limit);
                }

                $smarty -> assign("T_ROLES", $roles);
                $smarty -> assign("T_ALL_USERS", $users);
                $smarty -> assign("T_LESSON_USERS", array_keys($lessonUsers));                                             //We assign separately the lesson's users, to know when to display the checkboxes as "checked"
                $smarty -> assign("T_CURRENT_USER", $currentUser);
                $smarty -> display('includes/lesson_settings.tpl');
                exit;
            }

        } catch (Exception $e) {
            $smarty -> assign("T_EXCEPTION_TRACE", $e -> getTraceAsString());
            $message      = $e -> getMessage().' ('.$e -> getCode().') &nbsp;<a href = "javascript:void(0)" onclick = "eF_js_showDivPopup(\''._ERRORDETAILS.'\', 2, \'error_details\')">'._MOREINFO.'</a>';
            $message_type = 'failure';
        }

        if (isset($_GET['postAjaxRequest'])) {
            try {
                if (isset($_GET['login']) && eF_checkParameter($_GET['login'], 'login')) {
                    isset($_GET['user_type']) && in_array($_GET['user_type'], array_keys($roles)) ? $userType = $_GET['user_type'] : $userType = 'student';
                    if (in_array($_GET['login'], array_keys($nonLessonUsers))) {
                        $currentLesson -> addUsers($_GET['login'], $userType);
                    }
                    if (in_array($_GET['login'], array_keys($lessonUsers))) {
                        $userType != $lessonUsers[$_GET['login']]['role'] ? $currentLesson -> setRoles($_GET['login'], $userType) : $currentLesson -> removeUsers($_GET['login']);
                    }
                } else if (isset($_GET['addAll'])) {
                    isset($_GET['filter']) ? $nonLessonUsers = eF_filterData($nonLessonUsers, $_GET['filter']) : null;
                    $currentLesson -> addUsers(array_keys($nonLessonUsers));
                } else if (isset($_GET['removeAll'])) {
                    isset($_GET['filter']) ? $lessonUsers = eF_filterData($lessonUsers, $_GET['filter']) : null;
                    $currentLesson -> removeUsers(array_keys($lessonUsers));
                }
            } catch (Exception $e) {
                header("HTTP/1.0 500 ");
                echo $e -> getMessage().' ('.$e -> getCode().')';
            }
            exit;
        }
    } elseif ($_GET['op'] == 'lesson_layout') {
        $loadScripts[] = 'scriptaculous/scriptaculous';
        $loadScripts[] = 'scriptaculous/effects';
        $loadScripts[] = 'scriptaculous/dragdrop';
        $defaultPositions = unserialize($currentLesson -> options['default_positions']);

        $result = eF_getTableData("modules", "*");
        foreach ($result as $value) {
            $moduleInfo[$value['className']] = $value;
        }
        $curretType = $currentUser -> user['user_type'];
        $currentUser -> user['user_type'] = 'student';
        $modules    = eF_loadAllModules();
        foreach($modules as $key => $module) {
            if ($module -> getLessonModule() && $currentLesson -> options[$key]) {
                $lessonModules[$key] = $moduleInfo[$key];
            }
        }
        $currentUser -> user['user_type'] = $currentType;
//pr($lessonModules);
        $smarty -> assign("T_LESSON_MODULES", $lessonModules);

        $invalidOptions = array();
        !$currentLesson -> options['content_tree']    ? $invalidOptions['moduleContentTree']    = 1 : null;
        !$currentLesson -> options['projects']        ? $invalidOptions['moduleProjectsList']   = 1 : null;
        !$currentLesson -> options['forum']           ? $invalidOptions['moduleForumList']      = 1 : null;
        !$currentLesson -> options['comments']        ? $invalidOptions['moduleComments']       = 1 : null;
        !$currentLesson -> options['calendar']        ? $invalidOptions['moduleCalendar']       = 1 : null;
        !$currentLesson -> options['digital_library'] ? $invalidOptions['moduleDigitalLibrary'] = 1 : null;
        $smarty -> assign("T_INVALID_OPTIONS", $invalidOptions);


        $smarty -> assign("T_DEFAULT_POSITIONS", $defaultPositions);
    } else {
        $lessonSettings['theory']          = array('text' => _THEORY,            'image' => isset($currentLesson -> options['theory'])          && $currentLesson -> options['theory']          ? "32x32/book_blue.png"     : "32x32/book_blue_gray.png",     'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'theory\')',          'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 2);
        $lessonSettings['examples']        = array('text' => _EXAMPLES,          'image' => isset($currentLesson -> options['examples'])        && $currentLesson -> options['examples']        ? "32x32/lightbulb_on.png"  : "32x32/lightbulb_on_gray.png",  'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'examples\')',        'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 2);
        $lessonSettings['projects']        = array('text' => _PROJECTS,          'image' => isset($currentLesson -> options['projects'])        && $currentLesson -> options['projects']        ? "32x32/exercises.png"     : "32x32/exercises_gray.png",     'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'projects\')',        'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 2);
        $lessonSettings['tests']           = array('text' => _TESTS,             'image' => isset($currentLesson -> options['tests'])           && $currentLesson -> options['tests']           ? "32x32/document_edit.png" : "32x32/document_edit_gray.png", 'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'tests\')',           'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 2);
        $lessonSettings['survey']          = array('text' => _SURVEY,            'image' => isset($currentLesson -> options['survey'])          && $currentLesson -> options['survey']          ? "32x32/form_green.png"    : "32x32/form_green_gray.png",    'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'survey\')',          'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 2);
        $lessonSettings['rules']           = array('text' => _ACCESSRULES,       'image' => isset($currentLesson -> options['rules'])           && $currentLesson -> options['rules']           ? "32x32/recycle.png"       : "32x32/recycle_gray.png",       'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'rules\')',           'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 2);
        $lessonSettings['forum']           = array('text' => _FORUM,             'image' => isset($currentLesson -> options['forum'])           && $currentLesson -> options['forum']           ? "32x32/messages.png"      : "32x32/messages_gray.png",      'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'forum\')',           'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 2);
        $lessonSettings['comments']        = array('text' => _COMMENTS,          'image' => isset($currentLesson -> options['comments'])        && $currentLesson -> options['comments']        ? "32x32/note.png"          : "32x32/note_gray.png",          'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'comments\')',        'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 2);
        $lessonSettings['online']          = array('text' => _USERSONLINE,       'image' => isset($currentLesson -> options['online'])          && $currentLesson -> options['online']          ? "32x32/users4.png"        : "32x32/users4_gray.png",        'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'online\')',          'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 1);
        if ($GLOBALS['configuration']['chat_enabled']) {
            $lessonSettings['chat']        = array('text' => _CHAT,              'image' => isset($currentLesson -> options['chat'])            && $currentLesson -> options['chat']            ? "32x32/user1_message.png" : "32x32/user1_message_gray.png", 'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'chat\')',            'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 2);
        }
        $lessonSettings['scorm']              = array('text' => _SCORM,                 'image' => isset($currentLesson -> options['scorm'])                && $currentLesson -> options['scorm']               ? "32x32/book_red.png"           : "32x32/book_red_gray.png",           'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'scorm\')',              'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 2);

        if (sizeof(eF_getTableData("files", "id", "shared=".$currentLesson -> lesson['id'])) > 0) {
	        $lessonSettings['digital_library']    = array('text' => _DIGITALLIBRARY,        'image' => isset($currentLesson -> options['digital_library'])      && $currentLesson -> options['digital_library']     ? "32x32/disk_blue.png"          : "32x32/disk_blue_gray.png",          'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'digital_library\')',    'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 2);
		}
        $lessonSettings['calendar']           = array('text' => _CALENDAR,              'image' => isset($currentLesson -> options['calendar'])             && $currentLesson -> options['calendar']            ? "32x32/calendar.png"           : "32x32/calendar_gray.png",           'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'calendar\')',           'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 2);
        $lessonSettings['glossary']           = array('text' => _GLOSSARY,              'image' => isset($currentLesson -> options['glossary'])             && $currentLesson -> options['glossary']            ? "32x32/book_open2.png"         : "32x32/book_open2_gray.png",         'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'glossary\')',           'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 2);
        $lessonSettings['auto_complete']      = array('text' => _AUTOCOMPLETE,          'image' => isset($currentLesson -> options['auto_complete'])        && $currentLesson -> options['auto_complete']       ? "32x32/book_green.png"         : "32x32/book_green_gray.png",         'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'auto_complete\')',      'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 1);
        $lessonSettings['content_tree']       = array('text' => _CONTENTTREEFIRSTPAGE,  'image' => isset($currentLesson -> options['content_tree'])         && $currentLesson -> options['content_tree']        ? "32x32/text_tree.png"          : "32x32/text_tree_gray.png",          'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'content_tree\')',       'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 1);
        $lessonSettings['lesson_info']        = array('text' => _LESSONINFORMATION,     'image' => isset($currentLesson -> options['lesson_info'])          && $currentLesson -> options['lesson_info']         ? "32x32/about.png"              : "32x32/about_gray.png",              'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'lesson_info\')',        'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 2);
        $lessonSettings['bookmarking']        = array('text' => _BOOKMARKS,             'image' => isset($currentLesson -> options['bookmarking'])          && $currentLesson -> options['bookmarking']         ? "32x32/bookmark.png"           : "32x32/bookmark_gray.png",           'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'bookmarking\')',        'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 1);
        $lessonSettings['content_report']     = array('text' => _CONTENTREPORT,         'image' => isset($currentLesson -> options['content_report'])       && $currentLesson -> options['content_report']      ? "32x32/warning.png"            : "32x32/warning_gray.png",            'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'content_report\')',     'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 1);
        $lessonSettings['start_resume']       = array('text' => _STARTRESUME,           'image' => isset($currentLesson -> options['start_resume'])         && $currentLesson -> options['start_resume']        ? "32x32/media_play.png"         : "32x32/media_play_gray.png",         'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'start_resume\')',       'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 1);
        $lessonSettings['hide_percentage']    = array('text' => _HIDEPERCENTAGE,        'image' => isset($currentLesson -> options['hide_percentage'])      && $currentLesson -> options['hide_percentage']     ? "32x32/percent.png"            : "32x32/percent_gray.png",            'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'hide_percentage\')',    'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 1);
        $lessonSettings['hide_content_tools'] = array('text' => _HIDEEXTRAOPTIONS,      'image' => isset($currentLesson -> options['hide_content_tools'])   && $currentLesson -> options['hide_content_tools']  ? "32x32/preferences.png"        : "32x32/preferences_gray.png",        'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'hide_content_tools\')', 'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 1);
        $lessonSettings['hide_right_bar']     = array('text' => _HIDERIGHTBAR,          'image' => isset($currentLesson -> options['hide_right_bar'])       && $currentLesson -> options['hide_right_bar']      ? "32x32/navigate_end.png"       : "32x32/navigate_end_gray.png",       'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'hide_right_bar\')',     'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 1);
        $lessonSettings['hide_left_bar']      = array('text' => _HIDELEFTBAR,           'image' => isset($currentLesson -> options['hide_left_bar'])        && $currentLesson -> options['hide_left_bar']       ? "32x32/navigate_beginning.png" : "32x32/navigate_beginning_gray.png", 'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'hide_left_bar\')',      'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 1);
        
        //$lessonSettings['dynamic_periods'] = array('text' => _PERIODSPERSTUDENT, 'image' => isset($currentLesson -> options['dynamic_periods']) && $currentLesson -> options['dynamic_periods'] ? "32x32/user1_time.png"    : "32x32/user1_time_gray.png",    'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'dynamic_periods\')', 'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 1);
        //$lessonSettings['new_content']     = array('text' => _NEWCONTENT,        'image' => isset($currentLesson -> options['new_content'])     && $currentLesson -> options['new_content']     ? "32x32/book_blue_new.png" : "32x32/book_blue_new_gray.png", 'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'new_content\')',     'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 1);
        //$lessonSettings['tracking']        = array('text' => _TRACKING,          'image' => isset($currentLesson -> options['tracking'])        && $currentLesson -> options['tracking']        ? "32x32/dot-chart.png"     : "32x32/dot-chart_gray.png",     'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \'tracking\')',        'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 1);

        ///MODULES6
        if ($currentUser -> getType() == "administrator") {
            $loadedModules = eF_loadAllModules();
        }
        
        foreach ($loadedModules as $module) {
            if ($module -> isLessonModule()) {
            	// The $setLanguage variable is defined in globals.php
			    if (!in_array("administrator", $module -> getPermittedRoles())) {
				    $mod_lang_file = $module -> getLanguageFile($setLanguage);
				    if (is_file ($mod_lang_file)) {
				        require_once $mod_lang_file;
				    }
			    }                
                $lessonSettings[$module -> className] = array('text' => $module -> getName(), 'image' => ($currentLesson -> options[$module -> className] == 1) ? "32x32/component_green.png"  : "32x32/component_green_gray.png", 'href' => 'javascript:void(0)', 'onClick' => 'activate(this, \''.$module -> className.'\')', 'style' => 'color:gray', 'title' => _CLICKTOTOGGLE, 'group' => 2);
            }
        }

        foreach ($currentLesson -> options as $key => $value) {                                               //Remove activated elements from above list
            if ($value && isset($lessonSettings[$key])) {
                $lessonSettings[$key]['onClick'] = 'activate(this, \''.$key.'\')';
                $lessonSettings[$key]['style']   = 'color:inherit';
            }
        }

        //If the professor's type restricts access to settings, unset all 'onclick' actions
        if (isset($currentUser -> coreAccess['settings']) && $currentUser -> coreAccess['settings'] != 'change') {
            foreach ($lessonSettings as $key => $value) {
                $lessonSettings[$key]['onClick'] = '';
            }
        }

        $smarty -> assign("T_LESSON_SETTINGS", $lessonSettings);
        $smarty -> assign("T_LESSON_SETTINGS_GROUPS", array(1 => _LESSONOPTIONS, 2 => _LESSONMODULES));

        if (!isset($currentUser -> coreAccess['settings']) || $currentUser -> coreAccess['settings'] == 'change') {
            if (isset($_GET['ajax']) && isset($_GET['activate']) && in_array($_GET['activate'], array_keys($lessonSettings))) {
                pr($currentLesson);
                try {
                    $currentLesson -> options[$_GET['activate']] = 1;
                    if ($_GET['activate'] == 'chat') {
                        $currentLesson -> enableChatroom();
                    }
                    echo "#2";
                    $currentLesson -> persist();
                    echo "#3";
                    if ($currentLesson -> options['digital_library'] == 1) {                        //If the professor set a digital library, create the corresponding if folder, if it does not exist
                        if (!is_dir(G_LESSONSPATH.$currentLesson -> lesson['id']."/"."Digital Library"))
                        @mkdir(G_LESSONSPATH.$currentLesson -> lesson['id']."/"."Digital Library");
                    }
                    echo "Option activated";
                } catch (Exception $e) {
                    header("HTTP/1.0 500 ");
                    echo $e -> getMessage().' ('.$e -> getCode().')';
                }
                exit;
            } elseif (isset($_GET['ajax']) && isset($_GET['deactivate']) && in_array($_GET['deactivate'], array_keys($lessonSettings))) {
                try {
                    $currentLesson -> options[$_GET['deactivate']] = 0;
                    if ($_GET['deactivate'] == 'chat') {
                        $currentLesson -> disableChatroom();
                    }
                    $currentLesson -> persist();
                    echo "Option deactivated";
                } catch (Exception $e) {
                    header("HTTP/1.0 500");
                    echo $e -> getMessage().' ('.$e -> getCode().')';
                }
                exit;
            }
        }
    }

?>