<?php
///////////////////////////////////////////////////////////////////////////////////////
// PHPizabi 0.844b C1 [ALICIA]                               http://www.phpizabi.net //
///////////////////////////////////////////////////////////////////////////////////////
// Please read the license.txt file before using / modifying this software           //
// Original author:         Claude Desjardins, R - feedback@realitymedias.com        //
// Last modification date:  August 26th 2006                                         //
// Version:                 PHPizabi 0.844b C1                                       //
//                                                                                   //
// (C) 2005, 2006 Real!ty Medias / PHPizabi - All rights reserved                    //
///////////////////////////////////////////////////////////////////////////////////////

	/* Check Structure Availability */
	if (!defined("CORE_STRAP")) die("Out of structure call");
	
	// TEMPLATE HANDLING ////////////////////////////////////////////////////////////////// FINAL //
	/*
		Initialize the template engine and
		load the template file. Get objects,
		convert self user.
	*/
	$tpl = new template;
	$tpl -> Load("index");
	
	
	
	/*
		Compute open fights
	*/
	$select = myQ("
		SELECT * 
		FROM `[x]fight`
		WHERE `opponent`='0'
		ORDER BY `id` DESC
		LIMIT 100
	");
	
	while($row = myF($select)) {
		
		$fightReplacement[] = array(
			"of.username" => user($row["user"], "username"),
			"of.topic" => $row["topic"],
			"of.id" => $row["id"],
		);
	}
	$tpl -> Loop("openfights", (isset($fightReplacement)?$fightReplacement:array()));
	
	/*
		Compute running fights
	*/
	$select = myQ("
		SELECT * 
		FROM `[x]fight`
		WHERE `opponent` != '0'
		AND `start` != '0'
		AND `expire` > '".time()."'
		ORDER BY `id` DESC
		LIMIT 100
	");
	
	while($row = myF($select)) {
		
		$runningFightsReplacement[] = array(
			"f.username" => user($row["user"], "username"),
			"f.opponent" => user($row["opponent"], "username"),
			"f.remaining" => round (($row["expire"] - time()) / 60),
			"f.id" => $row["id"],
		);
	}
	$tpl -> Loop("fights", (isset($runningFightsReplacement)?$runningFightsReplacement:array()));
	
	/*
		Conpute last winners
	*/
	$select = myQ("
		SELECT *
		FROM `[x]fight`
		WHERE `opponent` != '0'
		AND `expire` < '".time()."'
		AND `user_points` != `opponent_points`
		ORDER BY `expire` DESC
		LIMIT 10
	");
	
	while($row = myF($select)) {
		
		if ($row["user_points"] > $row["opponent_points"]) {
			$winner = $row["user"];
			$looser = $row["opponent"];
		} else {
			$winner = $row["opponent"];
			$looser = $row["user"];
		}
		
		$wonFightsReplacement[] = array(
			"winner.username" => user($winner, "username"),
			"winner.picture" => user($winner, "mainpicture"),
			"winner.fightid" => $row["id"],
			"looser.username" => user($looser, "username"),
			"looser.picture" => user($looser, "mainpicture"),
			"winner.topic" => substr($row["topic"], 0, 50)
		);
	}
	$tpl -> Loop("winners", (isset($wonFightsReplacement)?$wonFightsReplacement:array()));
	
	$tpl -> Flush();
	
?>