<?php
///////////////////////////////////////////////////////////////////////////////////////
// PHPizabi 0.848b C1 [ALICIA]                               http://www.phpizabi.net //
///////////////////////////////////////////////////////////////////////////////////////
// Please read the license.txt file before using / modifying this software           //
// Original author:         Claude Desjardins, R - feedback@realitymedias.com        //
// Last modification date:  August 13th 2006                                         //
// Version:                 PHPizabi 0.848b C1                                       //
//                                                                                   //
// (C) 2005, 2006 Real!ty Medias / PHPizabi - All rights reserved                    //
///////////////////////////////////////////////////////////////////////////////////////

	/* Check Structure Availability */
	if (!defined("CORE_STRAP")) die("Out of structure call");
	
	//function pagination($page,$url,$max_results,$max_links,$total_results,$sql=0,$pg="page") {

	function pagination($tpl,$totalRows,$page=1,$resultsPerPage) {

	global $CONF;


	// PAGINATION ////////////////////////////////////////////////////////////////
	$totalPages = ceil($totalRows / $resultsPerPage);
		
	if ($totalPages > 1) {
			
		$tpl -> Zone("paginationBlock", "enabled");
			
		/*
			If the total number of pages to be shown exceed
			the total number of pages we are allowed to show,
			we will show the total allowed pages instead.
		*/
		$showPages = ($totalPages>$CONF["SEARCH_PAGINATION_PADDING"]?$CONF["SEARCH_PAGINATION_PADDING"]:$totalPages);
			
		/*
			Find out the first page to start up with; if
			the total number of pages to show divided by
			two (total middle) is greater than the actual 
			page number, we will start with the actual page
			minus the result of the total pages to show 
			divided by two; else, we start with page one.
		*/
		if ($totalPages > $showPages && $page > ceil($showPages/2)) {
				
			/*
				Set the first page
			*/
			$startUpPage = $page - floor($showPages/2);
	
			/*
				Make sure we show the maximum number of pages
				when we're at the end of the results. If 
				the value of startuppage (first page
				to be shown) minus the total number of
				shown pages is greater than the total number
				of pages to be displayed, it means the
				first page should be the result of the
				total pages minus the total of shown
				pages
			*/
			if (($startUpPage+$showPages) > $totalPages) $startUpPage = $totalPages - $showPages;
		}
			
		else $startUpPage = 1;
	
		/*
			Find out the last page number we will show
		*/		
		$lastPage = ($startUpPage+$showPages<$totalPages?$startUpPage+$showPages:$totalPages);
	
		/*
			Build up the actual page link, we will force the
			L value and remove the page value.
		*/
		$getDataString = "?L=".$_GET["L"];
	
		foreach ($_GET as $var => $val) {
			if (!is_array($val)) {
				if ($var != "page" && $var != "L" && $val != "ck") $getDataString .= "&{$var}={$val}";
			} else foreach ($val as $arVar => $arVal) {
				$getDataString .= "&{$var}[]={$arVal}";
			}
		}
	
		/*
			If the page is greater than page 2
			(not page one, not page two which are
			already linked if $page <= 2), we show
			a "back" link
		*/
		if ($page > 1) {
			$tpl -> Zone("pagination.back", "linked");
			$tpl -> AssignArray(array("pagination.back.link" => $getDataString."&page=".($page-1)));
		} else $tpl -> Zone("pagination.back", "disabled");
	
		/*
			If the first page isnt page number one, 
			we will show a link to it
		*/
		if ($startUpPage > 1) {
			$tpl -> Zone("pagination.first", "linked");
			$tpl -> AssignArray(array("pagination.first.link" => $getDataString."&page=1"));
		} else $tpl -> Zone("pagination.first", "disabled");
	
	
		/*
			Generate the pages
		*/
		$paginationMergeContent = NULL;
		for ($i=$startUpPage; $i<=$lastPage; $i++) {
				
			if ($i == $page) {
				$replaceArray = array(
					"{pagination.page.pageNumber}" => $i
				);
					
				$paginationMergeContent .= strtr($GLOBALS["OBJ"]["pagination.unlinked.page"], $replaceArray);
			} else {
				$replaceArray = array(
					"{pagination.page.pageNumber}" => $i,
					"{pagination.page.link}" => $getDataString."&page={$i}"
				);
					
				$paginationMergeContent .= strtr($GLOBALS["OBJ"]["pagination.linked.page"], $replaceArray);
			}
		}
			
		if (!is_null($paginationMergeContent)) $tpl -> AssignArray(array("pagination.pages" => $paginationMergeContent));
			
			
		/*
			If the last possible page isnt shown, we will
			show a link to it here
		*/
		if ($lastPage < $totalPages) {
			
			$tpl -> Zone("pagination.last", "linked");
			$tpl -> AssignArray(array(
				"pagination.last.link" => $getDataString."&page={$totalPages}",
				"pagination.last.pageNumber" => $totalPages
			));
		} else $tpl -> Zone("pagination.last", "disabled");
			
		/*
			
		*/
		if ($page < $totalPages) {
			$tpl -> Zone("pagination.next", "linked");
			$tpl -> AssignArray(array(
				"pagination.next.link" => $getDataString."&page=".($page+1),
			));
		} else $tpl -> Zone("pagination.next", "disabled");
	
	}
		
	else $tpl -> Zone("paginationBlock", "disabled");
		

	}
	
?>