<?php
// +----------------------------------------------------------------------
// | Wendasns [ 开源问答社区系统 ]
// +----------------------------------------------------------------------
// | Copyright (c) 2020~2021 http://wendasns.com All rights reserved.
// +----------------------------------------------------------------------
declare (strict_types = 1);

namespace app\wendasns\controller;

use app\wendasns\WenBaseController;
use app\wendasns\model\Question;
use app\wendasns\model\Article;
use app\wendasns\service\PwSeo;
use app\wendasns\model\Seo;
use app\wendasns\model\Sign;
use app\wendasns\model\Adpic;
use app\wendasns\model\Recommend;
use think\facade\View;

class Index extends WenBaseController
{
    public function index()
    {
		$limit = configure('page.pageQuestion', 10);
		$question = Question::where([
			['answer','=',0],
			['status','=','normal'],
			['remove','=',0],
		])->order('create_time', 'desc')->limit($limit)->select();

		$article = Article::where([
			['status','=','normal'],
			['remove','=',0],
		])->order('create_time', 'desc')->paginate(10);
		
		$sign = Sign::order('create_time','desc')->whereDay('create_time')->limit(20)->select();
		$issign = Sign::where('user_id',$this->loginUser->uid)->whereDay('create_time')->find();
		
		$adpic = Adpic::order('sort','desc')->select();
		$recommend = Recommend::where('article_id','>',0)->select();
		$hometop = $recommend->where('mode','top');
		$homerecommend = $recommend->where('mode','recommend')->order('sort', 'asc');
		
		$dm = Seo::where('type','index')->find();
		$seo = new PwSeo();
		$seo->title = $dm->title;
		$seo->description = $dm->description;
		$seo->keywords = $dm->keywords;
		$seo->set();

        $data = [
        	'question'=>$question,
        	'article'=>$article,
        	'sign'=>$sign,
        	'issign'=>$issign,
        	'adpic'=>$adpic,
        	'hometop'=>$hometop,
        	'homerecommend'=>$homerecommend
        ];
		View::assign($data);
		event('IndexPage');
		return View::fetch();
    }
    
    public function cs()
    {
    	
    	$img_name = root_path().'qr.png';
    	\wendasns\facade\Qrcode::png('https://www.wendasns.com/index.html',$img_name, 'H', 5);
    	
    	$QR = $img_name;
    	$logo = 'D:\phpstudy_pro\WWW\问答插件\knowpay\res\image/alipay.png';
    	
 $QR = imagecreatefromstring(file_get_contents($QR)); 
 $logo = imagecreatefromstring(file_get_contents($logo)); 
 $QR_width = imagesx($QR);//二维码图片宽度 
 $from_width = ($QR_width - 45) / 2; 
 //重新组合图片并调整大小 
 imagecopyresampled($QR, $logo, $from_width, $from_width, 0, 0, 45, 45, 45, 45);
                header('Content-Type: image/png');
        imagepng($QR);
        die;
    }
}