<?php
/**
* @package phpBB-WAP
* @copyright (c) phpBB Group
* @Оптимизация под WAP: Гутник Игорь ( чел ).
* @简体中文：中文phpBB-WAP团队
* @license http://opensource.org/licenses/gpl-license.php
**/

/**
* 这是一款自由软件, 您可以在 Free Software Foundation 发布的
* GNU General Public License 的条款下重新发布或修改; 您可以
* 选择目前 version 2 这个版本（亦可以选择任何更新的版本，由
* 你喜欢）作为新的牌照.
**/

define('IN_PHPBB', true);
	
$no_page_header = false;

define('ROOT_PATH', './../');

require('pagestart.php');

$mode = get_var('mode', '');

if ($mode == 'bbcode')
{
	redirect(append_sid('rules.php?mode=faq&act=bbcode', true));
}
else if ($mode == 'mbb')
{
	$template->set_filenames(array(
		'body' => 'admin/help_module_bbcode.tpl')
	);
	
	$template->assign_vars(array(
		'U_HELP' 	=> append_sid('help.php'))
	);
}
else if ($mode == 'version')
{
	$object = json_decode(file_get_contents('http://api.phpbb-wap.com/version.php'));
	
	$template->set_filenames(array(
		'body' => 'admin/help_version.tpl')
	);
	
	$template->assign_vars(array(
		'U_HELP' 	=> append_sid('help.php'))
	);

	// 有新版本
	if ($object->version > $board_config['version'])
	{
		$template->assign_block_vars('new_version', array(
			'U_DOWNLOAD'	=> $object->download_url)
		);
	}
	else
	{
		$template->assign_block_vars('not_new_version', array());
	}
}
else if ($mode == 'patch')
{
	// 程序管家
	// 版本：v1.0
	// 作者：爱疯的云
	// 官方：http://phpbb-wap.com
	

	// 安装说明：
	// 清空cache缓存
	// 插入数据到config表

	// 
	// 获得你的程序目前的版本号
	$version 	= $board_config['patch_version'];
	
	$view_patch = get_var('view', 0);

	// API地址
	$url = 'http://api.phpbb-wap.com/patch.php?version=' . $version;

	// 获取
	if (function_exists('curl_init'))
	{
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
		curl_setopt($ch, CURLOPT_URL, $url);
		$response = curl_exec($ch);
		curl_close($ch);
	}
	elseif (function_exists('file_get_contents') )
	{
		$response = file_get_contents($url);
	}
	else
	{
		trigger_error('对不起！您的服务器不支持 CURL 或 file_get_contents函数，遇到该问题请与您的服务器提供商联系！', E_USER_ERROR);
	}

	// 解码
	$patch_info = json_decode($response, true);

	if (isset($_GET['view']))
	{
		if (!isset($patch_info['list'][$view_patch]['title']))
		{
			trigger_error('无法获取补丁信息，您可以刷新页面试试！', E_USER_ERROR);
		}

		if (!isset($patch_info['list'][$view_patch]['desc']))
		{
			trigger_error('无法获取补丁信息，您可以刷新页面试试！', E_USER_ERROR);
		}

		if (!isset($patch_info['list'][$view_patch]['code']))
		{
			trigger_error('无法获取补丁信息，您可以刷新页面试试！', E_USER_ERROR);
		}		
		$code = str_replace("  ", "&nbsp; ", $patch_info['list'][$view_patch]['code']);
		$code = str_replace("  ", " &nbsp;", $code);
		$code = str_replace("\t", "&nbsp; &nbsp;", $code);

		$template->assign_vars(array(
			'U_PATCH'	=> append_sid('help.php?mode=patch'),
			'U_HELP' 	=> append_sid('help.php'),
			'TITLE' 	=> $patch_info['list'][$view_patch]['title'],
			'DESC' 		=> $patch_info['list'][$view_patch]['desc'],
			'CODE'		=> $code)
		);

		$template->set_filenames(array(
			'body' => 'admin/help_viewpatch.tpl')
		);

	}
	else
	{
		if (isset($patch_info['total']) && isset($patch_info['list']))
		{
			if ( isset($patch_info['total']) && $patch_info['total'] > 0 )
			{
				$template->assign_vars(array(
					'TOTAL_PATCH' => $patch_info['total'],
					'U_HELP' 	=> append_sid('help.php'))
				);
					
				if (is_array($patch_info['list']))
				{
					$i = 1;

					foreach ($patch_info['list'] as $list_key => $list_value)
					{
						if (is_array($list_value))
						{
							$row_class = ( !($i % 2) ) ? 'row1' : 'row2';

							$template->assign_block_vars('switch_list', array(
								'ROW_CLASS'		=> $row_class,
								'PATCH_VERSION' => $list_key,
								'PATCH_TITLE' 	=> $list_value['title'],
								'U_VIEW_PATCH'	=> append_sid('help.php?mode=patch&amp;view=' . $list_key),
								'PATCH_TIME' 	=> $list_value['time'])
							);	

							$i++;
						}
					}
				}
			}
			else
			{
				trigger_error('太棒了，你已经打上最新补丁！', E_USER_ERROR);
			}
		}
		else
		{
			trigger_error('无法获取补丁信息，您可以刷新页面试试！', E_USER_ERROR);
		}

		$template->set_filenames(array(
			'body' => 'admin/help_patch.tpl')
		);
	}
}
else
{
	$template->set_filenames(array(
		'body' => 'admin/help_body.tpl')
	);
	
	$template->assign_vars(array(
		'U_HELP_BBCODE' 	=> append_sid('help.php?mode=bbcode'),
		'U_HELP_MBB' 		=> append_sid('help.php?mode=mbb'),
		'U_HELP_VERSION' 	=> append_sid('help.php?mode=version'),
		'U_HELP_PATCH'		=> append_sid('help.php?mode=patch'))
	);
}

$template->pparse('body');

page_footer();
?>