<?php
/**
* @package phpBB-WAP
* @简体中文：中文phpBB-WAP团队
* @license http://opensource.org/licenses/gpl-license.php
**/

/**
* 这是一款自由软件, 您可以在 Free Software Foundation 发布的
* GNU General Public License 的条款下重新发布或修改; 您可以
* 选择目前 version 2 这个版本（亦可以选择任何更新的版本，由
* 你喜欢）作为新的牌照.
**/

if ( !defined('IN_PHPBB') ) exit;

/**
*	phpBB-WAP 模块BBcode类
*	作者：Crazy
*	这个类有点糟糕，不过这个类估计没人回去研究
*/

class Module_bbcode 
{
	var $bbcodes = array();
	var $text = '';
	var $total = array();
	var $_userdata = NULL;
	var $_config = NULL;
	
	function __construct()
	{
		global $userdata, $board_config;

		$this->_config 		= $board_config;
		$this->_userdata 	= $userdata;

		// 统计的 BBcode 默认是没有开启的
		// 如需要开启请把下面的 // 去掉
		//$this->total = array(
		//	'user' => get_db_stat('usercount'),
		//	'topic' => get_db_stat('topiccount'),
		//	'post' => get_db_stat('postcount'),
		//	'attach' => get_db_stat('attachcount')
		//);

		$this->bbcodes = array(
			// 统计的 BBcode 默认是没有开启的
			// 如需要开启请把下面的 // 去掉
			//'[统计会员]'	=> $this->total['user'],
			//'[统计主题]'	=> $this->total['topic'],
			//'[统计帖子]'	=> $this->total['topic'],
			//'[统计附件]'	=> $this->total['attach'],
			'[br]'			=> '<br />',
			'[n]'			=> '&nbsp;',
			'[LOGO]'		=> ROOT_PATH . 'images/' . $this->_config['site_logo'],
			'[当前时间]'	=> create_date('G:i', time(), $this->_config['board_timezone']),
			'[年]'			=> create_date('Y', time(), $this->_config['board_timezone']),
			'[月]'			=> create_date('n', time(), $this->_config['board_timezone']),
			'[日]'			=> create_date('j', time(), $this->_config['board_timezone']),
			'[时]'			=> create_date('G', time(), $this->_config['board_timezone']),
			'[分]'			=> create_date('i', time(), $this->_config['board_timezone']),
			'[秒]'			=> create_date('s', time(), $this->_config['board_timezone']),
			'[星期]'		=> $this->bbcode_week(),
			'[问候语]'		=> $this->bbcode_hello(),
			'[备案信息]'	=> $this->_config['beian_info'],
			'[用户名]'		=> $this->_userdata['username'],
			'[用户ID]'		=> $this->_userdata['user_id'],
			'[未读信息]'	=> $this->_userdata['user_unread_privmsg'],
			'[新信息]'		=> $this->_userdata['user_new_privmsg'],
			'[邮箱]'		=> $this->_userdata['user_email'],
			'[金币]'		=> $this->_userdata['user_points'],
			'[注册时间]'	=> create_date('Y-m-d H:i', time(), $this->_config['board_timezone']),
			'[上级页面]'	=> append_sid(ROOT_PATH . 'index.php?page=' . $this->page_ago)
		);
	}

	function parser_mbb($text)
	{
		$this->text = $text;
		$this->text = ' ' . $this->text;
		if ( !(strpos($this->text, '[') && strpos($this->text, ']')) ) return substr($this->text, 1);
		$this->bbcode_replace();
		return $this->text;
	}
	
	function bbcode_replace()
	{
		foreach ($this->bbcodes as $str_find_tag => $str_replace_tag ) $this->text = str_replace($str_find_tag, $str_replace_tag, $this->text);

		$this->text = preg_replace('#\[MOD=([0-9a-z\-_]{1,15})\]#is', append_sid(ROOT_PATH . 'loading.php?mod=$1'), $this->text);

		$this->text = preg_replace_callback('#\[我的地盘_(-1|[1-9][0-9]{0,7})\]#', 'Module_bbcode::bbcode_ucp_link', $this->text);
		$this->text = preg_replace_callback('#\[调用论坛_([1-9][0-9]{0,7}(\,[1-9][0-9]{0,7})*?)_([0|1])_([0|1])_([1|2])\]#', 'Module_bbcode::bbcode_use_forum', $this->text);
		$this->text = preg_replace_callback('#\[调用帖子_(0|[1-9][0-9]{0,7}(\,[1-9][0-9]{0,7})*?)_([0|1])_([1|2|3|4])_([1-7])_([1-9]|[1-2]\d|5[0])\]#', 'Module_bbcode::bbcode_use_topic', $this->text);
		$this->text = preg_replace_callback('#\[html\](.*?)\[/html\]#s', 'Module_bbcode::bbcode_html', $this->text);
	}

	static function bbcode_html($html) {
		return htmlspecialchars_decode($html[1], ENT_QUOTES);
	}

	static function bbcode_use_forum($forum) {
		if ($forum[3]) $sql = 'SELECT forum_id, forum_name  FROM ' . FORUMS_TABLE . ' WHERE forum_id IN (' . $forum[1] . ')';
		else $sql = 'SELECT cat_id, cat_title  FROM ' . CATEGORIES_TABLE . ' WHERE cat_id IN (' . $forum[1] . ')';
		if ( !($result = $this->_db->sql_query($sql)) ) trigger_error('无法查询 forums 表的信息', E_USER_WARNING);
		$module_text = '';
		$while_br = ($forum[4]) ? '<br />' : '';
		switch ($forum[5]) {
			case 1: while( $row = $this->_db->sql_fetchrow($result) ) { $module_text .= ($forum[3]) ? $row['forum_name'] . $while_br : $row['cat_title'] . $while_br; } break;
			case 2: while( $row = $this->_db->sql_fetchrow($result) ) { $forum_or_cat_id = ($forum[3]) ? $row['forum_id'] : $row['cat_id']; $forum_or_cat_name = ($forum[3]) ? $row['forum_name'] : $row['cat_title']; $module_text .= ($forum[3]) ? '<a href="' . append_sid(ROOT_PATH . 'viewforum.php?f=' . $forum_or_cat_id) . '">' . $forum_or_cat_name . '</a>' . $while_br : '<a href="' . append_sid(ROOT_PATH . 'index.php?c=' . $forum_or_cat_id) . '">' . $forum_or_cat_name . '</a>' . $while_br;} break;
			default: return $forum[0];
		}
		return $module_text;
	}

	static function bbcode_use_topic($topic)
	{
		global $db;
		
		$module_text = '';
		$while_br = ($topic[3]) ? '<br />' : '';
		$forum_sql = ($topic[1] == 0) ? '' : ' WHERE forum_id IN(' . $topic[1] . ') ';
		
		switch ($topic[5])
		{
			// 新帖
			case 1:
				$sql = 'SELECT topic_id, topic_title
					FROM ' . TOPICS_TABLE . '
					' . $forum_sql . '
					ORDER BY topic_id DESC
					LIMIT 0, ' . $topic[6];
				break;
			
			// 显示最近一个星期的热门帖子
			case 2:
				$sql = 'SELECT topic_id, topic_title 
					FROM ' . TOPICS_TABLE . '
					WHERE topic_time >= ' . (time() - 604800) . '
						' . $forum_sql . '
					ORDER BY topic_views DESC
					LIMIT 0, ' . $topic[6];
				break;
			
			// 随机数据
			case 3:
				$sql = 'SELECT topic_id, topic_title 
					FROM ' . TOPICS_TABLE . '
					' . $forum_sql . '
					WHERE topic_id >= (SELECT ROUND(RAND() * (SELECT MAX(topic_id) FROM ' . TOPICS_TABLE . ')))
					LIMIT 0, ' . $topic[6];
				break;
			
			// 按回复数量
			case 4:
				$sql = 'SELECT topic_id, topic_title 
					FROM ' . TOPICS_TABLE . '
					' . $forum_sql . '
					ORDER BY topic_replies DESC
					LIMIT 0 , ' . $topic[6];
				break;
			
			// 动态
			case 5:
				$forum_sql = ($topic[1] == 0) ? '' : ' AND t.forum_id IN(' . $topic[1] . ') ';
				
				$sql = 'SELECT t.topic_id, t.topic_title
					FROM ' . TOPICS_TABLE . ' AS t, ' . POSTS_TABLE . ' AS p
					WHERE p.post_id = t.topic_last_post_id
						' . $forum_sql . '
					ORDER BY p.post_id DESC 
					LIMIT 0, ' . $topic[6];
				break;

			// 精华帖子
			case 6:
				$sql = 'SELECT topic_id, topic_title
					FROM ' . TOPICS_TABLE . ' 
					WHERE topic_marrow = ' . POST_MARROW . '
					' . $forum_sql . '
					ORDER BY topic_id DESC
					LIMIT 0, ' . $topic[6];
				break;

			// 专题帖子
			case 7:
				$sql = 'SELECT topic_id, topic_title
					FROM ' . TOPICS_TABLE . '
					' . $forum_sql . '
						AND topic_class <> ' . TOPIC_UNCLASS . '
					ORDER BY topic_id DESC
					LIMIT 0, ' . $topic[6];
					break;
			
			default:
				return $topic[0];
		}
		
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, '无法查询 topics 表的信息', '', __LINE__, __FILE__, $sql);
		}
		
		switch ($topic[4])
		{
			// 只显示标题
			case 1:
				while( $row = $db->sql_fetchrow($result) )
				{
					$module_text .= $row['topic_title'] . $while_br;
				}
				break;
			
			// 显示超链接
			case 2:
				while( $row = $db->sql_fetchrow($result) )
				{
					$module_text .= '<a href="' . append_sid(ROOT_PATH . 'viewtopic.php?t=' . $row['topic_id']) . '">' . $row['topic_title'] . '</a>' . $while_br;
				}
				break;
			
			// 显示带标题号的帖子名称
			case 3:
				$i = 1;
				while( $row = $db->sql_fetchrow($result) )
				{
					$module_text .= $i . '、' . $row['topic_title'] . $while_br;
					$i++;
				}
				break;

			// 显示带标题号的帖子超链接
			case 4:
				$i = 1;
				while( $row = $db->sql_fetchrow($result) )
				{
					$module_text .= $i . '、<a href="' . append_sid(ROOT_PATH . 'viewtopic.php?t=' . $row['topic_id']) . '">' . $row['topic_title'] . '</a>' . $while_br;
					$i++;
				}
				break;
			// 虽然这是不会匹配到的...
			default:
				return $topic[0];
		}
		
		return $module_text;
	}

	static function bbcode_ucp_link($user_id) {
		if ($user_id[1] == -1) return append_sid(ROOT_PATH . 'index.php');
		else if ($user_id[1] == 0) return append_sid(ROOT_PATH . 'ucp.php?mode=viewprofile&amp;' . POST_USERS_URL . '=' . $this->_userdata['user_id']);
		else return append_sid(ROOT_PATH . 'ucp.php?mode=viewprofile&amp;' . POST_USERS_URL . '=' . $user_id[1]);
	}
	
	function bbcode_week() {
		$week_data = create_date('N', time(), $this->_config['board_timezone']);
		switch ($week_data) {
			case 1: return '一'; break;
			case 2: return '二'; break;
			case 3: return '三'; break;
			case 4: return '四'; break;
			case 5: return '五'; break;
			case 6: return '六'; break;
			case 7: return '日'; break;
			default: return'';
		}
		return $week_text;
	}
	
	function bbcode_hello() {
		$hello_time = create_date('H', time(), $this->_config['board_timezone']);
		if ( $hello_time < 5) $hello_text = '凌晨';
		elseif ( $hello_time < 9) $hello_text = '早上';
		elseif ( $hello_time < 14) $hello_text = '中午';
		elseif ( $hello_time < 18) $hello_text = '下午';
		else $hello_text = '晚上';
		return $hello_text;
	}
}

?>