<?php
/**
* @package phpBB-WAP
* @copyright (c) phpBB Group
* @Оптимизация под WAP: Гутник Игорь ( чел ).
* @简体中文：中文phpBB-WAP团队
* @license http://opensource.org/licenses/gpl-license.php
**/

/**
* 这是一款自由软件, 您可以在 Free Software Foundation 发布的
* GNU General Public License 的条款下重新发布或修改; 您可以
* 选择目前 version 2 这个版本（亦可以选择任何更新的版本，由
* 你喜欢）作为新的牌照.
**/

if ( !defined('IN_PHPBB') )
{
	die("Hacking attempt");
}

$inline_columns = 4;
$inline_rows = 5;
$window_columns = 8;

$per = $board_config['topics_per_page'];
$start = get_pagination_start($per);

$page_title = '表情图标';

page_header($page_title);

$template->set_filenames(array(
	'smiliesbody' => 'rules/faq_smilies.tpl')
);

$sql = "SELECT emoticon, code, smile_url   
	FROM " . SMILIES_TABLE . " 
	ORDER BY smilies_id
	LIMIT $start , $per";
if ($result = $db->sql_query($sql))
{
	$num_smilies = 0;
	$rowset = array();
	while ($row = $db->sql_fetchrow($result))
	{
		if (empty($rowset[$row['smile_url']]))
		{
			$rowset[$row['smile_url']]['code'] = str_replace("'", "\\'", str_replace('\\', '\\\\', $row['code']));
			$rowset[$row['smile_url']]['emoticon'] = $row['emoticon'];
			$num_smilies++;
		}
	}

	if ($num_smilies)
	{
		$smilies_count = ($mode == 'inline') ? min(19, $num_smilies) : $num_smilies;
		$smilies_split_row = ($mode == 'inline') ? $inline_columns - 1 : $window_columns - 1;

		$s_colspan = 0;
		$row = 0;
		$col = 0;
		$i = 0;
		
		foreach($rowset as $smile_url => $data)
		{
			if (!$col)
			{
				$template->assign_block_vars('smilies_row', array());
			}
			
			$row_class = ( !($i % 2) ) ? 'row1' : 'row2';
			
			$template->assign_block_vars('smilies_row.smilies_col', array(
				'ROW_CLASS'		=> $row_class,
				'SMILEY_CODE' => $data['code'],
				'SMILEY_IMG' => $board_config['smilies_path'] . '/' . $smile_url,
				'SMILEY_DESC' => $data['emoticon'])
			);

			$s_colspan = max($s_colspan, $col + 1);

			if ($col == $smilies_split_row)
			{
				if ($mode == 'inline' && $row == $inline_rows - 1)
				{
					break;
				}
				$col = 0;
				$row++;
			}
			else
			{
				$col++;
			}
			$i++;
		}

		$sql = "SELECT COUNT(smilies_id) as total FROM " . SMILIES_TABLE;
		if ( !($result = $db->sql_query($sql)))
		{
			trigger_error('Could not query private message information', E_USER_WARNING);
		}
		$smile_count = $db->sql_fetchrow($result);

		if ($smile_count['total'] > $board_config['topics_per_page'])
		{
			$pagination = generate_pagination('rules.php?mode=faq&amp;act=smiles', $smile_count['total'], $per, $start);
		}

		$template->assign_vars(array(
			'U_RULES' 				=> append_sid('rules.php'),
			'U_FAQ'					=> append_sid('rules.php?mode=faq'),
			'S_SMILIES_COLSPAN' 	=> $s_colspan,
			'PAGINATION' 			=> $pagination)
		);
	}
}
$template->pparse('smiliesbody');

page_footer();
?>