<?php
/**
* @package phpBB-WAP
* @copyright (c) phpBB Group
* @Оптимизация под WAP: Гутник Игорь ( чел ).
* @简体中文：中文phpBB-WAP团队
* @license http://opensource.org/licenses/gpl-license.php
**/

/**
* 这是一款自由软件, 您可以在 Free Software Foundation 发布的
* GNU General Public License 的条款下重新发布或修改; 您可以
* 选择目前 version 2 这个版本（亦可以选择任何更新的版本，由
* 你喜欢）作为新的牌照.
**/
define('IN_PHPBB_INSTALL', true);

require 'install_install.php';

if ( isset($_POST['install']) ){
	
	error_reporting  (E_ERROR | E_WARNING | E_PARSE);//保存运行时错误
	@set_magic_quotes_runtime(0);//魔术引号

	if (!get_magic_quotes_gpc()){
		if (is_array($_GET)){
			foreach($_GET as $k => $v){
				if (is_array($_GET[$k])){
					foreach($_GET[$k] as $k2 => $v2){
						$_GET[$k][$k2] = addslashes($v2);
					}
					@reset($_GET[$k]);
				}else{
					$_GET[$k] = addslashes($v);
				}
			}
			@reset($_GET);
		}

		if (is_array($_POST)){
			foreach($_POST as $k => $v){
				if (is_array($_POST[$k])){
					foreach($_POST[$k] as $k2 => $v2){
						$_POST[$k][$k2] = addslashes($v2);
					}
					@reset($_POST[$k]);
				}else{
					$_POST[$k] = addslashes($v);
				}
			}
			@reset($_POST);
		}

		if (is_array($_COOKIE)){
			foreach($_COOKIE as $k => $v){
				if (is_array($_COOKIE[$k])){
					foreach($_COOKIE[$k] as $k2 => $v2){
						$_COOKIE[$k][$k2] = addslashes($v2);
					}
					@reset($_COOKIE[$k]);
				}else{
					$_COOKIE[$k] = addslashes($v);
				}
			}
			@reset($_COOKIE);
		}
	}

	define('IN_PHPBB', true);
	define('ROOT_PATH', './../');
	
	$userdata 	= array();
	$error 		= false;

	$confirm = (isset($_POST['confirm'])) ? true : false;
	$cancel = (isset($_POST['cancel'])) ? true : false;

	if (isset($_POST['install_step']) || isset($_GET['install_step'])){
		$install_step = (isset($_POST['install_step'])) ? $_POST['install_step'] : $_GET['install_step'];
	}else{
		$install_step = '';
	}

	$upgrade = '';
	$upgrade_now = (!empty($_POST['upgrade_now'])) ? $_POST['upgrade_now'] : '';

	$dbms = isset($_POST['dbms']) ? $_POST['dbms'] : '';
	$dbhost = (!empty($_POST['dbhost'])) ? $_POST['dbhost'] : 'localhost';
	
	$dbuser = (!empty($_POST['dbuser'])) ? $_POST['dbuser'] : '';
	$dbpasswd = (!empty($_POST['dbpasswd'])) ? $_POST['dbpasswd'] : '';
	$dbname = (!empty($_POST['dbname'])) ? $_POST['dbname'] : '';

	$table_prefix = (!empty($_POST['prefix'])) ? $_POST['prefix'] : '';

	$admin_name = (!empty($_POST['admin_name'])) ? $_POST['admin_name'] : '';
	$admin_pass1 = (!empty($_POST['admin_pass1'])) ? $_POST['admin_pass1'] : '';
	$admin_pass2 = (!empty($_POST['admin_pass2'])) ? $_POST['admin_pass2'] : '';

	$ftp_path = (!empty($_POST['ftp_path'])) ? $_POST['ftp_path'] : '';
	$ftp_user = (!empty($_POST['ftp_user'])) ? $_POST['ftp_user'] : '';
	$ftp_pass = (!empty($_POST['ftp_pass'])) ? $_POST['ftp_pass'] : '';

	$board_email = (!empty($_POST['board_email'])) ? $_POST['board_email'] : '';
	$script_path = (!empty($_POST['script_path'])) ? $_POST['script_path'] : str_replace('install', '', dirname($_SERVER['PHP_SELF']));

	if (!empty($_POST['server_name'])){
		$server_name = $_POST['server_name'];
	}else{
		if (!empty($_SERVER['SERVER_NAME']) || !empty($_ENV['SERVER_NAME'])){
			$server_name = (!empty($_SERVER['SERVER_NAME'])) ? $_SERVER['SERVER_NAME'] : $_ENV['SERVER_NAME'];
		}else if (!empty($_SERVER['HTTP_HOST']) || !empty($_ENV['HTTP_HOST'])){
			$server_name = (!empty($_SERVER['HTTP_HOST'])) ? $_SERVER['HTTP_HOST'] : $_ENV['HTTP_HOST'];
		}else{
			$server_name = '';
		}
	}

	if (!empty($_POST['server_port'])){
		$server_port = $_POST['server_port'];
	}else{
		if (!empty($_SERVER['SERVER_PORT']) || !empty($_ENV['SERVER_PORT'])){
			$server_port = (!empty($_SERVER['SERVER_PORT'])) ? $_SERVER['SERVER_PORT'] : $_ENV['SERVER_PORT'];
		}else{
			$server_port = '80';
		}
	}

	if ($upgrade == 1){
		$install_step = 1;
	}

	if ((empty($install_step) || $admin_pass1 != $admin_pass2 || empty($admin_pass1) || empty($dbhost))){
		$instruction_text = '感谢您选择 phpBB-WAP 论坛系统，您必须填写下列资料以完成安装程序。在安装前，请先确定您所要使用的数据库已经建立';
		if (!empty($install_step)){
			if ( ($_POST['admin_pass1'] != $_POST['admin_pass2']) || (empty($_POST['admin_pass1']) || empty($dbhost)) ){
				$error .= '服务器地址、密码不正确或为空！';
			}
		}
		
		$s_hidden_fields = '<input type="hidden" name="install_step" value="1" />';
		$s_hidden_fields .= '<input type="hidden" name="install" value="install" />';
		phpbb_install_header($instruction_text);

		// 提示
		if ($error){
?>
			<div class="error">
				<span style="color:red">
					<?php echo $error; ?>
				</span>
			</div>

<?php	}
		phpbb_install_title('数据库信息');
		
		echo '<input type="hidden" name="dbms" value="mysql" />';
		
		$dbhost_right_value = ($dbhost != '') ? $dbhost : '';
		$dbhost_right = '<input type="text" name="dbhost" value="' . $dbhost_right_value . '"/>';
		phpbb_install_tbody('服务器地址', $dbhost_right);
		
		$dbname_right_value = ($dbname != '') ? $dbname : '';
		$dbname_right = '<input type="text" name="dbname" value="' . $dbname_right_value . '" />';
		phpbb_install_tbody('数据库名称', $dbname_right);
		
		$dbuser_right_value = ($dbuser != '') ? $dbuser : '';
		$dbuser_right = '<input type="text" name="dbuser" value="' . $dbuser_right_value . '" />';
		phpbb_install_tbody('用户名', $dbuser_right);

		$dbpasswd_right_value = ($dbpasswd != '') ? $dbpasswd : '';
		$dbpasswd_right = '<input type="password" name="dbpasswd" value="' . $dbpasswd_right_value . '" />';
		phpbb_install_tbody('密码', $dbpasswd_right);

		$prefix_right_value = (!empty($table_prefix)) ? $table_prefix : "phpbb_";
		$prefix_right = '<input type="text" name="prefix" value="' . $prefix_right_value . '" />';
		phpbb_install_tbody('表前缀', $prefix_right);
		
		phpbb_install_title('服务器信息');
		
		$board_email_right_value = ($board_email != '') ? $board_email : '';
		$board_email_right = '<input type="text" name="board_email" value="' . $board_email_right_value . '" />';
		phpbb_install_tbody('系统E-mail', $board_email_right);
		
		$server_name_right = '<input type="text" name="server_name" value="' . $server_name . '" />';
		phpbb_install_tbody('服务器名称', $server_name_right);	

		$server_port_right = '<input type="text" name="server_port" value="' . $server_port . '" />';
		phpbb_install_tbody('服务器端口', $server_port_right);	

		$script_path_right = '<input type="text" name="script_path" value="' . $script_path . '" />';
		phpbb_install_tbody('服务器端口', $script_path_right);		
		
		phpbb_install_title('管理员信息');
		
		$admin_name_right_value = ($admin_name != '') ? $admin_name : '';
		$admin_name_right = '<input type="text" name="admin_name" value="' . $admin_name_right_value . '" />';
		phpbb_install_tbody('用户名', $admin_name_right);

		$admin_pass1_right_value = ($admin_pass1 != '') ? $admin_pass1 : '';
		$admin_pass1_right = '<input type="password" name="admin_pass1" value="' . $admin_pass1_right_value . '" />';
		phpbb_install_tbody('密码', $admin_pass1_right);

		$admin_pass2_right_value = ($admin_pass2 != '') ? $admin_pass2 : '';
		$admin_pass2_right = '<input type="password" name="admin_pass2" value="' . $admin_pass2_right_value . '" />';
		phpbb_install_tbody('确认密码', $admin_pass2_right);
		
		phpbb_install_common_form($s_hidden_fields, '开始安装');
		
		phpbb_install_footer();
		exit;
	}else{
		if (isset($dbms)){
			if ( !extension_loaded('mysql') ){	
				phpbb_install_header('全新安装', '');
				phpbb_install_error('安装错误', '您的服务器不支持MySQL扩展！');
				phpbb_install_footer();
				exit;
			}
			require(ROOT_PATH . 'includes/constants.php');
			require(ROOT_PATH . 'includes/functions/common.php');
			require(ROOT_PATH . 'includes/class/session.php');
			require(ROOT_PATH.'includes/db.php');
		}

		$dbms_schema = 'schemas/mysql_schema.sql';
		$dbms_basic = 'schemas/mysql_basic.sql';
		$remove_remarks 	= 'remove_remarks';
		$delimiter 			= ';'; 
		$delimiter_basic 	= ';'; 

		if ($install_step == 1){
			if ($upgrade != 1){
				include(ROOT_PATH.'includes/functions/sql_parse.php');

				$sql_query = @fread(@fopen($dbms_schema, 'r'), @filesize($dbms_schema));
				$sql_query = preg_replace('/phpbb_/', $table_prefix, $sql_query);

				$sql_query = $remove_remarks($sql_query);
				$sql_query = split_sql_file($sql_query, $delimiter);

				$db->sql_query("ALTER DATABASE " . $dbname . " DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci");

				for ($i = 0; $i < count($sql_query); $i++){
				
					if (trim($sql_query[$i]) != ''){
						if (!($result = $db->sql_query($sql_query[$i]))){
							$error = $db->sql_error();
			
							phpbb_install_error_header('安装过程错误');
							phpbb_install_error('安装过程错误', '安装时数据出错<br />' . $error['message']);
							phpbb_install_footer();
							exit;
						}
					}
				}

				$sql_query = @fread(@fopen($dbms_basic, 'r'), @filesize($dbms_basic));
				$sql_query = preg_replace('/phpbb_/', $table_prefix, $sql_query);

				$sql_query = $remove_remarks($sql_query);
				$sql_query = split_sql_file($sql_query, $delimiter_basic);

				for($i = 0; $i < count($sql_query); $i++){
					if (trim($sql_query[$i]) != ''){
						if (!($result = $db->sql_query($sql_query[$i]))){
							$error = $db->sql_error();

							phpbb_install_error_header('安装过程错误');
							phpbb_install_error('安装过程错误', '安装时数据出错<br />' . $error['message']);
							phpbb_install_footer();
							exit;
						}
					}
				}

				$error = '';

				$sql = "INSERT INTO " . $table_prefix . "config (config_name, config_value) 
					VALUES ('board_startdate', " . time() . ")";
				if (!$db->sql_query($sql)){
					$error .= "Could not insert board_startdate :: " . $sql . " :: " . __LINE__ . " :: " . __FILE__ . "<br /><br />";
				}

				$update_config = array(
					'board_email'	=> $board_email,
					'script_path'	=> $script_path,
					'server_port'	=> $server_port,
					'server_name'	=> $server_name,
				);

				foreach($update_config as $config_name => $config_value){
					$sql = "UPDATE " . $table_prefix . "config 
						SET config_value = '$config_value' 
						WHERE config_name = '$config_name'";
					if (!$db->sql_query($sql)){
						$error .= "Could not insert default_lang :: " . $sql . " :: " . __LINE__ . " :: " . __FILE__ . "<br /><br />";
					}
				}

				$admin_pass_md5 = ($confirm && $userdata['user_level'] == ADMIN) ? $admin_pass1 : md5($admin_pass1);

				$sql = "UPDATE " . $table_prefix . "users 
					SET username = '" . str_replace("\'", "''", $admin_name) . "', user_password='" . str_replace("\'", "''", $admin_pass_md5) . "', user_email='" . str_replace("\'", "''", $board_email) . "'
					WHERE username = 'Admin'";
				if (!$db->sql_query($sql)){
					$error .= "Could not update admin info :: " . $sql . " :: " . __LINE__ . " :: " . __FILE__ . "<br /><br />";
				}

				$sql = "UPDATE " . $table_prefix . "users 
					SET user_regdate = " . time();
				if (!$db->sql_query($sql)){
					$error .= "Could not update user_regdate :: " . $sql . " :: " . __LINE__ . " :: " . __FILE__ . "<br /><br />";
				}

				if ($error != ''){
					phpbb_install_header('全新安装', '');
					phpbb_install_error('安装过程错误', '安装时数据出错<br /><br />' . $error);
					phpbb_install_footer();
					exit;
				}
			}

			if ( !$upgrade_now ){
				$config_data = '<?php'."\n\n";
				$config_data .= '$dbms = \'' . $dbms . '\';' . "\n";
				$config_data .= '$dbhost = \'' . $dbhost . '\';' . "\n";
				$config_data .= '$dbname = \'' . $dbname . '\';' . "\n";
				$config_data .= '$dbuser = \'' . $dbuser . '\';' . "\n";
				$config_data .= '$dbpasswd = \'' . $dbpasswd . '\';' . "\n";
				$config_data .= '$table_prefix = \'' . $table_prefix . '\';' . "\n";
				$config_data .= 'define(\'PHPBB_INSTALLED\', true);'."\n\n";	
				$config_data .= '?' . '>';

				@umask(0111);
				$no_open = FALSE;

				$fp = @fopen(ROOT_PATH . 'config.php', 'w');
				$result = @fputs($fp, $config_data, strlen($config_data));
				@fclose($fp);
				$upgrade_now = '继续升级';
			}

			$s_hidden_fields = '<input type="hidden" name="username" value="' . $admin_name . '" />';
			$s_hidden_fields .= '<input type="hidden" name="password" value="' . $admin_pass1 . '" />';
			$s_hidden_fields .= '<input type="hidden" name="redirect" value="" />';
			$s_hidden_fields .= '<input type="hidden" name="autologin" value="0" />';
			$s_hidden_fields .= '<input type="hidden" name="login" value="true" />';		
			
			phpbb_install_header('安装已完成！', '../login.php');
			phpbb_install_common_form($s_hidden_fields, '登录网站');
			phpbb_install_footer();
			exit;
		}
	}
}else if(isset($_POST['update'])) {
	if ( isset($_POST['updating']) ) {
		phpbb_update_check_config();
		error_reporting  (E_ERROR | E_WARNING | E_PARSE);
		define('IN_PHPBB', true);
		define('ROOT_PATH', './../');
		require(ROOT_PATH . 'config.php');
		require(ROOT_PATH . 'includes/constants.php');
		require(ROOT_PATH . 'includes/functions/common.php');
		require(ROOT_PATH . 'includes/functions/sessions.php');
		require(ROOT_PATH . 'includes/db.php');

		// 更新程序版本号
		$db->sql_query("UPDATE " . CONFIG_TABLE . " SET config_value = '5.1' WHERE config_name = 'version'");
		$db->sql_query("INSERT INTO phpbb_config (config_name, config_value) VALUES ('patch_version', '0')");
		
		// 升级完成
		phpbb_update_complete();
	}else{
		phpbb_update_wellcome();
	}
}else if(isset($_POST['licence'])) {
	phpbb_install_licence();
}else{
	phpbb_install_wellcome();
}
?>