<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice beta2 2013.12.30
 * @link        http://www.dzzoffice.com
 * @author      zyx(zyx@dzz.cc)
 */


if(!defined('IN_DZZ')) {
	exit('Access Denied');
}

class dzz_notification {


	public static function notification_add($touid, $type, $note, $notevars = array(), $category = 0) {
		global $_G;

		if(!($tospace = getuserbyuid($touid))) {
			return false;
		}
		
		$notestring = lang('notification', $note, $notevars);
		

		$oldnote = array();
		if($notevars['from_id'] && $notevars['from_idtype']) {
			$oldnote = C::t('notification')->fetch_by_fromid_uid_type($notevars['from_id'], $notevars['from_idtype'], $touid,$type);
		}
		if(empty($oldnote['from_num'])) $oldnote['from_num'] = 0;
		$notevars['from_num'] = $notevars['from_num'] ? $notevars['from_num'] : 1;
		$setarr = array(
			'uid' => $touid,
			'type' => $type,
			'new' => 1,
			'authorid' => $_G['uid'],
			'author' => $_G['username'],
			'note' => $notestring,
			'dateline' => $_G['timestamp'],
			'from_id' => $notevars['from_id'],
			'from_idtype' => $notevars['from_idtype'],
			'from_num' => ($oldnote['from_num']+$notevars['from_num']),
			'category'=>$category
		);
		if($category==1) {
			$setarr['authorid'] = 0;
			$setarr['author'] = '';
		}
		
		if($oldnote['id']) {
			C::t('notification')->update($oldnote['id'], $setarr);
		} else {
			$oldnote['new'] = 0;
			C::t('notification')->insert($setarr, true);
		}
		//$banType = array('task');
		if(empty($oldnote['new'])) {
			C::t('user')->increase($touid, array('newprompt' => 1));
			
			/*require_once libfile('function/mail');
			$mail_subject = lang('notification', 'mail_to_user');
			sendmail_touser($touid, $mail_subject, $notestring,  $type);*/
		}
	}


	

	public function update_newprompt($uid, $type) {
		global $_G;
		if($_G['member']['newprompt_num']) {
			$tmpprompt = $_G['member']['newprompt_num'];
			$num = 0;
			$updateprompt = 0;
			if(!empty($tmpprompt[$type])) {
				unset($tmpprompt[$type]);
				$updateprompt = true;
			}
			foreach($tmpprompt as $key => $val) {
				$num += $val;
			}
			if($num) {
				if($updateprompt) {
					C::t('user')->update($uid, array('newprompt'=>$num));
				}
			} else {
				C::t('user')->update($_G['uid'], array('newprompt'=>0));
			}
		}
	}
}

?>
