<?php
/*
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice beta2 2013.12.30
 * @link        http://www.dzzoffice.com
 * @author      zyx(zyx@dzz.cc)
 */

if(!defined('IN_DZZ')) {
	exit('Access Denied');
}

class table_attachment extends dzz_table
{
	public function __construct() {

		$this->_table = 'attachment';
		$this->_pk    = 'aid';
		$this->_pre_cache_key = 'attachment_';
		$this->_cache_ttl = 0;
		parent::__construct();
	}
	public function get_total_filesize() {
		$attachsize = 0;
		$attachsize = DB::result_first("SELECT SUM(filesize) FROM ".DB::table($this->table));
		return $attachsize;
	}
	public function addcopy_by_aid($aid){
		DB::query("update %t set copys=copys+1 where aid= %d",array($this->_table,$aid));
	}
	public function delete_by_aid($aid){ //删除附件
	  global $_G;
		if(!$data=$this->fetch($aid)){
			return false;	
		}
		if($data['copys']>1){
			return $this->update($aid,array('copys'=>$data['copys']-1));
		}else{
			if(io_remote::DeleteFromSpace($data)){
				return  $this->delete($aid);
			}else{
				return false;
			}
		}
		return true;
	}
	public function fetch_by_md5($md5){ //通过md5值返回一条数据
		return DB::fetch_first("SELECT * FROM %t WHERE md5 = %s ",array($this->table,$md5));
	}
	public function getSizeByRemote($remoteid){ //统计占用空间
		if($remoteid<2){
			return DB::result_first("SELECT  sum(filesize) FROM %t WHERE remote <2 and copys>0 ",array($this->table));
		}else{
			return DB::result_first("SELECT  sum(filesize) FROM %t WHERE remote = %d and copys>0 ",array($this->table,$remoteid));
		}
		
	}
	public function getAttachByFilter($filter,$sizecount=false){ //统计占用空间
	    $where='copys>0';
		if($filter['oremoteid']){
			if($filter['oremoteid']<2){
				$where.="  and remote<2";
			}else{
				$where.="  and remote= '{$filter[oremoteid]}'";
			}
		}
		if($filter['sizelt']){
			$where.=" and filesize>'{$filter[sizelt]}'";
		}
		if($filter['sizegt']){
			$where.=" and filesize<'{$filter[sizegt]}'";
		}
		if($filter['exts']){
			$extarr=explode(',',$filter['exts']);
			if($extarr){
				$where.=" and filetype IN (".dimplode($extarr).")";
			}
		}
		if($filter['ignore']){
			$ignores=explode(',',$filter['ignore']);
			if($ignores){
				$where.=" and aid NOT IN (".dimplode($ignores).")";
			}
		}
		
		if($sizecount)	return DB::result_first("SELECT  sum(filesize) FROM ".DB::table($this->_table)."  WHERE $where ");
		else  return DB::fetch_first("SELECT  * FROM ".DB::table($this->_table)." WHERE $where order by dateline");
		
	}
}

?>
