<?php
/*
 * 此应用的通知接口
 * @copyright   Leyun internet Technology(Shanghai)Co.,Ltd
 * @license     http://www.dzzoffice.com/licenses/license.txt
 * @package     DzzOffice
 * @version     DzzOffice beta2 2013.12.30
 * @link        http://www.dzzoffice.com
 * @author      zyx(zyx@dzz.cc)
 */
if(!defined('IN_DZZ')) {
	exit('Access Denied');
}
if(empty($_G['uid'])) {
	include template('common/header_reload');
	echo "<script type=\"text/javascript\">";
	echo "top._login.logging();";
	echo "win.Close();";
	echo "</script>";	
	include template('common/footer_reload');
	exit();
}
$do=trim($_GET['do']);

if(submitcheck('feedsubmit')){
	include libfile('function/code');
	$appid=intval($_GET['appid']);
	$message=$_GET['message'];
	if(empty($message)){
		showmessage('请输入分享内容',DZZSCRIPT.'?mod=feed',array());
	}
	//处理@
	$at_users=array();
	$message=preg_replace_callback("/@\[(.+?):(.+?)\]/i","atreplacement",$message);
	
	$thread=array(  'author'=>$_G['username'],
					'authorid'=>$_G['uid'],
					'subject'=>'',
					'readperm'=>intval($_GET['readperm']),
					'lastpost'=>TIMESTAMP,
					'lastposter'=>$_G['username'],
					'dateline'=>TIMESTAMP,
					'special'=>0,
					'attachment'=>0
					);
	
	if(!$tid=C::t('feed_thread')->insert($thread,1)){
		showmessage('服务器内部错误,请稍候再试，或联系管理员',DZZSCRIPT.'?mod=feed',array('message'=>$message));
	}
	$post=array('tid'=>$tid,
				'first'=>1,
				
				'author'=>$_G['username'],
				'authorid'=>$_G['uid'],
				'subject'=>'',
				'message'=>$message,
				'useip'=>$_G['clientip'],
				'dateline'=>TIMESTAMP,
				'attachment'=>0
				);
	if(!$post['pid']=C::t('feed_post')->insert($post,1)){
		C::t('feed_thread')->delete($post['tid']);
		showmessage('服务器内部错误,请稍候再试，或联系管理员',DZZSCRIPT.'?mod=feed',array('message'=>$message));
	}
	//处理@
	if($at_users){
		
		C::t('feed_at')->insert_by_pid($post['pid'],$post['tid'],($at_users));
		//发送通知
		foreach($at_users as $value){
			$notevars=array(
							'from_id'=>$appid,
							'from_idtype'=>'app',
							'url'=>DZZSCRIPT.'?mod=feed&feedType=atme',
							'author'=>$_G['username'],
							'authorid'=>$_G['uid'],
							'dataline'=>dgmdate(TIMESTAMP)
							
							);
			dzz_notification::notification_add($value['uid'], 'feed_at', 'feed_at', $notevars, 0);
		}
	}
	//处理附件
	if($_GET['aid']){
		foreach($_GET['aid'] as $key=>$aid){
			$attach=array('pid'=>$post['pid'],
						  'aid'=>$aid,
						  'tid'=>$post['tid'],
						  'title'=>$_GET['name'][$key],
						  'dateline'=>TIMESTAMP,
						  );
			if(C::t('feed_attach')->insert($attach)){
				C::t('attachment')->addcopy_by_aid($aid);
			}
		}
	}
	$post['attachs']=C::t('feed_attach')->fetch_all_by_pid($post['pid']);
	$post['dateline']=dgmdate($post['dateline'],'u');
	$post['readperm']=intval($_GET['readperm']);
	$post['message']=dzzcode($message);
	if($_G['adminid']==1 || $_G['uid']==$post['authorid']) $post['haveperm']=1;
	
	showmessage('do_success',DZZSCRIPT.'?mod=feed',array('data'=>rawurlencode(json_encode($post))));
}elseif(submitcheck('replysubmit')){	
	include libfile('function/code');
	$appid=intval($_GET['appid']);
	$message=$_GET['message'];
	if(empty($message)){
		showmessage('请输入分享内容',DZZSCRIPT.'?mod=feed',array());
	}
	$at_users=array();
	$message=preg_replace_callback("/@\[(.+?):(.+?)\]/i","atreplacement",$message);
	$tid=intval($_GET['tid']);
	$rpid=intval($_GET['pid']);
	
	$post=array('tid'=>$tid,
				'first'=>0,
				'author'=>$_G['username'],
				'authorid'=>$_G['uid'],
				'subject'=>'',
				'message'=>$message,
				'useip'=>$_G['clientip'],
				'dateline'=>TIMESTAMP,
				'attachment'=>0,
				'rpid'=>$rpid,
				
				);
	
	if(!$post['pid']=C::t('feed_post')->insert($post,1)){
		showmessage('内部错误',DZZSCRIPT.'?mod=feed',array());
	}
	
	//更新thread表
	DB::query("update  %t set lastpost=%d , lastposter=%s , replies=replies+1 where tid=%d",array('feed_thread',TIMESTAMP,$_G['username'],$tid));
	
	//更新reply事件表
	if($rpid){
		$rpost=C::t('feed_post')->fetch($rpid);
	}else{
		$rpost=DB::fetch_first("select * from %t where `first`>0 and tid=%d",array('feed_post',$tid));
	}
	
	if($rpost['authorid']!=$_G['uid']){
		$replyarr=array('uid'=>$_G['uid'],
						'pid'=>$post['pid'],
						'tid'=>$tid,
						'rpid'=>$rpost['pid'],
						'ruid'=>$rpost['authorid'],
						'dateline'=>$_G['timestamp']
					);
		DB::insert('feed_reply',$replyarr);
		//发送通知
		$notevars=array(
						'from_id'=>$appid,
						'from_idtype'=>'app',
						'url'=>DZZSCRIPT.'?mod=feed&feedType=replyme',
						'author'=>$_G['username'],
						'authorid'=>$_G['authorid'],
						'dataline'=>dgmdate(TIMESTAMP)
						
						);
		dzz_notification::notification_add($rpost['authorid'], 'feed_reply', 'feed_reply', $notevars, 0);
		
	}
	//处理@
	if($at_users){
		C::t('feed_at')->insert_by_pid($post['pid'],$post['tid'],($at_users));
		//发送通知
		foreach($at_users as $value){
			$notevars=array(
							'from_id'=>$appid,
							'from_idtype'=>'app',
							'url'=>DZZSCRIPT.'?mod=feed',
							'author'=>$_G['username'],
							'authorid'=>$_G['uid'],
							'dataline'=>dgmdate(TIMESTAMP)
							
							);
			dzz_notification::notification_add($value['uid'], 'feed_at', 'feed_at', $notevars, 0);
		}
	}
	//处理附件
	foreach($_GET['aid'] as $key=>$aid){
		$attach=array('pid'=>$post['pid'],
					  'aid'=>$aid,
					  'tid'=>$post['tid'],
					  'title'=>$_GET['name'][$key],
					  'dateline'=>TIMESTAMP,
					  );
		if(C::t('feed_attach')->insert($attach)){
			C::t('attachment')->addcopy_by_aid($aid);
		}
	}
	$post['attachs']=C::t('feed_attach')->fetch_all_by_pid($post['pid']);
	$post['dateline']=dgmdate($post['dateline'],'u');
	$post['message']=dzzcode($message);
	if($rpid) $post['rpost']=$rpost;
	if($_G['adminid']==1 || $_G['uid']==$post['authorid']) $post['haveperm']=1;
	
	showmessage('do_success',DZZSCRIPT.'?mod=feed',array('data'=>rawurlencode(json_encode($post))));

}elseif($do=='getThread'){
	include libfile('function/code');
	$tid=intval($_GET['tid']);
	$value=DB::fetch_first("select t.*,p.message,p.useip,p.pid from ".DB::table('feed_thread')." t LEFT JOIN ".DB::table('feed_post')." p on p.tid=t.tid and p.`first`>0 where tid='{$tid}'");
	$value['message']=dzzcode($value['message']);
	$value['attachs']=C::t('feed_attach')->fetch_all_by_pid($value['pid']);
	$value['dateline']=dgmdate($value['dateline'],'u');

}elseif($do=='getNewThreads'){
	include libfile('function/code');
	$orderby=' order by t.lastpost DESC';
	$lasttime=intval($_GET['t']);
	$sql="p.`first`>0 and t.lastpost>$lasttime";
	
			$wherearr=array();
			//@我的
			if($at_tids=C::t('feed_at')->fetch_all_tids_by_uid($_G['uid'])){
			   $wherearr[]="t.tid IN (".dimplode($at_tids).")";
			}
			//我收藏的
			if($at_tids=C::t('feed_collection')->fetch_all_tids_by_uid($_G['uid'])){
			   $wherearr[]="t.tid IN (".dimplode($at_tids).")";
			}
			//我发表的
			$wherearr[]="t.authorid = '{$_G[uid]}'";
			//回复我的
			$wherearr[]="(t.authorid = '{$_G[uid]}' and t.replies>0)";
			$sql.=" and (".implode(' or ',$wherearr).")";
			
	
	
	
	$threads=DB::fetch_all("select t.*,p.message,p.useip,p.pid from ".DB::table('feed_thread')." t LEFT JOIN ".DB::table('feed_post')." p on p.tid=t.tid  where $sql $orderby");
	$list=array();
	foreach($threads as $value){
		$value['iscollect']=DB::result_first("select COUNT(*) from %t where uid=%d and tid=%d",array('feed_collection',$_G['uid'],$value['tid']));
		$value['message']=dzzcode($value['message']);
		if($_G['adminid']==1 || $_G['uid']==$value['authorid']) $value['haveperm']=1;
		$value['attachs']=C::t('feed_attach')->fetch_all_by_pid($value['pid']);
		
		$value['dateline']=dgmdate($value['dateline'],'u');
		$list[]=$value;
	}
	
	//echo json_encode(array('timestamp'=>$_G['timestamp'],'list'=>$list));
	//exit();
	
}elseif($do=='getReply'){
	
}elseif($do=='getReplys'){
	include libfile('function/code');
	$tid=intval($_GET['tid']);
	$limit=intval($_GET['limit']);
	if($limit) $limit=" limit $limit";
	else $limit='';
	$orderby=' order by dateline DESC';
	$sql="tid='{$tid}' and `first`<1";
	$thread=C::t('feed_thread')->fetch($tid);
	$count=DB::result_first("select COUNT(*) from ".DB::table('feed_post')." where $sql ");
	$replys=DB::fetch_all("select * from ".DB::table('feed_post')." where  $sql $orderby $limit");
	
	$list=array();
	foreach($replys as $value){
		$value['readperm']=$thread['readperm'];
		$value['message']=dzzcode($value['message']);
		if($value['rpid']) $value['rpost']=C::t('feed_post')->fetch($value['rpid']);
		if($_G['adminid']==1 || $_G['uid']==$value['authorid']) $value['haveperm']=1;
		$value['attachs']=C::t('feed_attach')->fetch_all_by_pid($value['pid']);
		
		$value['dateline']=dgmdate($value['dateline'],'u');
		$list[$value['pid']]=$value;
	}
	$list=array_reverse($list);
}elseif($do=='delete'){
	$pid=intval($_GET['pid']);
	
	$post=C::t('feed_post')->fetch($pid);
	if($_G['adminid']!=1 && $_G['uid']==$value['authorid']) exit(json_encode(array('msg'=>'no_privilege')));
	if($post['first']>0){
		C::t('feed_thread')->delete_by_tid($post['tid']);
	}else{
		C::t('feed_post')->delete_by_pid($post['pid']);
		 //更新回复数
		 C::t('feed_thread')->update_replies_by_tid($post['tid'],-1);
	}
	
	exit(json_encode(array('msg'=>'success')));
}elseif($do=='collect'){
	$tid=intval($_GET['tid']);
	if($tid){
		if(DB::result_first("select COUNT(*) from %t where uid=%d and tid=%d",array('feed_collection',$_G['uid'],$tid))){
			if(C::t('feed_collection')->delete_by_tid_uid($tid,$_G['uid'])) $msg='success';
		}else{
			if(C::t('feed_collection')->insert_by_tid_uid($tid,$_G['uid'])) $msg='success';
		}
	}
	if(!$msg) $msg='error';
	echo json_encode(array('msg'=>$msg));
	exit();
}elseif($do=='top'){
	$tid=intval($_GET['tid']);
	if($thread=C::t('feed_thread')->fetch($tid)){
		if(C::t('feed_thread')->update($thread['tid'],array('top'=>!$thread['top']))) $msg='success';
	}
	if(!$msg) $msg='error';
	echo json_encode(array('msg'=>$msg));
	exit();
	
}elseif($do=='upload'){
	require DZZ_ROOT.'./dzz/feed/upload/UploadHandler.php';
	
	$options=array(
					'upload_dir' =>$_G['setting']['attachdir'].'cache/',
					'upload_url' => $_G['setting']['attachurl'].'cache/',
					);
	$upload_handler = new UploadHandler($options);

	exit();
}elseif($do=='uploadfromdesktop'){
	$icoid=intval($_GET['icoid']);
	
}elseif($do=='getReplyForm'){
	$tid=intval($_GET['tid']);
	include libfile('function/organization');					
	$orgtree=getDepartmentOption(0);

}elseif($do=='getUserToJson'){
  $users=array();
  include dzz_libfile('class/pinyin');
  $py = new PinYin();
	
  foreach(DB::fetch_all(" select uid ,username ,email from ".DB::table('user')." where 1") as $value){
	 if($value['uid']!=$_G['uid']){
		  $value['searchkey']= $py->getAllPY($value['username']).$value['username'].$value['email'];
		  $users[]=$value; 
	 }
  }
  echo json_encode($users);
  exit();
}
function atreplacement($matches){
	global $at_users,$_G;
	if(!$_G['cache']['organization']){
		loadcache('organization');
	}
	if(strpos($matches[2],'gid_')!==false){
		$gid=str_replace('gid_','',$matches[2]);
		if(isset($_G['cache']['organization'][$gid])) $users=$_G['cache']['organization'][$gid]['users'];
		foreach($users as $value){
			if($value['uid']!=$_G['uid']) $at_users[]=$value['uid'];
		}
		return '[org='.$gid.'] @'.$matches[1].'[/org]';
	}else {
		if(($user=C::t('user')->fetch_by_email($matches[2])) && $user['uid']!=$_G['uid']){
			$at_users[]=$user['uid'];
			return '[uid='.$user['uid'].']@'.$user['username'].'[/uid]';
		}else{
			return $matches[0];
		}
	}
}
include template('ajax');
?>
