<?php
namespace Common\Lib\alidayu;
/**
 * 阿里大鱼短信类
	用法：
		Yii::import('application.extensions.alidayu.Alidayu');
		$config = array(
			'appkey'=>'',
			'secretKey'=>'',
			'signature'=>''     //签名
		);
		$alidayu = new Alidayu($config);
		$data = array(
			'recNum'=>$mobile,  //手机号，多个用英文逗号隔开，最多200个
			'params'=>$params,	//短信内容参数数组  array(
								//						'code'=>'1234',
								//						'product'=>'阿里大鱼'
								//					)
			'templateCode'=>$templateCode    //短信模板编号
		);
		$result = $alidayu->send($data);
 */
include "TopSdk.php";
require_once dirname(__FILE__) . '/top/TopClient.php';
require_once dirname(__FILE__) . '/top/request/AlibabaAliqinFcSmsNumSendRequest.php';
require_once dirname(__FILE__) . '/top/ResultSet.php';
require_once dirname(__FILE__) . '/top/RequestCheckUtil.php';
require_once dirname(__FILE__) . '/top/TopLogger.php';
use Common\Lib\alidayu\top\TopClient;
use Common\Lib\alidayu\top\request\AlibabaAliqinFcSmsNumSendRequest;
use Common\Lib\alidayu\top\ResultSet;
use Common\Lib\alidayu\top\RequestCheckUtil;
use Common\Lib\alidayu\top\TopLogger;
class Alidayu{
	private $appkey;
	private $secretKey;
	private $signature;
	private $extend = '';
	private $smsType = 'normal';
	private $client;

	public function __construct($config){
		$this->appkey = $config['appkey'];
		$this->secretKey = $config['secretKey'];
		$this->signature = $config['signature'];
		$this->client = $this->setClient();
	}
	private function setClient(){
		$c = new TopClient;
		$c->appkey = $this->appkey;
		$c->secretKey = $this->secretKey;
		return $c;
	}
	public function send($data){
		$req = new AlibabaAliqinFcSmsNumSendRequest;
		$req->setExtend($this->extend);
		$req->setSmsType($this->smsType);
		$req->setSmsFreeSignName($this->signature);
		$req->setSmsParam(json_encode($data['params']));
		$req->setRecNum($data['recNum']);
		$req->setSmsTemplateCode($data['templateCode']);
		$resp = $this->client->execute($req);
		if($resp->result->err_code=='0'){
			if($resp->result->success=="true"){
				$return['status']=1;
				$return['content']='发送成功';
				return $return;
			}else{
				$return['status']=0;
				$return['content']='ERRS:'.addslashes($resp->result->msg);
				return $return;
			}
		}else{
			$return['status']=0;
			$return['content']='ERR:'.addslashes($resp->sub_msg);
			return $return;
		}
	}
}
?>