<?php 
namespace Common\Model;
use Think\Model;
class AnswerModel extends Model
{
 
 	//获取列表
	public function get_list($map='',$page=false,$sort='',$num='')
	{
		$limit=$num?$num:10;
		if (empty($sort))
		{
		$sort='id DESC';
		}
		if ($page)
		{
		$count      = $this->where($map)->count();
		$Page		= pager($count,$limit);
		$limit      = $Page->firstRow.','.$Page->listRows;
		$page_str   = $Page->fshow();
		}
		$result = $this->where($map)->order($sort)->limit($limit)->select();
		foreach ($result as $key => $v){
				 
				$v['question']=D('Question')->get_question_one($v['qid']);
				$v['content_str']=$v['content'];
				$v['content_cut']=cut_str($v['content'],100);
				$v['content']=uu_strip_tags($v['content']);
				$v['user']    =D('User')->get_user_one($v['uid'],true,1);
				$v['addtime_str']    =daterange($v['addtime']);
				$v['asked']=D('AnswerReply')->get_answer_reply($v['id']);
				$list[]=$v;
			}		
		$return['list']=$list;
		if ($page){
		$return['count']=$count;
		}else{
		$return['count']=count($list);
		}
		$return['page']=$page_str;
		//print_r($return);
		return $return;
	}
	public function get_answer_one($qid='',$uid='')
	{
		if (!empty($qid)){
		$map['qid']=intval($qid);
		}
		if (!empty($uid)){
		$map['uid']=intval($uid);
		}
		$list=$this->where($map)->find();
		if (!empty($list)){
		$list['addtime_str']=daterange($list['addtime']);
		}
		return $list;
	}
	public function get_answer_one_id($id='')
	{
		$map['id']=intval($id);
		$list=$this->where($map)->find();
		return $list;
	}
	//更新点赞
	public function inc_praise($rid='')
	{
		$map['id']=intval($rid);
		$this->where($map)->setInc('praise',1);
		return true;
	}
	//获取点赞数量
	public function get_praise($rid='')
	{
		$map['id']=intval($rid);
		$praise=$this->field('praise')->where($map)->find();
		return $praise['praise'];
	}
	
	//获浏览总数（帮助过的人）
	public function get_click_total($uid='')
	{
		$map['uid']=intval($uid);
		$click=$this->where($map)->sum('click');
		$click=$click?$click:0;
		return $click;
	}
	//设为最佳答案
	public function set_optimal($rid='')
	{
		$map['id']=intval($rid);
		$map['optimal']=1;
		$this->save($map);
		return true;
	}
	//统计回答数量（全部/已采纳）
	public function count_answer($uid='',$optimal='',$qid='')
	{
		if (!empty($uid)){
		$map['uid']=intval($uid);
		}
		if (!empty($qid)){
		$map['qid']=intval($qid);
		}
		if (!empty($optimal)){
		$map['optimal']=intval($optimal);
		}
		$count=$this->where($map)->count();
		return $count;
	}
	//计算采纳率（已采纳/回答总数）
	public function acc_rate($uid='')
	{
		$map['uid']=intval($uid);
		$count=$this->where($map)->count();
		$map['optimal']=1;
		$count1=$this->where($map)->count();
		$rate=round(($count1/$count)*100);
		return $rate;
	}
	//修改点击次数
	public function edit_click($id='')
	{
		$map['qid']=intval($id);
		$this->where($map)->setInc('click',1);
		return true;
	} 
}
?>