<?php 
namespace Common\Model;
use Think\Model;
class ArticleModel extends Model
{
	protected $_validate = array(
		array('title','require','标题必须填写！',1),
		array('content','require','内容必须填写！',1),
		array('category1','require','请正确选择分类！',1),
		array('category2','number','请正确选择分类！',2),
	);
	protected $_auto = array (
		array('click','1'),
		array('audit','0'),
		array('addtime','time',1,'function'),
	);
	//获取列表
	public function get_list($map='',$page=false,$sort='',$num='',$showuser=false)
	{
		$limit=$num?$num:10;
		if ($page)
		{
			if (empty($map['tagid']))
			{
			$count      = $this->where($map)->count();
			}
			else
			{
			$maptag['tagid']=$map['tagid'];
			$count      = M('ArticleTag')->where($maptag)->count();
			}
			if ($count==0)
			{
				return '';
			}
			$Page		= pager($count,$limit);
			$limit      = $Page->firstRow.','.$Page->listRows;
			$page_str   = $Page->fshow();
		}
		if(!empty($maptag['tagid']))
		{
			$tags= D('ArticleTag')->get_tag_tagid($maptag['tagid'],$limit);	
				foreach ($tags as $v){
				$ids[]=$v['aid'];
				}
				unset($map);
				$ids = is_array($ids)?implode(",",$ids):$ids;
				$map['id']=array('IN',$ids);
				$result=$this->where($map)->order('id desc')->select();
		
		}
		else
		{
		$result = $this->where($map)->order($sort)->limit($limit)->select();
		}
		foreach ($result as $key => $v){
				$v['isimg']=$v['img'];
				$v['img']=$this->get_article_img($v['img'],$v['id']);
				$v['url']=$this->view_url($v['id']);
				$v['audit_str']=$this->get_audit($v['audit']);
				$v['addtime_str']=daterange($v['addtime']);
				if ($v['category2'])
				{
				$v['cat'] =D('Category')->get_one_id($v['category2']);
				}
				else
				{
				$v['cat'] =D('Category')->get_one_id($v['category1']);
				}
				$v['content']=htmlspecialchars_decode($v['content'],ENT_QUOTES);
				$v['content_cut']=cut_str(strip_tags($v['content']),110);
				$v['tags'] =D('ArticleTag')->get_tag_qid($v['id']);
				if ($showuser)
				{
				$v['user']=D('User')->get_user_one($v['uid'],true,1);
				}
				$list[]=$v;
			}
		$return['list']=$list;
		if ($page){
		$return['count']=$count;
		}else{
		$return['count']=count($list);
		}
		$return['page']=$page_str;
		//print_r($return);
		return $return;
	}
	//获取一条文章
	public function get_one_id($id='')
	{
		$map['id']  =intval($id);
		$info=$this->where($map)->find();
		if (!empty($info))
		{
		$info['addtime_str']=daterange($info['addtime']);
		$info['content']=htmlspecialchars_decode($info['content'],ENT_QUOTES);
		$info['content_cut']=cut_str(strip_tags($v['content']),30);
		$info['user']=D('User')->get_user_one($info['uid'],true,1);
		$info['tags'] =D('ArticleTag')->get_tag_qid($info['id']);
			if ($info['category2'])
			{
			$info['cat'] =D('Category')->get_one_id($info['category2']);
			}
			else
			{
			$info['cat'] =D('Category')->get_one_id($info['category1']);
			}
		}
		return $info;
	}
	//获取封面
	public function get_article_img($img='',$id='')
	{
		if (empty($img))
		{
		$img=__ROOT__.'/'.C('UU_IMG_ARTICLE_DIR').substr($id,-1).'.jpg';
		}
		else
		{
		$img=__ROOT__.'/'.C('UU_IMG_ARTICLE_DIR').$img;
		}
		return $img;
	}
	//获取问题总数
	public function count_article($uid)
	{
		$map['uid']= intval($uid);
		$map['audit']= array('EGT',0);
		return $this->where($map)->count();
	}
	//获取审核状态
	public function get_audit($audit='0')
	{
		switch ($audit)
		{
					case '0':
					  $audit_str  = '<span style="color:#FF0000">未审核</span>'; 
					  break;  
					case '1':
					  $audit_str  ='<span style="color:#009900">已审核</span>';
					  break;
					case '-1':
					  $audit_str  = '<span style="color:#999999">未通过</span>'; 
					  break;
		}
		return $audit_str;
	}
	public function del_article($ids,$uid='')
	{
		if ($ids && preg_match("/^(\d{1,10},)*(\d{1,10})$/",$ids))
		{
		$wmap['id'] = array('IN',$ids);
		if($uid<>'')
		{
		$wmap['uid'] = intval($uid);
		}
		$this->where($wmap)->delete();
 		$map['aid'] = array('IN',$ids);
		M('ArticleTag')->where($map)->delete();
		return true;
		}
	}
	//更新点赞
	public function inc_praise($id='')
	{
		$map['id']=intval($id);
		$this->where($map)->setInc('praise',1);
		return true;
	}
	//获取点赞数量
	public function get_praise($id='')
	{
		$map['id']=intval($id);
		$praise=$this->field('praise')->where($map)->find();
		return $praise['praise'];
	}
	//获取详细页URL
	public function view_url($id)
	{
		return RU('article/view',array('id'=>$id));
	}
}
?>