<?php 
namespace Common\Model;
use Think\Model;
class NoticeModel extends Model
{
	protected $_validate = array(
		array('title','require','公告标题必须填写！',1),
	);
 

	protected $_auto = array (
		array('addtime','time',1,'function'),
	);
	//获取列表
	public function get_list($map,$page=false,$sort='',$num='',$cut='',$showuser=false)
	{
		$limit=$num?$num:10;
		$cut=empty($cut)?100:intval($cut);
		if (empty($sort))
		{
		$sort='sort DESC,id DESC';
		}
		if ($page)
		{
		$count      = $this->where($map)->count();
		$Page		= pager($count,$limit);
		$limit      = $Page->firstRow.','.$Page->listRows;
		$page_str   = $Page->fshow();
		}
		$result = $this->order($sort)->limit($limit)->select();
		foreach ($result as $key => $v){
				 $v['addtime_str']=daterange($v['addtime']);
				$v['content']=htmlspecialchars_decode($v['content'],ENT_QUOTES);
				$v['content_cut']=cut_str(strip_tags($v['content']),$cut);
				$v['url']=RU('notice/view',array('id'=>$v['id']));
				if ($showuser)
				{
				$v['user']=D('User')->get_user_one($v['uid'],true,1);
				}
				$list[]=$v;
			}
		$return['list']=$list;
		if ($page){
		$return['count']=$count;
		}else{
		$return['count']=count($list);
		}
		$return['page']=$page_str;
		//print_r($return);
		return $return;
	}
	//
	public function get_notice_one($id='')
	{
		if (!empty($id))
		{
		$map['id']  =intval($id);
		}
		$info=$this->where($map)->find();
		$info['content']=htmlspecialchars_decode($info['content'],ENT_QUOTES);
		$info['addtime_str']=daterange($info['addtime']);
		$info['user']=D('User')->get_user_one($info['uid'],true,1);
		return $info;
	}
	//更新点击数量
	public function inc_click($id='')
	{
		$map['id']=intval($id);
		$this->where($map)->setInc('click',1);
		return true;
	}
	 
}
?>