<?php 
namespace Common\Model;
use Think\Model;
class QuestionModel extends Model
{
	protected $_validate = array(
		array('title','require','问题标题必须填写！',1),
		array('category1','require','请正确选择分类！',1),
		array('category2','number','请正确选择分类！',2),
		array('reward','number','悬赏参数错误！',2),
		array('sms_remind',array(0,1),'值的范围不正确！',2,'in'),
		array('anonymous',array(0,1),'值的范围不正确！',2,'in'),
	);
	protected $_auto = array (
		array('issolve','0'),
		array('click','1'),
		array('audit','0'),
		array('addtime','time',1,'function'),
	);
	//获取列表
	public function get_list($map='',$page=false,$sort='',$num='')
	{
		$limit=$num?$num:10;
		if (empty($sort))
		{
			$sort="id DESC";
		}
		if ($page)
		{
		$count      = $this->where($map)->count();
		$Page		= pager($count,$limit);
		$limit      = $Page->firstRow.','.$Page->listRows;
		$page_str   = $Page->fshow();
		}
		$result = $this->where($map)->order($sort)->limit($limit)->select();
		foreach ($result as $key => $v){
				$v['url']=$this->view_url($v['id']);
				$v['addtime_str']=daterange($v['addtime']);
				$v['audit_str']=$this->get_audit($v['audit']);
				$v['user']=D('User')->get_user_one($v['uid'],true,1);
				$v['tag'] =D('QuestionTag')->get_tag_qid($v['id']);
				$v['img'] =D('QuestionImg')->get_img_qid($v['id']);
				$v['cat'] =D('Category')->get_one_id($v['category1']);
				$list[]=$v;
			}
		$return['list']=$list;
		$return['page']=$page_str;
		//print_r($return);
		return $return;
	}
	//获取问题
	public function get_question_one($id='',$uid='')
	{
		$map['id']  =intval($id);
		if (!empty($uid)){
		$map['uid']  =intval($uid);
		}
		$info=$this->where($map)->find();
		$info['url']=$this->view_url($info['id']);
		return $info;
	}
	//修改问题回答总数
	public function edit_answercount($id='')
	{
		$id= is_array($id)?$id:array($id);
		foreach($id as $v)
		{
			 
			$map['id']=intval($v);
			$map['answercount']=D('Answer')->count_answer('','',$v);
			$this->save($map);
 
		}
		return true;
	}
	//修改点击次数
	public function edit_click($id='')
	{
		$map['id']=intval($id);
		$this->where($map)->setInc('click',1);
		return true;
	}
	//修改悬赏数量
	public function edit_reward($id='',$gold='')
	{
		$map['id']=intval($id);
		$this->where($map)->setInc('reward',$gold);
		return true;
	}
	//修改问题回答用户
	public function edit_answeruid($id='',$uid='')
	{
		$map['id']=intval($id);
	 	$map['answeruid']=intval($uid);
		$map['answertime']=time();
		$this->save($map);
		return true;
	}
	//把问题设为已解决
	public function set_solve($id='')
	{
		$map['id']=intval($id);
		$map['issolve']=1;
		$this->save($map);
		return true;
	}
	//获取审核状态
	public function get_audit($audit='0')
	{
		switch ($audit)
		{
					case '0':
					  $audit_str  = '<span style="color:#FF0000">未审核</span>'; 
					  break;  
					case '1':
					  $audit_str  ='<span style="color:#009900">已审核</span>';
					  break;
					case '-1':
					  $audit_str  = '<span style="color:#999999">未通过</span>'; 
					  break;
		}
		return $audit_str;
	}
	//获取问题总数
	public function count_question($uid)
	{
		$map['uid']= intval($uid);
		$map['audit']= array('EGT',0);
		return $this->where($map)->count();
	}
	//删除问题
	public function del_question($ids,$uid='')
	{
		if ($ids && preg_match("/^(\d{1,10},)*(\d{1,10})$/",$ids))
		{
		$where['id']= array('IN',"{$ids}");
		if ($uid<>'')
		{
		$where['uid']= intval($uid);
		}
		$this->where($where)->delete();
 		$map['qid'] = array('IN',"{$ids}");
		M('QuestionTag')->where($map)->delete();
		M('QuestionSupp')->where($map)->delete();
		M('QuestionImg')->where($map)->delete();
		return true;
		}
	}
	//获取详细页的URL
	public function view_url($id)
	{
		return RU('question/view',array('id'=>$id));
	}
}
?>