<?php 
namespace Common\Model;
use Think\Model;
class TagModel extends Model
{
	protected $_validate = array(
		array('tag','require','标签必须填写！',1),
	);
 
	protected $_auto = array (
		array('addtime','time',1,'function'),
	);
	//获取列表
	public function get_list($map='',$page=false,$sort='',$num='',$showcat=false)
	{
		$limit=$num?$num:10;
		if ($page)
		{
		$count      = $this->where($map)->count();
		$Page		= pager($count,$limit);
		$limit      = $Page->firstRow.','.$Page->listRows;
		$page_str   = $Page->fshow();
		}
		if (empty($sort))
		{
		$sort='sort DESC, count_question DESC';
		}
		$result = $this->where($map)->order($sort)->limit($limit)->select();
		foreach ($result as $key => $v){
				$v['img']=$this->get_tag_img($v['img'],$v['id']);
				$v['url']=RU('tag/view',array('t'=>$v['tag']));
				$v['audit_str']=$this->get_tag_audit($v['audit']);
				if ($showcat)
				{
					$cat=D('TagCat')->get_cat_one($v['cat']);
					$v['cat_str']=$cat['title'];
				}
				$list[]=$v;
			}
		$return['list']=$list;
		if ($page){
		$return['count']=$count;
		}else{
		$return['count']=count($list);
		}
		$return['page']=$page_str;
		//print_r($return);
		return $return;
	}
	//获取标签
	public function get_one_id($id='')
	{
		$map['id']  =intval($id);
		$info=$this->where($map)->find();
		if (!empty($info))
		{
		$info['imgsrc']=$this->get_tag_img($info['img'],$info['id']);
			$cat=D('TagCat')->get_cat_one($info['cat']);
		$info['cat_cn']=$cat['title'];
		}
		return $info;
	}
	//获取标签
	public function get_one_tag($tag='')
	{
		$map['tag']  =trim($tag);
		$info=$this->where($map)->find();
		if (!empty($info))
		{
		$info['imgsrc']=$this->get_tag_img($info['img'],$info['id']);
		}
		return $info;
	}
	//检测标签
	public function chenk_tag($tag='',$id='')
	{
		if (empty($tag))
		{
			return false;
		}
		$map['tag']  =trim($tag);
		$info=$this->where($map)->find();
		if (!empty($info))
		{
			if (!empty($id) && $info['id']==$id)
			{
				return false;
			}
			else
			{
		 		return true;
			}	
		}
		return false;
	}
	//获取标签图标
	public function get_tag_img($img='',$id='')
	{
		if (empty($img))
		{
		$img=__ROOT__.'/'.C('UU_IMG_TAG_DIR').substr($id,-1).'.gif';
		}
		else
		{
		$img=__ROOT__.'/'.C('UU_IMG_TAG_DIR').$img;
		}
		return $img;
	}
	//获取审核状态
	public function get_tag_audit($audit='0')
	{
		switch ($audit)
		{
					case '0':
					  $audit_str  = '<span style="color:#FF0000">未审核</span>'; 
					  break;  
					case '1':
					  $audit_str  ='<span style="color:#009900">已审核</span>';
					  break;
					case '-1':
					  $audit_str  = '<span style="color:#999999">未通过</span>'; 
					  break;
		}
		return $audit_str;
	}
	//更新标签统计（从数据库统计）
	public function update_tag_count($tagid='',$type='1')
	{
		if (!is_array($tagid))
		{
		$tagid=array($tagid);
		}
		foreach($tagid as $v)
		{
			if ($type=='1')//更新标签问题总数
			{
				$where['tagid']=intval($v);
				$data['count_question']=M('QuestionTag')->where($where)->count();
				$data['id']=intval($v);
				$this->save($data);
			}
			if ($type=='2')//更新标签文章总数
			{
				$where['tagid']=intval($v);
				$data['count_article']=M('ArticleTag')->where($where)->count();
				$data['id']=intval($v);
				$this->save($data);
			}
		}		
	}
	////更新标签统计（直接数据增减）
	public function set_tag_count($tagid='',$fieldname='count_question',$change='inc')
	{
		if (!is_array($tagid))
		{
		$tagid=array($tagid);
		}
		foreach($tagid as $v)
		{
			$where['id']=intval($v);
			if ($change=='inc')
			{
				$this->where($where)->setInc($fieldname,1);
			}else{
				$this->where($where)->setDec($fieldname,1);
			}
		}		
	}
}
?>