<?php 
namespace Common\Model;
use Think\Model;
class UserTrackModel extends Model//用户动态
{
	//增加动态----
	/*
	$type 1.提问
	$type 2.回答
	$type 3.发表文章
	$type 4.赞了答案
	$type 5.赞了文章
	$type 6.关注了问题
	$type 7.关注了TAG（）
	$type 8.问题加入收藏
	$type 9.采纳了最佳答案
	*/
	public function add_track($uid='',$objid='',$type='1',$aid='0')
	{
		$data['uid']=intval($uid);
		$data['type']=intval($type);
		$data['objid']=intval($objid);
		$data['aid']=intval($aid);
		$data['addtime']=time();
		$this->add($data);
		return true;
	}
	//获取统计
	public function get_count($uid='')
	{
		$map['uid']=intval($uid);
		$count=$this->where($map)->count();
		return $count;
	}
	//获取动态
	public function get_list($map='',$page=false,$sort='',$num='')
	{
		
		if (!empty($map['uid'])){
		$map['uid']=intval($map['uid']);
		}
		if (!empty($map['objid'])){
		$map['objid']=intval($map['objid']);
		}
		if (!empty($map['type'])){
		$map['type']=intval($map['type']);
		}
		$sort=$sort?$sort:'id desc';
		$limit=$num?$num:10;
		if ($page)
		{
			$count      = $this->where($map)->count();
			if ($count==0)
			{
				return '';
			}
			$Page		= pager($count,$limit);
			$limit      = $Page->firstRow.','.$Page->listRows;
			$page_str   = $Page->fshow();
		}
		$list = $this->where($map)->order($sort)->limit($limit)->select();
		foreach($list as $v)
		{
			$v['user']=D('User')->get_user_one($v['uid'],true);
			$v['addtime_str']=daterange($v['addtime']);
			switch ($v['type'])
			{
			case '1':
			  $v['type_str']='提问了问题';
			  $v['question']=D('Question')->get_question_one($v['objid']);
			  break;  
			case '2':
			  $v['type_str']='回答了问题';
			  $v['question']=D('Question')->get_question_one($v['objid']);
			  $v['answer']=D('Answer')->get_answer_one_id($v['aid']);
			  break;
			case '3':
			  $v['type_str']='发表了文章';
			  $v['article']=D('Article')->get_one_id($v['objid']);
			  break;
			case '4':
			  $v['type_str']='赞了答案';
			  $v['question']=D('Question')->get_question_one($v['objid']);
			  $v['answer']=D('Answer')->get_answer_one_id($v['aid']);
			  break;
			case '5':
			  $v['type_str']='赞了文章';
			  $v['article']=D('Article')->get_one_id($v['objid']);
			  break;
			case '6':
			  $v['type_str']='关注了问题';
			  $v['question']=D('Question')->get_question_one($v['objid']);
			  break;
			case '7':
			  $v['type_str']='关注了标签';
			  $v['question']=D('Question')->get_question_one($v['objid']);
			  break;
			case '8':
			  $v['type_str']='加入了收藏';
			  $v['question']=D('Question')->get_question_one($v['objid']);
			  break;
			case '9':
			  $v['type_str']='采纳了答案';
			  $v['question']=D('Question')->get_question_one($v['objid']);
			  $v['answer']=D('Answer')->get_answer_one_id($v['aid']);
			  break;
			}
			$li[]=$v;
		}
		$return['list']=$li;
		if ($page){
		$return['count']=$count;
		}else{
		$return['count']=count($li);
		}
		$return['page']=$page_str;
		return $return;
	}
}
?>