<?php
namespace admin\Controller;
use Think\Controller;
class TagController extends CommonController {
	public function lists(){
		$key = I('request.key','','trim');
		if ($key)
		{
			$key_type = I('request.key_type',1,'intval');
			if ($key_type=='1')
			{
				$map['tag'] = array('like','%'.$key.'%');
			}
			if ($key_type=='2')
			{
				$map['describe'] = array('like','%'.$key.'%');
			}
		}
		$audit = I('request.audit');
		if ($audit<>'')
		{
			$map['audit']=intval($audit);
		}
		$sort='sort DESC, count_question DESC';
		$tag = D("Tag")->get_list($map,true,$sort,'',true);
		$cat  = D("TagCat")->get_list();
		$this->assign('cat',$cat);
		$this->assign('tag',$tag);
		$this->display();
	}
	
	public function add(){
		if(IS_POST)
		{
				$data = D("Tag");
				if (!$data->create()){
					$this->error($data->getError());
				}
				else
				{
					$tag = I('request.tag','','trim');
					if($data->chenk_tag($tag))
					{
						$this->error('标签已经存在！不能重复');
					}
					$data->add();
					$this->success('保存完成',RU('tag/lists'));
				}
		}
		else
		{
			$cat  = D("TagCat")->get_list();
			$this->assign('cat',$cat);
		 	$this->display();
		}
	}
	public function edit(){
		if(IS_POST)
		{
				$tagmodel = D("Tag");
				if (!$data=$tagmodel->create()){
					$this->error($tagmodel->getError());
				}
				else
				{
					$tag = I('request.tag','','trim');
					$id  = I('request.id','0','intval');
					if($tagmodel->chenk_tag($tag,$id))
					{
						$this->error('标签已经存在！不能重复');
					}
					$tagmodel->save($data);
					$this->success('保存完成',RU('tag/lists'));
				}
		}
		else
		{
			$id=I('get.id','','intval');
			if ($id)
			{
				$show=D('Tag')->get_one_id($id);
				$cat  = D("TagCat")->get_list();
				$this->assign('cat',$cat);
				$this->assign('show',$show);
				$this->display();
				//dump($show);
			}
			else
			{
			$this->error('非法请求');
			}
		}
	}
	
	public function delete(){
	
		$ids = I('request.id');
		$ids = is_array($ids)?implode(",",$ids):$ids;	
		if ($ids && preg_match("/^(\d{1,10},)*(\d{1,10})$/",$ids))
		{
			$s=M("Tag")->delete($ids);
			$map['id']=array('IN',$ids);
			M('QuestionTag')->where($map)->delete();
			M('ArticleTag') ->where($map)->delete();
			$this->success("成功删除{$s}条数据");
		}
		else
		{
		$this->error('请选择要删除的信息！');
		}
	
 	}
public function audit(){
	
		$ids = I('request.id');
		$audit=I('request.audit','0','intval');
		$ids = is_array($ids)?implode(",",$ids):$ids;	
		if ($ids && preg_match("/^(\d{1,10},)*(\d{1,10})$/",$ids))
		{
			$map['id']     = array('IN',$ids);
			$data['audit'] = intval($audit);
			M('Tag')->where($map)->save($data);
			if ($audit=='-1')
			{
				unset($map);
				$map['tag_id']     = array('IN',$ids);
				M('QuestionTag')->where($map)->delete();
				M('ArticleTag') ->where($map)->delete();
			}
			$this->success("审核成功！");
		}
		else
		{
		$this->error('请选择项目！');
		}
	
}
public function counts(){
	
		$ids = I('request.id');
		if(empty($ids))
		{
		$this->error('请选择项目！');
		}
		$ids = is_array($ids)?$ids:array($ids);
		foreach ($ids as $id)
		{
			D('Tag')->update_tag_count($id,1);
			D('Tag')->update_tag_count($id,2);
		}
		$this->success("更新标签成功！");
}
//转移分类
public function transfer(){
	 	$ids = I('post.id');
		$cat = I('post.cat');
		if ($cat=='')
		{
		$this->error('请选择分类！');
		}
		$ids = is_array($ids)?implode(",",$ids):$ids;
		if ($ids && preg_match("/^(\d{1,10},)*(\d{1,10})$/",$ids))
		{
			$map['id']     = array('IN',$ids);
			$data['cat'] = intval($cat);
			M('Tag')->where($map)->save($data);
			$this->success("设置成功！");
		}
		else
		{
		$this->error('请选择标签！');
		}
}
//保存所有
	public function allSave(){
	 	$id = I('post.sort_id');
		$sort = I('post.sort');
		$num = 0;
		$data = M("Tag");
		if (is_array($id) && count($id)>0)
        {
            foreach($id as $k=>$v)
            {
                $map['id'] = intval($v);
                $map['sort']=intval($sort[$k]);
				$data->save($map);
                $num++;
         
            }
        }
		if($num>0){
            $this->success('成功保存'.$num.'个分类！');
        }else{
            $this->error('未保存任何分类！');
        }
		 
	
 	}
//分类列表
public function cat(){
		$cat  = D("TagCat")->get_list();
		$this->assign('cat',$cat);
		$this->display();
}
//保存分类
public function cat_save(){
		$id = I('post.id');
        $title = I('post.title');
        $sort = I('post.sort');
		$add_title = I('post.add_title');
 		$add_sort = I('post.add_sort');
		$num = 0;
		$data = M("TagCat");
		if (is_array($id) && count($id)>0)
        {
            foreach($id as $k=>$v)
            {
                unset($map);
                $map['id'] = intval($v);
                $map['title']=trim($title[$k]);
                $map['sort']=intval($sort[$k]);
				$data->save($map);
                $num++;
         
            }
        }
		if (is_array($add_title) && count($add_title)>0)
        {
            foreach($add_title as $k=>$v)
            {
                unset($map);
				$map['title']  =trim($v);
				$map['sort'] =trim($add_sort[$k]);
				if (!empty($map['title']))
				{
				$data->add($map);
                $num++;
		 		}
            }
        }
		if($num>0){
            $this->success('成功保存'.$num.'个分类！');
        }else{
            $this->error('未保存任何分类！');
        }
}

public function cat_delete(){
	
		$ids = I('request.id');
		$ids = is_array($ids)?implode(",",$ids):$ids;	
		if ($ids && preg_match("/^(\d{1,10},)*(\d{1,10})$/",$ids))
		{
			$s=M("TagCat")->delete($ids);
			$this->success("成功删除{$s}条数据");
		}
		else
		{
		$this->error('请选择要删除的信息！');
		}
	
}

 
}
?>