<?php
namespace admin\Controller;
use Think\Controller;
class UserController extends CommonController {
	public function lists(){
		$key = I('request.key','','trim');
		$isadmin = I('request.isadmin','','trim');
		if ($key)
		{
			$key_type = I('request.key_type',0,'intval');
			if ($key_type=='1')
			{
				$map['username'] = array('like','%'.$key.'%');
			}
			if ($key_type=='2')
			{
				$map['uid'] = intval($key);
			}
			if ($key_type=='3')
			{
				$map['mobile'] = array('like','%'.$key.'%');
			}
		}
		if ($isadmin)
		{
			$map['isadmin'] = intval($isadmin);
		}
		$list=D('User')->get_list($map,true);
		$this->assign('lists',$list);
		$this->display();
	}
	//禁言
	public function ban(){
		$ban = I('request.ban');
		$bantxt = I('request.bantxt');
		$ids = I('request.uid');
		$ids = is_array($ids)?implode(",",$ids):$ids;
		if ($ids && preg_match("/^(\d{1,10},)*(\d{1,10})$/",$ids))
		{
			if($ban=='-1')
			{
				D("UserBan")->clear_ban($ids);
				$this->success("成功解除禁言");
			}
			else
			{
				$s=D("UserBan")->set_ban($ids,$ban,$bantxt);
				$this->success("{$s}个用户被禁言");
			}
		}
		else
		{
		$this->error('请选择要禁言的用户！');
		}
	
 	}
	//禁言
	public function isadmin(){
		$isadmin = I('request.isadmin');
		$ids = I('request.uid');
		if (in_array('1',$ids) || $ids=='1')
		{
			$this->error('超级管理员禁止修改！');
		}
		$ids = is_array($ids)?implode(",",$ids):$ids;
		if ($ids && preg_match("/^(\d{1,10},)*(\d{1,10})$/",$ids))
		{
			 $r=D('User')->set_isadmin($ids,$isadmin);
			 if ($r)
			 {
			 	$this->success("设置成功",'lists');
			 }
			 else
			 {
				 $this->error('设置失败！');
			 }
		}
		else
		{
		$this->error('请选择用户！');
		}
	
 	}
	//删除
	public function delete(){
	
		$ids = I('request.uid');
		if (in_array('1',$ids) || $ids=='1')
		{
			$this->error('超级管理员禁止删除！');
		}
		$ids = is_array($ids)?implode(",",$ids):$ids;
		if ($ids && preg_match("/^(\d{1,10},)*(\d{1,10})$/",$ids))
		{
			$s=D('User')->del_user($ids);
			$this->success("成功删除");
		}
		else
		{
		$this->error('请选择要删除的信息！');
		}
	
 	}
 
}
?>