<?php
namespace home\Controller;
use Think\Controller;
class AjaxController extends Controller {
	public function _initialize(){
		$this->uid=session('uu.uid');
	}
    public function view(){
			if (IS_AJAX){
				$act = I('request.act','','trim');
				if(!in_array($act,array(
					'ajax_toploginform',//顶部登录状态
					'ajax_logout',//退出
					'ajax_user_login',//登录弹窗
					'ajax_user_login_verify',//登录验证
					'ajax_user_reg',//注册弹窗
					'ajax_user_reg_save',//注册保存
					'ajax_user_findpwd',//找回密码弹窗
					'ajax_user_findpwd_save',//新密码保存
					'ajax_mobile_code_verify',//验证手机随机码
					'ajax_send_mobile_code',//发送手机随机码
					'ajax_mobile_login_code_verify',//验证动态码登录，正确直接登录(用于动态码登录)
					
					
					'ajax_edit_username',//修改用户名
					'ajax_edit_mobile',//修改用户手机号
					'ajax_edit_sp',//修改用户擅长
					'ajax_user_follow',//用户加关注
					'ajax_question_follow',//问题加关注
					'ajax_favorites',//加收藏
					'ajax_user_editpwd',//修改密码
					'ajax_msg_read',//系统消息未读已读
					
					'ajax_pms_send',//发私信
					'ajax_pms_save',//私信保存
					'ajax_pms_reply',//回复私信
					'ajax_pms_read',//私信未读已读
					
					'ajax_cat_list',//分类选择
					'ajax_tag_list',//标签选择
					'ajax_tag_so',//搜索标签
					
					
				)
				)){
				$ajax['status']  = 0;
				$ajax['content'] =$act."不允许请求";
				$this->ajaxReturn($ajax);
				exit();
				}else{
				$this->$act();
				}			
			}else{
				$ajax['status']  = 0;
				$ajax['content'] ="参数非法";
				$this->ajaxReturn($ajax);
			}
    }
	//登录状态
	 public function ajax_toploginform(){
	 		$user=D('User');
	 		$str='欢迎&nbsp;&nbsp;'.session('uu.username').'&nbsp;&nbsp;登录！ <span><a href="'.RU('user/index').'">进入会员中心</a></span><span><a href="Javascript:void(0)" class="J_user_logout">退出</a></span>';
			$str1='欢迎登录 '.C('UU_SITE_NAME').'！请 <span><a href="Javascript: void(0)" class="J_user_login">登录</a></span>或<span><a href="Javascript: void(0)" class="J_user_reg">注册</a></span>';
			if ($user->is_login()){
			$html= $str;
			}else{
			$html= $str1;
			}
			$ajax['status']  = 1;
			$ajax['content'] =$html;
			$this->ajaxReturn($ajax);
			
    }
	//登录
	public function ajax_user_login(){
			$user=D('User');
		if ($user->is_login()){
			$ajax['status']  = 0;
			$ajax['content'] ="已经登录成功了，尝试刷新页面！";
			$this->ajaxReturn($ajax);			 
		}else{
		$oauth_list = uu_get_cache('oauth');
		$this->assign('oauth_list',$oauth_list);
		$html = $this->fetch('ajax_user_login');
		$ajax['status']  = 1;
		$ajax['content'] =$html;
		$this->ajaxReturn($ajax);
		}
    }
	//登录验证
	public function ajax_user_login_verify(){
		$u=D('User');
	 	$username = I('request.username','','trim');
		$password = I('request.password','','trim');
		$auto = I('request.auto','','trim');
		if (empty($username) || empty($password) )
		{
			$ajax['status']  = 0;
			$ajax['content'] ='用户名和密码不能为空';
			$this->ajaxReturn($ajax);
		}else{
			$user=$u->verify_username_password($username,$password);
			if ($user)
			{
				$u->user_login($user);
				if($auto=='1'){//设置cookie
					cookie('uu_username',$user['username'],31536000);
					cookie('uu_password',$user['password'],31536000);
				}
				$ajax['status']  = 1;
				$ajax['content'] ='登录成功！';
				$this->ajaxReturn($ajax);
			}else{
				$ajax['status']  = 0;
				$ajax['content'] ='用户名或密码错误！';
				$this->ajaxReturn($ajax);
			}
			 
		}
    }
	//退出
	public function ajax_logout(){
		$user=D('User');
		$user->clear_session();
		$ajax['status']  = 1;
		$ajax['content'] ="退出成功！";
		$this->ajaxReturn($ajax);
    }
	//注册
	public function ajax_user_reg()
	{
		$user=D('User');
		if ($user->is_login())
		{
			$ajax['status']  = 0;
			$ajax['content'] ="你目前是登录状态，不能注册！";
			$this->ajaxReturn($ajax);			 
		}else{
			$oauth_list = uu_get_cache('oauth');
			$this->assign('oauth_list',$oauth_list);
			$html = $this->fetch('ajax_user_reg');
			$ajax['status']  = 1;
			$ajax['content'] =$html;
			$this->ajaxReturn($ajax);
		}
    }
	//注册验证
	public function ajax_user_reg_save(){
		$SMSopen=C('UU_SMS_OPEN');
	 	$username = I('request.username','','trim');
		$password = I('request.password','','trim');
		if ($SMSopen)
		{
			$code = I('request.code','','trim');
			$mobile = I('request.mobile');
			$mobile_code=session('mobile_code');
			$mobile_post=session('mobile_post');
			if (empty($code) || $code<>$mobile_code)
			{
				$code_err=session('code_err');
				$code_err_is3=session('code_err_is3');
				$code_err=intval($code_err)+1;
				if ($code_err>3 || $code_err_is3)
				{
				$ajax['status']  = 0;
				$ajax['content'] ='验证码连续3次出错，请重新发送！';
				session('code_err',NULL);
				session('code_err_is3','true');
				$this->ajaxReturn($ajax);
				}
				session('code_err',$code_err);
				$ajax['status']  = 0;
				$ajax['content'] ='验证码错误，请重新输入';
				$this->ajaxReturn($ajax);
				
			}
			if (empty($mobile) || $mobile<>$mobile_post)
			{
				$ajax['status']  = 0;
				$ajax['content'] ='手机号填写错误';
				$this->ajaxReturn($ajax);
			}
		}
		if ($SMSopen=='0')
		{
		$mobile='';
		}
		if ($SMSopen && $mobile=='')//开启短信
		{
			$ajax['status']  = 0;
			$ajax['content'] ='非法请求';
			$this->ajaxReturn($ajax);
		}
		if (empty($username) || empty($password) )
		{
			$ajax['status']  = 0;
			$ajax['content'] ='用户名和密码不能为空';
			$this->ajaxReturn($ajax);
		}
		$bind='';
		$bind_keyid = I('request.bind_keyid','','trim');
		$bind_type = I('request.bind_type','','trim');
		if (!empty($bind_keyid) && !empty($bind_type) )
		{
		$bind=array('bind_keyid'=>$bind_keyid,'bind_type'=>$bind_type);
		}
		$reg=D('User')->user_reg($username,$mobile,$password,true,$bind);
		$this->ajaxReturn($reg);	 
    }
	////发送手机验证码，需验证手机是否存在
	public function ajax_send_mobile_code(){
		$mobile_post=I('request.mobile','','trim');
		$in_user    =I('request.in_user','1','intval');//默认给已经注册过的手机发送验证码
		if(!preg_match("/^1[34578]{1}\d{9}$/",$mobile_post)){  
			$ajax['status']  = 0;
			$ajax['content'] ="手机号{".$mobile_post."}格式错误！";
			$this->ajaxReturn($ajax);
		}
		else
		{
			if ($in_user=='1')
			{
				$info=D('User')->get_user_one($mobile_post,false,2);
				if (empty($info))
				{
					$ajax['status']  = 0;
					$ajax['content'] ="手机号[".$mobile_post."]未注册！";
					$this->ajaxReturn($ajax);
				}
			}
			$mobile_code=rand(1000,9999);
			$params = array('rand'=>$mobile_code.'','sitename'=>C('UU_SITE_NAME'));
			$send=send_sms($mobile_post,$params,'mobile_code');
			if ($send['status']=='0')
			{
				$ajax['status']  = 0;
				$ajax['content'] =$send['content'];
				$this->ajaxReturn($ajax);
			}
			session('mobile_code',$mobile_code);
			session('mobile_post',$mobile_post);
			session('code_err_is3',NULL);
			$ajax['status']  = 1;
			$ajax['content'] ="验证码发送成功！";
			$this->ajaxReturn($ajax);
		}
		
	}
	//找回密码
	public function ajax_user_findpwd()
	{
		$user=D('User');
		if ($user->is_login())
		{
			$ajax['status']  = 0;
			$ajax['content'] ="你目前是登录状态，不能找回密码！";
			$this->ajaxReturn($ajax);			 
		}else{
			$oauth_list = uu_get_cache('oauth');
			$this->assign('oauth_list',$oauth_list);
			$html = $this->fetch('ajax_user_findpwd');
			$ajax['status']  = 1;
			$ajax['content'] =$html;
			$this->ajaxReturn($ajax);
		}
    }
	//找回密码
	public function ajax_user_findpwd_save(){
		$SMSopen=C('UU_SMS_OPEN');
	 	$mobile = I('request.mobile');
		$password = I('request.password','','trim');
		$code     = I('request.code','','trim');
		$mobile_code=session('mobile_code');
		$mobile_post=session('mobile_post');
		if (empty($SMSopen))
		{
				$ajax['status']  = 0;
				$ajax['content'] ='手机短信功未打开，无法找密码！';
				$this->ajaxReturn($ajax);
		}
  		if (empty($code) || $code<>$mobile_code)
		{
				$ajax['status']  = 0;
				$ajax['content'] ='验证码错误，请重新输入';
				$this->ajaxReturn($ajax);
		}
		if (empty($mobile) || $mobile<>$mobile_post)
			{
				$ajax['status']  = 0;
				$ajax['content'] ='手机号填写错误';
				$this->ajaxReturn($ajax);
		}
		if (empty($password))
		{
				$ajax['status']  = 0;
				$ajax['content'] ='必须填写新密码！';
				$this->ajaxReturn($ajax);
		}
		$user=D('User')->get_user_one($mobile,false,2);
		D('User')->edit_pwd($user['uid'],$password);
		$ajax['status']  = 1;
		$ajax['content'] ='新密码设置成功，请重新登录！';
		$this->ajaxReturn($ajax);	 
    }
	//验证手机短信验证码
	public function ajax_mobile_code_verify(){
		$code  = I('request.code','','trim');
		if (empty($code)){
			$ajax['status']  = 0;
			$ajax['content'] ="验证码不能为空！";
			$this->ajaxReturn($ajax);
		}
		if (session('mobile_code')==''){
			$ajax['status']  = 0;
			$ajax['content'] ="验证码失效，请重新发送！";
			$this->ajaxReturn($ajax);
		}
		if ($code==session('mobile_code')){
			$ajax['status']  = 1;
			$ajax['content'] ="验证通过！";
			$this->ajaxReturn($ajax);
		}else{
				$code_err=session('code_err');
				$code_err=intval($code_err)+1;
				$code_err_is3=session('code_err_is3');
				if ($code_err>3 || $code_err_is3)
				{
				$ajax['status']  = 0;
				$ajax['content'] ='验证码连续3次出错，请重新发送！';
				session('code_err',NULL);
				session('code_err_is3','true');
				$this->ajaxReturn($ajax);
				}
			session('code_err',$code_err);
			$ajax['status']  = 0;
			$ajax['content'] = "验证码错误，请正确填写！";
			$this->ajaxReturn($ajax);
		}
	 }
	//用手机验证码登录，正确直接通过手机号登录
	public function ajax_mobile_login_code_verify(){
		$code  = I('request.code','','trim');
		$mobile  = I('request.mobile','','trim');
		$auto = I('request.auto','','intval');
		if (session('mobile_code')=='')
		{
			$ajax['status']  = 0;
			$ajax['content'] ="请先发送验证码！";
			$this->ajaxReturn($ajax);
		}
		if (empty($code)){
			$ajax['status']  = 0;
			$ajax['content'] ="验证码不能为空！";
			$this->ajaxReturn($ajax);
		}
		if (session('mobile_code')==''){
			$ajax['status']  = 0;
			$ajax['content'] ="验证码失效，请重新发送！";
			$this->ajaxReturn($ajax);
		}
		if (session('mobile_post')<>$mobile){
			$ajax['status']  = 0;
			$ajax['content'] ="提交的手机号和发送验证码的手机号不一致";
			$this->ajaxReturn($ajax);
		}
		if ($code==session('mobile_code')){
			D('User')->user_login('',$mobile,2);
			if($auto=='1'){//设置cookie
					cookie('uu_username',$user['username'],31536000);
					cookie('uu_password',$user['password'],31536000);
			}
			$ajax['status']  = 1;
			$ajax['content'] ="验证通过！";
			$this->ajaxReturn($ajax);
		}else{
			$ajax['status']  = 0;
			$ajax['content'] = "验证码错误，请正确填写！";
			$this->ajaxReturn($ajax);
		}
	}
	//修改用户名
	public function ajax_edit_username(){
		 if (empty($this->uid))
		 {
		 	$ajax['status']  = 0;
			$ajax['content'] = "获取UID失败";
			$this->ajaxReturn($ajax);
		 }
		 else
		 {
		 	$edit = I('request.edit','0','intval');
			if ($edit)
			{
				$username = I('request.username','','trim');
				if(strlen($username) < 6 || strlen($username) > 18)
				{
					$ajax['status']    = 0;
					$ajax['content']   = '用户名长度为6-18位字符之间';
					$this->ajaxReturn($ajax);
				}
				$info=D('User')->edit_username($this->uid,$username);
				if ($info['status']==1)
				{
					session('uu.username',$username);
					$ajax['status']    = 1;
					$ajax['username']  = $username;
					$ajax['content']   ='修改成功！';
					$this->ajaxReturn($ajax);
					
				}
				else
				{
					$ajax['status']    = 0;
					$ajax['content']   = $info['content'];
					$this->ajaxReturn($ajax);
				}
			}
			else
			{
				$this->assign('username',session('uu.username'));
				$html = $this->fetch('ajax_edit_username');
				$ajax['status']  = 1;
				$ajax['content'] =$html;
				$this->ajaxReturn($ajax);
			}
		 }
	}
	//修改手机
	public function ajax_edit_mobile(){
		 if (empty($this->uid))
		 {
		 	$ajax['status']  = 0;
			$ajax['content'] = "获取UID失败";
			$this->ajaxReturn($ajax);
		 }
		 else
		 {
		 	$mobile = I('request.mobile','','trim');
			$edit = I('request.edit','0','intval');
			$code = I('request.code','','trim');
			$code_err=intval(session('code_err'));
			if ($edit)
			{
				if (empty($mobile) || empty($code))
				{
					$ajax['status']    = 0;
					$ajax['content']   = '请填写手机号和验证码';
					$this->ajaxReturn($ajax);
				}
				$mobile_post=session('mobile_post');
				if ($mobile<>$mobile_post)
				{
					$ajax['status']    = 0;
					$ajax['content']   = '您填写手机号和你发送验证码的手机不同！';
					$this->ajaxReturn($ajax);
				}	 
				if ($code<>session('mobile_code'))
				{
					$code_err=session('code_err');
					$code_err=intval($code_err)+1;
					$code_err_is3=session('code_err_is3');
					if ($code_err>3 || $code_err_is3)
					{
					$ajax['status']  = 0;
					$ajax['content'] ='验证码连续3次出错，请重新发送！';
					session('code_err',NULL);
					session('code_err_is3','true');
					$this->ajaxReturn($ajax);
					}
					session('code_err',$code_err);
					$ajax['status']  = 0;
					$ajax['content'] = "验证码错误，请正确填写！";
					$this->ajaxReturn($ajax);
				}
				$info=D('User')->edit_mobile($this->uid,$mobile);
				if ($info['status']==1)
				{
					$ajax['status']    = 1;
					$ajax['mobile']  = $mobile;
					$ajax['mobile_hide']  = D('User')->mobile_hide($mobile);
					$ajax['content']   ='修改成功！';
					$this->ajaxReturn($ajax);
					
				}
				else
				{
					$ajax['status']    = 0;
					$ajax['content']   = $info['content'];
					$this->ajaxReturn($ajax);
				}
			}
			else
			{
				$us=D('User')->get_user_one($this->uid);
				$this->assign('mobile',$us['mobile']);
				$html = $this->fetch('ajax_edit_mobile');
				$ajax['status']  = 1;
				$ajax['content'] =$html;
				$this->ajaxReturn($ajax);
			}
		 }
	}
	//修改擅长
	public function ajax_edit_sp(){
		 if (empty($this->uid))
		 {
		 	$ajax['status']  = 0;
			$ajax['content'] = "获取UID失败";
			$this->ajaxReturn($ajax);
		 }
		 else
		 {
		 	
			$u=D('User');
			$edit = I('request.edit','0','intval');
			if ($edit)
			{
					$specialty = I('request.specialty','','trim');
					if (empty($specialty))
					{
						$ajax['status']  = 0;
						$ajax['content'] = "特长不能为空！";
						$this->ajaxReturn($ajax);
					}
				    $u->edit_specialty($this->uid,$specialty);
					$ajax['status']    = 1;
					$ajax['specialty'] = $specialty;
					$ajax['content']   ='修改成功！';
					D('Task')->exe_user_specialty($this->uid);
					$this->ajaxReturn($ajax);
			}
			else
			{
				$us=$u->get_user_one($this->uid);
				$this->assign('specialty',$us['specialty']);
				$html = $this->fetch('ajax_edit_sp');
				$ajax['status']  = 1;
				$ajax['content'] =$html;
				$this->ajaxReturn($ajax);
			}
		 }
	}
	//用户加关注
	public function ajax_user_follow(){
		$uid  = I('request.uid','','intval');
		if (empty($this->uid) || empty($uid))
		{
		 	$ajax['status']  = 0;
			$ajax['content'] = "获取UID失败";
			$this->ajaxReturn($ajax);
		}
		if ($uid==$this->uid)
		{
			$ajax['status']  = 0;
			$ajax['content'] = "自己不可以关注自己";
			$this->ajaxReturn($ajax);
		}
		$chenk=D('FollowUser')->chenk_follow_user($this->uid,$uid);
		if ($chenk)
		{
			D('FollowUser')->clear_follow_user($this->uid,$uid);
			$count=D('FollowUser')->get_follow_count($uid,2);
			$ajax['status']  = 1;
			$ajax['count']  = $count;
			$ajax['content'] ='取消关注成功！';
			$this->ajaxReturn($ajax);
		}
		else
		{
		D('FollowUser')->follow_user($this->uid,$uid);
		$count=D('FollowUser')->get_follow_count($uid,2);
		$ajax['status']  = 1;
		$ajax['count']  = $count;
		$ajax['content'] ='关注成功！';
		$this->ajaxReturn($ajax);
		}
	}
	//问题加关注
	public function ajax_question_follow(){
		$qid  = I('request.qid','','intval');
		if (empty($this->uid) || empty($qid))
		{
		 	$ajax['status']  = 0;
			$ajax['content'] = "数据错误！";
			$this->ajaxReturn($ajax);
		}
		$chenk=D('FollowQuestion')->chenk_follow_question($this->uid,$qid);
		if ($chenk)
		{
			D('FollowQuestion')->clear_follow_question($this->uid,$qid);
			$count=D('FollowQuestion')->get_follow_count($qid);
			$ajax['status']  = 1;
			$ajax['count']  = $count;
			$ajax['content'] ='取消关注成功！';
			$this->ajaxReturn($ajax);
		}
		else
		{
		D('FollowQuestion')->follow_question($this->uid,$qid);
		$count=D('FollowQuestion')->get_follow_count($qid);
		D('UserTrack')->add_track($this->uid,$qid,6);//写入个人动态
		$ajax['status']  = 1;
		$ajax['count']  = $count;
		$ajax['content'] ='关注成功！';
		$this->ajaxReturn($ajax);
		}
	}
	//问题加收藏
	public function ajax_favorites(){
		$qid  = I('request.qid','','intval');
		$aid  = I('request.aid','','intval');
		$type  = I('request.type','','intval');
		if ($type==1){
		$objid=$qid;
		}else{
		$objid=$aid;
		}
		if (empty($this->uid) || empty($type))
		{
		 	$ajax['status']  = 0;
			$ajax['content'] = "数据错误！";
			$this->ajaxReturn($ajax);
		}
		$chenk=D('UserFavorites')->chenk_favorites($this->uid,$objid,$type);
		if ($chenk)
		{
			D('UserFavorites')->clear_favorites($this->uid,$objid,$type);
			$count=D('UserFavorites')->get_favorites_count($objid,$type);
			$ajax['status']  = 1;
			$ajax['count']  = $count;
			$ajax['content'] ='取消收藏成功！';
			$this->ajaxReturn($ajax);
		}
		else
		{
		D('UserFavorites')->add_favorites($this->uid,$objid,$type);
		$count=D('UserFavorites')->get_favorites_count($objid,$type);
		D('UserTrack')->add_track($this->uid,$objid,8);//写入个人动态
		$ajax['status']  = 1;
		$ajax['count']  = $count;
		$ajax['content'] ='加入收藏成功！';
		$this->ajaxReturn($ajax);
		}
	}
	//修改密码
	public function ajax_user_editpwd(){
		$old_password  = I('request.old_password','','trim');
		$password  = I('request.password','','trim');
		$username  = session('uu.username');
		if (empty($this->uid) || empty($old_password) || empty($password))
		{
		 	$ajax['status']  = 0;
			$ajax['content'] = "修改失败，数据错误！";
			$this->ajaxReturn($ajax);
		}
		if (D('User')->verify_username_password($username,$old_password)){
			D('User')->edit_pwd($this->uid,$password);
			$ajax['status']  = 1;
			$ajax['content'] = "密码修改成功！";
			$this->ajaxReturn($ajax);
		}else{
			$ajax['status']  = 0;
			$ajax['content'] = "修改失败，旧密码错误！";
			$this->ajaxReturn($ajax);
		}
	
	}
	//系统消息已读未读
	public function ajax_msg_read(){
		$id  = I('request.id','0','intval');
		D('UserMsg')->set_msg_read($id,$this->uid);
		$ajax['status']  = 1;
		$ajax['content'] ="设置成功！";
		$this->ajaxReturn($ajax);
	}
	//PMS
	public function ajax_pms_send(){
		$to_uid  = I('request.uid','0','intval');
		if (empty($this->uid) || empty($to_uid))
		{
		 	$ajax['status']  = 0;
			$ajax['content'] = "获取UID失败";
			$this->ajaxReturn($ajax);
		}
		if ($to_uid==$this->uid)
		{
			$ajax['status']  = 0;
			$ajax['content'] = "自己不能给自己私信！";
			$this->ajaxReturn($ajax);
		}
		$user=D('User')->get_user_one($to_uid);
		$this->assign('user',$user);
		$html = $this->fetch('ajax_pms');
		$ajax['status']  = 1;
		$ajax['content'] =$html;
		$this->ajaxReturn($ajax);
	}
	//保存私信
	public function ajax_pms_save(){
		$data['msg']  = I('request.msg','','trim');
		$data['to_uid'] = I('request.to_uid','0','intval');
		if (empty($data['msg']))
		{
			$ajax['status']  = 0;
			$ajax['content'] = "请填写私信内容！";
			$this->ajaxReturn($ajax);
		}
		$data['send_uid']=$this->uid;
		D('UserPms')->add_pms($data);
		$ajax['status']  = 1;
		$ajax['content'] ="发送成功！";
		$this->ajaxReturn($ajax);
		 
	}
	//私信已读未读
	public function ajax_pms_read(){
		$id  = I('request.id','0','intval');
		D('UserPms')->set_pms_read($id,$this->uid);
		$ajax['status']  = 1;
		$ajax['content'] ="设置成功！";
		$this->ajaxReturn($ajax);
	}
	//回复私信
	public function ajax_pms_reply(){
		$map['pid']  = I('request.id','0','intval');
		$map['send_uid']=$this->uid;
		$map['msg']  = I('request.msg','','trim');
		$map['addtime']  = time();
		if (empty($this->uid) || empty($map['pid']))
		{
			$ajax['status']  = 0;
			$ajax['content'] ="非法请求！";
			$this->ajaxReturn($ajax);
		}
		if (empty($map['msg']))
		{
			$ajax['status']  = 0;
			$ajax['content'] ="内容不能为空！";
			$this->ajaxReturn($ajax);
		}
		M('UserPmsChat')->add($map);
		$pms=D('UserPms')->get_pms_one($map['pid']);
		if ($pms['send_uid']==$this->uid){//回复自己的会话，收件人设置未读
			D('UserPms')->set_pms_read($map['pid'],$pms['to_uid'],0);
		}else{
			D('UserPms')->set_pms_read($map['pid'],$pms['send_uid'],0);
		}
		D('UserPms')->set_pms_display($map['pid']);//重新打开会话
		$ajax['status']  = 1;
		$ajax['content'] ="回复成功！";
		$this->ajaxReturn($ajax);
	}
	//分类列表
	public function ajax_cat_list(){
		$type  = I('request.type','1','intval');
		$this->assign('type',$type);
		$html = $this->fetch('ajax_cat_list');
		$ajax['status']  = 1;
		$ajax['content'] =$html;
		$this->ajaxReturn($ajax);
	}
	//TAG分类列表
	public function ajax_tag_list(){
		$post_tags  = I('request.tags','','trim');
		$post_tags_arr =array();
		if (!empty($post_tags))
		{
		$post_tags_arr  = explode('__uuask__',$post_tags);
		}
		$sort='sort DESC, count_question DESC';
		$res =D('Tag')->order($sort)->limit(30)->select();
		foreach($res as $var)
		{
			$tags_list[]=$var['tag'];
		}
		foreach($post_tags_arr as $var)
		{
			if (!in_array($var,$tags_list))
			{
			$tags_list[]=$var;
			}
		}
		$list = array_filter($tags_list);
			foreach($list as $var)
			{
				$li['tag']=$var;
				$li['select']='';
				if (!empty($post_tags_arr) && in_array($var,$post_tags_arr))
				{
				$li['select']='select';
				}
				$taglist[]=$li;
			}
			$list=$taglist;
			
		$this->assign('list',$list);
		$html = $this->fetch('ajax_tag_list');
		$ajax['status']  = 1;
		$ajax['content'] =$html;
		$this->ajaxReturn($ajax);
	}
	public function ajax_tag_so(){
		$key  = I('request.tagkey','','trim');
		if (empty($key))
		{
			$ajax['status']  = 0;
			$ajax['content'] ='关键字不能为空';
			$this->ajaxReturn($ajax);
		}
		$map['tag']  = array('LIKE','%'.$key.'%');
		$sort='sort DESC, count_question DESC';
		$list = D('Tag')->where($map)->order($sort)->limit(5)->select();
		$ajax['status']  = 1;
		$ajax['content'] =$list;
		$ajax['count']  = count($list);
		$ajax['key'] =$key;
		$this->ajaxReturn($ajax);
	}
	

}
?>