<?php
namespace home\Controller;
use Think\Controller;
class ArticleController extends Controller {
	public function _initialize(){
		$this->assign('page_as','article');
		$uid=session('uu.uid');
		if ($uid){
			$user=D('User')->get_user_one($uid);
			$this->assign('user',$user);
		}
	}
	public function lists(){
        $this->display();
    }
	public function view(){
       $this->display();
    }
	public function add(){
		$SMSopen=C('UU_SMS_OPEN');
		$uid=session('uu.uid');
		if (empty($SMSopen) && empty($uid))
		{
			$this->error('非法请求，短信未配置，不允许快捷发布');
		}
		$oauth_list = uu_get_cache('oauth');
		$this->assign('oauth_list',$oauth_list);
        $this->display();
    }
	public function addsave(){
	//var_dump($_POST);DIE;
		if(IS_POST){
			$user=D('User');
			$uid=session('uu.uid');
			if(!$user->is_login())//未登录用户先登录或者胡策
			{
				$SMSopen=C('UU_SMS_OPEN');
				if (empty($SMSopen))
				{
					$this->error('非法请求，短信未配置，不允许快捷发布');
				}
				$code = I('request.code','','trim');
				$mobile = I('request.mobile');
				$mobile_code=session('mobile_code');
				$mobile_post=session('mobile_post');
				if (empty($code) || $code<>$mobile_code)
				{
					$this->error('验证码错误，请重新输入');
				}
				if (empty($mobile) || $mobile<>$mobile_post)
				{
					$this->error('手机号错误，请重新输入');
				}
				$info=$user->get_user_one($mobile,false,2);
				if (!empty($info))
				{
						$user->user_login($info);//直接登陆再发布
						$this->article_add();
				}
				else
				{
					$reg=$user->user_reg('',$mobile,'',true);//注册再发布
					if ($reg['status']==0)
					{
							$this->error('失败了，'.$reg['content']);
					}
						$this->article_add();
				}
			}else{//已经注册用户
            	$this->article_add();
			}	
		}else{
		 	$this->error('非法请求');
		}
 
    }
	public function article_add(){
				$gold=0;
				$uid=session('uu.uid');
				$article = D("Article");
				$ban=D('UserBan')->chenk_ban($uid);
				if (!empty($ban))
				{
				$this->error("发表失败，您已经被禁言（{$ban['txt']}），禁言结束时间：{$ban['endtime_str']}");
				}
				if (!$article->create()){
				$this->error($article->getError());
				}
				$article->uid=$uid;
				$aid=$article->add();
				D('User')->update_count($uid,2);//更新文章总数
				D('Task')->exe_add_article($uid);//完成发表文章的任务
				D('UserTrack')->add_track($uid,$aid,3);//写入个人动态
				$tag = I('post.tag');
				if (!empty($tag))//插入标签
				{
					if(is_array($tag))
					{
						foreach ($tag as $v)
						{
							$map['aid']=$aid;
							$map['uid']=$uid;
							$tag=D('Tag')->get_one_tag($v);
							if (empty($tag))
							{
								$data['tag']=$v;
								$data['addtime']=time();
								$tagid=M('Tag')->add($data);
								$map['tagid']=$tagid;
							}
							else
							{
								$map['tagid']=$tag['id'];
							}
							$count_tag[]=$map['tagid'];
							$map['tag']=$v;
							M('ArticleTag')->add($map);
						}
					}
					//更新标签统计
					D('Tag')->set_tag_count($count_tag,'count_article','inc');
				}
				$this->redirect('/article/view',array('id'=>$aid));
	}
	
	//点赞
	public function ajax_inc_praise()
	{
		if (IS_AJAX){
			$uid=session('uu.uid');
			$aid= I('request.aid','','intval');
			$answeruid = I('request.answeruid','','intval');
			 if (empty($uid))
			 {
				$ajax['status']  = 0;
				$ajax['content'] = "请登录后操作！";
				$this->ajaxReturn($ajax);
			 }
			if (empty($uid) || empty($aid))
			 {
				$ajax['status']  = 0;
				$ajax['content'] = "参数错误";
				$this->ajaxReturn($ajax);
			 }
			  
				$r=D('ArticlePraise')->inc_praise($aid,$uid);//增加点赞记录
				if ($r){	
				D('Article')->inc_praise($aid);//修改文章点赞数字段
				$praise=D('Article')->get_praise($aid);//获取点赞数量
				D('User')->inc_praise($answeruid);//更新会员点赞总数
				D('UserTrack')->add_track($uid,$aid,5);//写入个人动态
				$ajax['status']  = 1;
				$ajax['content'] = $praise;
				$this->ajaxReturn($ajax);
				}
				else
				{
					$ajax['status']  = 0;
					$ajax['content'] = "你已经赞过了！";
					$this->ajaxReturn($ajax);
				}
		}
		
	}
}
?>