<?php
namespace home\Controller;
use Think\Controller;
class QuestionController extends Controller {
	public function _initialize(){
		$this->assign('page_as','question');
		$uid=session('uu.uid');
		if ($uid){
			$user=D('User')->get_user_one($uid,true);
			$this->assign('user',$user);
		}
	}
	public function lists(){
        $this->display();
    }
	public function view(){
        $this->display();
    }
	public function add(){
		$SMSopen=C('UU_SMS_OPEN');
		$uid=session('uu.uid');
		if (empty($SMSopen) && empty($uid))
		{
			$this->error('非法请求，短信未配置，不允许快捷发布');
		}
		$oauth_list = uu_get_cache('oauth');
		$this->assign('oauth_list',$oauth_list);
        $this->display();
    }
	public function addsave(){
		if(IS_POST)
		{
			$user=D('User');
			$uid=session('uu.uid');
			if(!$user->is_login())//未登录用户先登录或者注册
			{
				$SMSopen=C('UU_SMS_OPEN');
				if (empty($SMSopen))
				{
					$this->error('非法请求，短信未配置，不允许快捷发布');
				}
				$code = I('request.code','','trim');
				$mobile = I('request.mobile');
				$mobile_code=session('mobile_code');
				$mobile_post=session('mobile_post');
				if (empty($code) || $code<>$mobile_code)
				{
					$this->error('验证码错误，请重新输入');
				}
				if (empty($mobile) || $mobile<>$mobile_post)
				{
					$this->error('手机号错误，请重新输入');
				}
				$info=$user->get_user_one($mobile,false,2);
				if (!empty($info))
				{
						$user->user_login($info);//直接登陆再发布
						$this->question_add();
				}
				else
				{
						$reg=$user->user_reg('',$mobile,'',true);//注册再发布
						if ($reg['status']==0)
						{
							$this->error('失败了，'.$reg['content']);
							exit();
						}
						$this->question_add();
				}
			}
			else
			{
				//已经注册用户
            	$this->question_add();
			}	
		}
		else
		{
		 	$this->error('非法请求');
		}
 
    }
	public function question_add(){
				$gold=0;
				$uid=session('uu.uid');
				$reward_open = I('request.reward_open','0','intval');
				$img = I('post.img');
				$tag = I('post.tag');
				//检测是否禁言
				$ban=D('UserBan')->chenk_ban($uid);
				if (!empty($ban))
				{
				$this->error("发表失败，您已经被禁言（{$ban['txt']}），禁言结束时间：{$ban['endtime_str']}");
				}		
				$question = D("Question");
				if (!$question->create()){
				$this->error($question->getError());
				}
				$question->uid=$uid;
				if ($question->sms_remind=='1')//如果需要短信提醒
				{
					$sms_remind_val=C('UU_GOLD_SEND_MB');
					$sms_remind_val=intval($sms_remind_val);
					$gold=$sms_remind_val+$gold;
				}
				if ($reward_open=='1')//如果悬赏提问
				{
					$reward_var=intval($question->reward);
					$question->reward=$reward_var;
					$gold=$reward_var+$gold;
				}
				if ($question->anonymous=='1')//是否匿名
				{
					$anonymous_val=C('UU_GOLD_QUANTIFIER_ANONYMOUS');
					$anonymous_val=intval($anonymous_val);
					$gold=$anonymous_val+$gold;
				}
				if ($gold>0)
				{
					$umode=D('User');
					$user=$umode->get_user_one($uid);
					if ($gold>$user['gold']){
						$this->error("发表失败，您的".C('UU_GOLD_BYNAME')."不够用了！");
					}else{
						if ($question->sms_remind=='1'){
						$umode->edit_user_gold(1,$uid,$sms_remind_val,'发表问题设置收到答案短信提醒',false);
						}
						if ($reward_open=='1'){
						$umode->edit_user_gold(1,$uid,$reward_var,'悬赏提问消耗',false);
						}
						if ($question->anonymous=='1'){
						$umode->edit_user_gold(1,$uid,$anonymous_val,'匿名提问',false);
						}
					}
				}
				$qid=$question->add();
				D('User')->update_count($uid,1);//更新问题总数
				D('Task')->exe_add_question($uid);//完成发表问题的任务
				D('UserTrack')->add_track($uid,$qid,1);//写入个人动态
				if (!empty($img))//插入图片
				{
					if(is_array($img))
					{
							$qimg=M('QuestionImg');
						foreach ($img as $v){
							$map['qid']=$qid;
							$map['uid']=$uid;
							$map['img']=$v;
							$map['addtime']=time();
							$qimg->add($map);
						}
					}
				}
				if (!empty($tag))//插入标签
				{
					if(is_array($tag))
					{
						foreach ($tag as $v)
						{
							$map['qid']=$qid;
							$map['uid']=$uid;
							$tag=D('Tag')->get_one_tag($v);
							if (empty($tag))
							{
								$data['tag']=$v;
								$data['addtime']=time();
								$tagid=M('Tag')->add($data);
								$map['tagid']=$tagid;
							}
							else
							{
								$map['tagid']=$tag['id'];
							}
							$map['tag']=$v;
							$count_tag[]=$map['tagid'];
							M('QuestionTag')->add($map);
						}
					}
					//更新标签统计
					D('Tag')->set_tag_count($count_tag,'count_question','inc');
				}
				$this->redirect('/question/view',array('id'=>$qid));
	}
	//保存回复
	public function replysave(){
		$uid=session('uu.uid');
		$qid= I('request.qid','0','intval');
		$content= I('request.content','','trim');
		if (empty($uid) || empty($qid) || empty($content))
		{
			$this->error("参数错误！");
		}
		else
		{
				$ban=D('UserBan')->chenk_ban($uid);
				if (!empty($ban))
				{
				$this->error("发表失败，您已经被禁言（{$ban['txt']}），禁言结束时间：{$ban['endtime_str']}");
				}
				$reply=D('Answer');
				$info=$reply->get_answer_one($qid,$uid);
				if (empty($info))//如果没有回答过
				{
				$map['uid']=$uid;
				$map['qid']=$qid;
				$map['content']=$content;
				$map['addtime']=time();
				$aid=$reply->add($map);
				D('Question')->edit_answercount($qid);//更新问题回答总数
				D('Question')->edit_answeruid($qid,$uid);//更新问题的最后回复人
				D('User')->edit_answercount($uid);//更新会员回答总数
				D('UserTrack')->add_track($uid,$qid,2,$aid);//写入个人动态
				D('Task')->exe_reply_question($uid);//完成回答问题任务
				//短信通知
				$question=D('Question')->get_question_one($qid);
				$user=D('User')->get_user_one($question['uid']);
				$SMSopen=C('UU_SMS_OPEN');
				if ($SMSopen && $question['sms_remind']=='1' && !empty($user['mobile']))
				{
					$params['sitename']=C('UU_SITE_NAME');
					$send=send_sms($user['mobile'],$params,'answer_remind');
				}
				$this->redirect('/question/view',array('id'=>$qid));
				}
				else
				{
					$this->error("不能重复回答！");
				}
		}
	}
	//补充提问
	public function ajax_question_supp(){
		if (IS_AJAX){
			$uid=session('uu.uid');
			$qid= I('request.qid','0','intval');
			$content= I('request.content','','trim');
			if (empty($uid) || empty($qid) || empty($content))
			{
				$this->error("参数错误！");
			}
			else
			{
				$map['uid']=$uid;
				$map['qid']=$qid;
				$map['content']=$content;
				$map['addtime']=time();
				M('QuestionSupp')->add($map);
				$ajax['status']  = 1;
				$ajax['content'] = "提交成功！";
				$this->ajaxReturn($ajax);
			}
			
		}
	}
	//追问或者追答
	public function ajax_reply_asked()
	{
		if (IS_AJAX){
			$uid=session('uu.uid');
			$data['rid']     = I('request.rid','','intval');
			$data['type']    = I('request.type','','intval');
			$data['content'] = I('request.content','','trim');
			$data['addtime'] = time();
			$data['uid']     = $uid;
			if (empty($uid) || empty($data['content']))
			 {
				$ajax['status']  = 0;
				$ajax['content'] = "参数错误";
				$this->ajaxReturn($ajax);
			 }
			 else
			 {
				M('AnswerReply')->add($data);
				$ajax['status']  = 1;
				$ajax['content'] = "提交成功！";
				$this->ajaxReturn($ajax);
			 }
		 } 
	}
	//点赞
	public function ajax_inc_praise()
	{
		if (IS_AJAX){
			$uid=session('uu.uid');
			$rid= I('request.rid','','intval');
			$qid= I('request.qid','','intval');
			$answeruid = I('request.answeruid','','intval');
			 if (empty($uid))
			 {
				$ajax['status']  = 0;
				$ajax['content'] = "请登录后操作！";
				$this->ajaxReturn($ajax);
			 }
			if (empty($uid) || empty($rid))
			 {
				$ajax['status']  = 0;
				$ajax['content'] = "参数错误";
				$this->ajaxReturn($ajax);
			 }
			  
				$r=D('AnswerPraise')->inc_praise($rid,$uid);//增加点赞记录
				if ($r){
				D('Answer')->inc_praise($rid);//修改回复点赞数字段
				$praise=D('Answer')->get_praise($rid);//获取回复点赞数量
				D('User')->inc_praise($answeruid);//更新会员点赞总数
				D('UserTrack')->add_track($uid,$qid,4,$rid);//写入个人动态
				$ajax['status']  = 1;
				$ajax['content'] = $praise;
				$this->ajaxReturn($ajax);
				}
				else
				{
					$ajax['status']  = 0;
					$ajax['content'] = "你已经赞过了！";
					$this->ajaxReturn($ajax);
				}
		 } 
	}
//追加悬赏
public function ajax_supp_gold()
	{
		if (IS_AJAX){
			$uid=session('uu.uid');
			$qid= I('request.qid','','intval');
			$gold= I('request.gold','','intval');
			if (empty($uid) || empty($qid) || empty($gold))
			 {
				$ajax['status']  = 0;
				$ajax['content'] = "参数错误";
				$this->ajaxReturn($ajax);
			 }
			 $user=D('User')->get_user_one($uid);
			 if ($gold>$user['gold'])
			 {
			 	$ajax['status']  = 0;
				$ajax['content'] = C('UU_GOLD_BYNAME')."不够了";
				$this->ajaxReturn($ajax);
			 }
			 else
			 {
			 	D('Question')->edit_reward($qid,$gold);//修改问题悬赏数
				D('User')->edit_user_gold(1,$uid,$gold,'追加悬赏扣除',false);//变更积分并且记录日志
			 	$ajax['status']  = 1;
				$ajax['content'] = "操作成功！";
				$this->ajaxReturn($ajax);
			 }
			  
			 
		 } 
}

//采纳答案	
public function ajax_adoption_reply()
{	
			$uid=session('uu.uid');
			$rid= I('request.rid','','intval');
			$qid= I('request.qid','0','intval');
			$question=D('Question')->get_question_one($qid,$uid);
			if (empty($question))
			{
				$ajax['status']  = 0;
				$ajax['content'] = "数据错误！".$qid.'+'.$uid;
				$this->ajaxReturn($ajax);
			}
			else//结算积分
			{
				$answer=D('Answer')->get_answer_one_id($rid);
				$t=D('Task');
				$t->exe_reply_adoption($answer['uid']);//采纳答案，答题人获得系统奖励
				if ($question['reward']>0)//假如有悬赏，奖励派发给回答人
				{
				D('User')->edit_user_gold(1,$answer['uid'],$question['reward'],'答案被采纳获得提问者悬赏奖励');
				}
				$t->exe_adoption_answer($uid);//采纳答案，提问人(自己)获得系统奖励
				D('Question')->set_solve($qid);//更新问题状态（改为解决状态）
				D('Answer')->set_optimal($rid);//更新回复状态（改为最佳答案）
				D('User')->update_acc_rate($answer['uid']);//更新采纳率
				$task=$t->get_task_one(12);//获取奖励规则,用于模板显示
				D('UserTrack')->add_track($uid,$qid,9,$rid);//写入个人动态
				$this->assign('gold',$task['gold']);
				$this->assign('exp',$task['exp']);
				$u=D('User')->get_user_one($answer['uid']);
				$this->assign('username',$u['username']);
				$html = $this->fetch('Ajax:ajax_adopt_answer');
				$ajax['status']  = 1;
				$ajax['content'] =$html;
				$SMSopen=C('UU_SMS_OPEN');
				if ($SMSopen && !empty($u['mobile']))
				{
					$params['sitename']=C('UU_SITE_NAME');
					send_sms($u['mobile'],$params,'answer_optimal');
				}
				$this->ajaxReturn($ajax);
				
			}
			
	 
}
 
}
?>