<?php
// 检测环境是否支持
function check_install_err()
{
	$check_env=check_env();
	$check_dirfile=check_dirfile();
	$check_func=check_func();
	if ($check_env['err']==1 || $check_dirfile['err']==1 || $check_func['err']==1)
	{
	return true;
	}
	return false;
}

/**
 * 系统环境检测
 * @return array 系统环境数据
 */
function check_env() {
	$return['err']=0;
    $items = array(
        'os'      => array('操作系统', '', '不限制', PHP_OS, 'success'),
        'php'     => array('PHP版本', '5.3', '5.3+', PHP_VERSION, 'success'),
        'upload'  => array('附件上传', '', '2M+', '未知', 'success'),
        'gd'     => array('GD库', '2.0', '2.0+', '未知', 'success'),
        'service' => array('服务器解译引擎', '', 'Apache/IIS/Nginx', '未知', 'success'),
        //'disk'   => array('磁盘空间', '5M', '不限制', '未知', 'success'),
    );
    //PHP环境检测
    if ($items['php'][3] < $items['php'][1]) {
        $items['php'][4] = 'error';
		$return['err']=1;
    }
    //附件上传检测
    if (@ini_get('file_uploads')) {
        $items['upload'][3] = ini_get('upload_max_filesize');
    }
    //GD库检测
    $tmp = function_exists('gd_info') ? gd_info() : array();
    if (empty($tmp['GD Version'])) {
        $items['gd'][3] = '未安装';
        $items['gd'][4] = 'error';
        $return['err']=1;
    } else {
        $items['gd'][3] = $tmp['GD Version'];
    }

    //磁盘空间检测
    /*if (function_exists('disk_free_space')) {
        $items['disk'][3] = floor(disk_free_space(INSTALL_APP_PATH) / (1024 * 1024)) . 'M';
    }*/
    //服务器解译引擎
    $items['service'][3] = $_SERVER['SERVER_SOFTWARE'];
	$return['list']=$items;
    return $return;
}

/**
 * 目录，文件读写检测
 * @return array 检测数据
 */
function check_dirfile() {
    $status = '<span style="color:green;">√可写</span>';
    $items = array(
        array('dir', $status, 'success', './runtime'),
        array('dir', $status, 'success', './data'),
        array('dir', $status, 'success', './data/database'),
		array('dir', $status, 'success', './data/images'),
		array('dir', $status, 'success', './data/images/article'),
		array('dir', $status, 'success', './data/images/avatar'),
		array('dir', $status, 'success', './data/images/category'),
		array('dir', $status, 'success', './data/images/question'),
		array('dir', $status, 'success', './data/images/tag'),
		array('dir', $status, 'success', './data/images/task'),
        array('file', $status, 'success', './apps/Common/Conf/db.php'),
        array('file', $status, 'success', './apps/Common/Conf/uu.php'),
        array('file', $status, 'success', './apps/Common/Conf/version.php'),
		array('file', $status, 'success', './apps/home/Conf/url.php'),
    );
	$return['err']=0;
    foreach ($items as &$val) {
        $item =   $val[3];
		//echo $item;
        if ('dir' == $val[0]) {
            if (!is_writable($item)) {
                if (is_dir($items)) {
                    $val[1] = '<span style="color:red;">×不可写</span>';
                    $val[2] = 'error';
                     $return['err']=1;
                } else {
                    $val[1] = '<span style="color:red;">×不存在</span>';
                    $val[2] = 'error';
                     $return['err']=1;
                }
            }
        } else {
            if (file_exists($item)) {
                if (!is_writable($item)) {
                    $val[1] = '<span style="color:red;">×不可写</span>';
                    $val[2] = 'error';
                    $return['err']=1;
                }
            } else {
                if (!is_writable(dirname($item))) {
                    $val[1] = '<span style="color:red;">×不存在</span>';
                    $val[2] = 'error';
                     $return['err']=1;
                }
            }
        }
    }
	$return['list']=$items;
    return $return;
}

/**
 * 函数检测
 * @return array 检测数据
 */
function check_func() {
	$return['err']=0;
    $status = '<span style="color:green;">√支持</span>';
    $items = array(
        array('pdo', $status, 'success', '类'),
        array('pdo_mysql', $status, 'success', '模块'),
        array('file_get_contents', $status, 'success', '函数'),
        array('mbstring', $status, 'success', '模块'),
    );
    foreach ($items as &$val) {
        if (('类' == $val[3] && !class_exists($val[0]))
            || ('模块' == $val[3] && !extension_loaded($val[0]))
            || ('函数' == $val[3] && !function_exists($val[0]))
        ) {
            $val[1] = '<span style="color:red;">×不支持</span>';
            $val[2] = 'error';
           $return['err']=1;
        }
    }
	$return['list']=$items;
    return $return;
}

function  installing_javascript($txt='')
{
	
		$html ="";
		$html.= "<script type=\"text/javascript\">\n";
		$html.= "$('#installing').append('<p>{$txt}</p>');\n";
		$html.= "var div = document.getElementById('installing');";
		$html.= "div.scrollTop = div.scrollHeight;";
		$html.= "</script>";
		echo $html;
		ob_flush();
		flush();
		usleep(200000);
}
 
?>