DROP TABLE IF EXISTS `uu_admin_menu`;
CREATE TABLE `uu_admin_menu` (
  `m_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `m_pid` int(10) NOT NULL DEFAULT '0',
  `m_title` varchar(30) NOT NULL,
  `m_act` varchar(30) NOT NULL,
  `m_fun` varchar(30) NOT NULL,
  `m_target` varchar(30) NOT NULL DEFAULT 'mainFrame',
  `m_sort` int(10) NOT NULL DEFAULT '50',
  `m_img` varchar(10) NOT NULL,
  `m_display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`m_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_admin_menu||-_-||

DROP TABLE IF EXISTS `uu_answer`;
CREATE TABLE `uu_answer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `qid` int(11) unsigned NOT NULL,
  `addtime` int(10) unsigned NOT NULL,
  `praise` int(11) unsigned NOT NULL DEFAULT '0',
  `optimal` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `content` varchar(1000) NOT NULL,
  `click` int(11) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_answer||-_-||

DROP TABLE IF EXISTS `uu_answer_praise`;
CREATE TABLE `uu_answer_praise` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(11) unsigned NOT NULL,
  `uid` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `aid_uid` (`aid`,`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_answer_praise||-_-||

DROP TABLE IF EXISTS `uu_answer_reply`;
CREATE TABLE `uu_answer_reply` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `uid` int(11) unsigned NOT NULL,
  `rid` int(11) unsigned NOT NULL,
  `addtime` int(10) unsigned NOT NULL,
  `content` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `rid` (`rid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_answer_reply||-_-||

DROP TABLE IF EXISTS `uu_article`;
CREATE TABLE `uu_article` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `category1` smallint(5) NOT NULL,
  `category2` smallint(5) unsigned NOT NULL,
  `img` varchar(60) NOT NULL,
  `title` varchar(120) NOT NULL,
  `content` text NOT NULL,
  `addtime` int(10) unsigned NOT NULL,
  `click` int(11) unsigned NOT NULL,
  `audit` tinyint(1) NOT NULL DEFAULT '0',
  `excellent` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `praise` int(11) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `click` (`click`),
  KEY `excellent` (`excellent`,`id`),
  KEY `cat_id` (`category1`,`id`),
  KEY `cat_click` (`category1`,`click`),
  KEY `cat_exc_id` (`category1`,`excellent`,`id`),
  KEY `addtime` (`addtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_article||-_-||

DROP TABLE IF EXISTS `uu_article_praise`;
CREATE TABLE `uu_article_praise` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `aid` int(11) unsigned NOT NULL,
  `uid` int(11) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `aid_uid` (`aid`,`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_article_praise||-_-||

DROP TABLE IF EXISTS `uu_article_tag`;
CREATE TABLE `uu_article_tag` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `aid` int(10) unsigned NOT NULL,
  `tagid` int(11) unsigned NOT NULL,
  `tag` varchar(30) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `tag_id` (`tagid`,`id`),
  KEY `aid` (`aid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_article_tag||-_-||

DROP TABLE IF EXISTS `uu_category`;
CREATE TABLE `uu_category` (
  `c_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `c_type` smallint(5) unsigned NOT NULL,
  `c_pid` int(10) NOT NULL DEFAULT '0',
  `c_title` varchar(30) NOT NULL,
  `c_sort` int(10) NOT NULL DEFAULT '50',
  `c_pic` varchar(30) NOT NULL,
  PRIMARY KEY (`c_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_category||-_-||

DROP TABLE IF EXISTS `uu_config`;
CREATE TABLE `uu_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8 COLLATE utf8_bin NOT NULL,
  `value` text NOT NULL,
  `note` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_config||-_-||

DROP TABLE IF EXISTS `uu_follow_question`;
CREATE TABLE `uu_follow_question` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `qid` int(11) unsigned NOT NULL,
  `addtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`,`qid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_follow_question||-_-||

DROP TABLE IF EXISTS `uu_follow_tag`;
CREATE TABLE `uu_follow_tag` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `tid` int(11) unsigned NOT NULL,
  `addtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`,`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
||-_-||uu_follow_tag||-_-||

DROP TABLE IF EXISTS `uu_follow_user`;
CREATE TABLE `uu_follow_user` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `yuid` int(11) unsigned NOT NULL,
  `addtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `yuid` (`yuid`),
  KEY `uid` (`uid`,`yuid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_follow_user||-_-||

DROP TABLE IF EXISTS `uu_intro`;
CREATE TABLE `uu_intro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `alias` varchar(30) NOT NULL,
  `title` varchar(100) NOT NULL,
  `content` mediumtext NOT NULL,
  `tit_color` varchar(10) DEFAULT NULL,
  `tit_b` tinyint(1) NOT NULL DEFAULT '0',
  `is_display` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `is_url` varchar(200) NOT NULL DEFAULT '0',
  `seo_keywords` varchar(100) DEFAULT NULL,
  `seo_description` varchar(200) DEFAULT NULL,
  `click` int(11) NOT NULL DEFAULT '1',
  `addtime` int(10) NOT NULL,
  `sort` smallint(5) NOT NULL DEFAULT '0',
  `username` varchar(60) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sort_id` (`sort`,`id`),
  KEY `alias` (`alias`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_intro||-_-||

DROP TABLE IF EXISTS `uu_link`;
CREATE TABLE `uu_link` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `is_display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `link_name` varchar(255) NOT NULL,
  `link_url` varchar(255) NOT NULL,
  `link_logo` varchar(255) NOT NULL,
  `sort` smallint(5) unsigned NOT NULL DEFAULT '50',
  `notes` varchar(255) DEFAULT NULL,
  `addtime` int(10) unsigned NOT NULL,
  `username` varchar(60) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `show_order` (`sort`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_link||-_-||

DROP TABLE IF EXISTS `uu_log_gold`;
CREATE TABLE `uu_log_gold` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL,
  `uid` int(10) unsigned NOT NULL,
  `gold` int(10) NOT NULL,
  `exp` int(10) NOT NULL,
  `addtime` int(10) unsigned NOT NULL,
  `txt` varchar(60) NOT NULL,
  `entrance` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `type_uid_id` (`type`,`uid`,`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_log_gold||-_-||

DROP TABLE IF EXISTS `uu_log_login`;
CREATE TABLE `uu_log_login` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `login_time` int(10) unsigned NOT NULL,
  `login_ip` varchar(30) NOT NULL,
  `login_address` varchar(30) NOT NULL,
  `warning` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `entrance` tinyint(1) unsigned DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `uid_id` (`uid`,`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_log_login||-_-||

DROP TABLE IF EXISTS `uu_log_task`;
CREATE TABLE `uu_log_task` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `uid` int(10) NOT NULL,
  `tid` int(10) NOT NULL,
  `addtime` int(11) NOT NULL,
  `entrance` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `uid_tid` (`uid`,`tid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_log_task||-_-||

DROP TABLE IF EXISTS `uu_lv`;
CREATE TABLE `uu_lv` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `lv_id` int(10) NOT NULL,
  `exp_min` int(11) NOT NULL,
  `exp_max` int(10) NOT NULL,
  `name` varchar(60) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_lv||-_-||

DROP TABLE IF EXISTS `uu_msg`;
CREATE TABLE `uu_msg` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `systype` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `receiver` tinyint(1) NOT NULL DEFAULT '1',
  `receiver_by` text NOT NULL,
  `msg` text NOT NULL,
  `addtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `systype` (`systype`,`receiver`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_msg||-_-||

DROP TABLE IF EXISTS `uu_nav`;
CREATE TABLE `uu_nav` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `pagealias` varchar(30) NOT NULL,
  `title` varchar(30) DEFAULT '',
  `url` varchar(60) DEFAULT '',
  `act` varchar(30) DEFAULT '',
  `fun` varchar(30) DEFAULT '',
  `target` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `sort` int(10) unsigned NOT NULL DEFAULT '50',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_nav||-_-||

DROP TABLE IF EXISTS `uu_notice`;
CREATE TABLE `uu_notice` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `title` varchar(100) NOT NULL,
  `content` mediumtext NOT NULL,
  `tit_color` varchar(10) DEFAULT NULL,
  `tit_b` tinyint(1) NOT NULL DEFAULT '0',
  `is_display` tinyint(3) unsigned NOT NULL DEFAULT '1',
  `is_url` varchar(200) NOT NULL DEFAULT '0',
  `seo_keywords` varchar(100) DEFAULT NULL,
  `seo_description` varchar(200) DEFAULT NULL,
  `click` int(11) NOT NULL DEFAULT '1',
  `addtime` int(10) NOT NULL,
  `sort` smallint(5) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sort_id` (`sort`,`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_notice||-_-||

DROP TABLE IF EXISTS `uu_oauth`;
CREATE TABLE `uu_oauth` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `alias` varchar(20) NOT NULL,
  `name` varchar(30) NOT NULL,
  `config` varchar(255) NOT NULL,
  `sort` int(10) NOT NULL,
  `is_display` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_oauth||-_-||

DROP TABLE IF EXISTS `uu_question`;
CREATE TABLE `uu_question` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `category1` smallint(5) unsigned NOT NULL,
  `category2` smallint(5) unsigned NOT NULL DEFAULT '0',
  `title` varchar(100) NOT NULL,
  `describe` varchar(2000) DEFAULT NULL,
  `reward` int(10) unsigned NOT NULL DEFAULT '0',
  `address` varchar(60) DEFAULT NULL,
  `map` varchar(30) DEFAULT NULL,
  `sms_remind` tinyint(1) NOT NULL DEFAULT '0',
  `anonymous` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `click` int(10) unsigned NOT NULL DEFAULT '0',
  `addtime` int(10) unsigned NOT NULL,
  `answeruid` int(10) unsigned NOT NULL DEFAULT '0',
  `answertime` int(10) unsigned NOT NULL DEFAULT '0',
  `answercount` int(10) unsigned NOT NULL DEFAULT '0',
  `issolve` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否解决',
  `audit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `audit_cat1_cat2_id` (`audit`,`category1`,`category2`,`id`),
  KEY `uid` (`uid`),
  KEY `audit_cat1_id` (`audit`,`category1`,`id`),
  KEY `audit_issolve_id` (`audit`,`issolve`,`id`),
  KEY `audit_reward_id` (`audit`,`reward`,`id`),
  KEY `audit_answercount_id` (`audit`,`answercount`,`id`),
  KEY `audit_cat1_issolve_id` (`audit`,`category1`,`issolve`,`id`),
  KEY `audit_cat1_reward_id` (`audit`,`category1`,`reward`,`id`),
  KEY `audit_cat1_answercount_id` (`audit`,`category1`,`anonymous`,`id`),
  KEY `audit_cat1_cat2_issolve_id` (`audit`,`category1`,`category2`,`issolve`,`id`),
  KEY `audit_cat1_cat2_reward_id` (`audit`,`category1`,`category2`,`reward`,`id`),
  KEY `audit_cat1_cat2_answercount_id` (`audit`,`category1`,`category2`,`anonymous`,`id`),
  KEY `audit_id` (`audit`,`id`),
  KEY `addtime` (`addtime`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_question||-_-||

DROP TABLE IF EXISTS `uu_question_img`;
CREATE TABLE `uu_question_img` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `qid` int(10) unsigned NOT NULL,
  `img` varchar(60) NOT NULL,
  `addtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_question_img||-_-||

DROP TABLE IF EXISTS `uu_question_supp`;
CREATE TABLE `uu_question_supp` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `qid` int(11) unsigned NOT NULL,
  `uid` int(11) unsigned NOT NULL,
  `content` varchar(1000) NOT NULL,
  `addtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_question_supp||-_-||

DROP TABLE IF EXISTS `uu_question_tag`;
CREATE TABLE `uu_question_tag` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `qid` int(10) unsigned NOT NULL,
  `tagid` int(11) unsigned NOT NULL,
  `tag` varchar(30) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `qid` (`qid`),
  KEY `tag_id` (`tagid`,`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_question_tag||-_-||

DROP TABLE IF EXISTS `uu_seo`;
CREATE TABLE `uu_seo` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `alias` varchar(30) NOT NULL,
  `title` varchar(300) NOT NULL,
  `keywords` varchar(300) NOT NULL,
  `description` varchar(300) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_seo||-_-||

DROP TABLE IF EXISTS `uu_sms_tpl`;
CREATE TABLE `uu_sms_tpl` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(30) NOT NULL,
  `tpl` varchar(160) NOT NULL,
  `alias` varchar(30) NOT NULL,
  `tplid` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_sms_tpl||-_-||

DROP TABLE IF EXISTS `uu_tag`;
CREATE TABLE `uu_tag` (
  `id` tinyint(11) unsigned NOT NULL AUTO_INCREMENT,
  `cat` int(10) unsigned NOT NULL DEFAULT '0',
  `tag` varchar(15) NOT NULL,
  `img` varchar(30) NOT NULL,
  `describe` varchar(200) NOT NULL,
  `count_question` int(11) NOT NULL DEFAULT '0',
  `count_article` int(11) NOT NULL DEFAULT '0',
  `sort` int(11) NOT NULL DEFAULT '50',
  `addtime` int(10) NOT NULL,
  `audit` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `count_question` (`sort`,`count_question`),
  KEY `addtime` (`audit`,`addtime`),
  KEY `tag` (`tag`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_tag||-_-||

DROP TABLE IF EXISTS `uu_tag_cat`;
CREATE TABLE `uu_tag_cat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(20) NOT NULL,
  `sort` int(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_tag_cat||-_-||

DROP TABLE IF EXISTS `uu_task`;
CREATE TABLE `uu_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `name` varchar(30) NOT NULL,
  `gold` int(10) NOT NULL DEFAULT '1',
  `exp` int(10) NOT NULL DEFAULT '1',
  `sort` int(10) NOT NULL DEFAULT '50',
  `is_display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_task||-_-||

DROP TABLE IF EXISTS `uu_url`;
CREATE TABLE `uu_url` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `alias` varchar(60) NOT NULL,
  `locator` varchar(60) NOT NULL,
  `rule_key` varchar(60) NOT NULL,
  `rule_var` varchar(60) NOT NULL,
  `is_display` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_url||-_-||

DROP TABLE IF EXISTS `uu_user`;
CREATE TABLE `uu_user` (
  `uid` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(60) NOT NULL DEFAULT '',
  `mobile` varchar(11) NOT NULL,
  `password` varchar(100) NOT NULL DEFAULT '',
  `pwd_hash` varchar(30) NOT NULL,
  `gold` int(10) unsigned NOT NULL,
  `exp` int(10) unsigned NOT NULL,
  `exp_lv` smallint(5) unsigned NOT NULL DEFAULT '1',
  `acc_rate` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '采纳率',
  `avatar` varchar(30) NOT NULL,
  `specialty` varchar(60) NOT NULL,
  `count_question` int(11) unsigned NOT NULL DEFAULT '0',
  `count_answer` int(11) unsigned NOT NULL DEFAULT '0',
  `count_article` int(11) unsigned NOT NULL DEFAULT '0',
  `count_praise` int(11) unsigned NOT NULL DEFAULT '1',
  `reg_time` int(10) unsigned NOT NULL,
  `reg_ip` varchar(15) NOT NULL,
  `reg_address` varchar(30) NOT NULL,
  `last_login_time` int(10) unsigned NOT NULL,
  `last_login_ip` varchar(15) NOT NULL,
  `last_login_address` varchar(30) NOT NULL,
  `click` int(11) unsigned NOT NULL DEFAULT '1',
  `isadmin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `auth` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`uid`),
  UNIQUE KEY `username` (`username`),
  KEY `mobile` (`mobile`),
  KEY `isadmin` (`isadmin`),
  KEY `reg_time` (`reg_time`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_user||-_-||

DROP TABLE IF EXISTS `uu_user_ban`;
CREATE TABLE `uu_user_ban` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `addtime` int(10) unsigned NOT NULL,
  `endtime` int(10) NOT NULL,
  `txt` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_user_ban||-_-||

DROP TABLE IF EXISTS `uu_user_bind`;
CREATE TABLE `uu_user_bind` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL,
  `type` varchar(60) NOT NULL,
  `keyid` varchar(100) NOT NULL,
  `bindingtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `keyid` (`keyid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
||-_-||uu_user_bind||-_-||

DROP TABLE IF EXISTS `uu_user_favorites`;
CREATE TABLE `uu_user_favorites` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `objid` int(11) unsigned NOT NULL,
  `addtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`),
  KEY `objid_type` (`objid`,`type`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_user_favorites||-_-||

DROP TABLE IF EXISTS `uu_user_msg`;
CREATE TABLE `uu_user_msg` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `msg_id` int(11) unsigned NOT NULL,
  `send_uid` int(11) unsigned NOT NULL,
  `to_uid` int(11) unsigned NOT NULL,
  `addtime` int(11) unsigned NOT NULL,
  `msg` text NOT NULL,
  `read` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `to_uid` (`to_uid`),
  KEY `send_uid` (`send_uid`),
  KEY `msg_id` (`msg_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_user_msg||-_-||

DROP TABLE IF EXISTS `uu_user_pms`;
CREATE TABLE `uu_user_pms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `alias` varchar(30) NOT NULL,
  `send_uid` int(11) unsigned NOT NULL,
  `to_uid` int(11) unsigned NOT NULL,
  `send_read` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `to_read` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `send_display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `to_display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `send_uid` (`send_uid`),
  KEY `to_uid` (`to_uid`),
  KEY `alias` (`alias`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_user_pms||-_-||

DROP TABLE IF EXISTS `uu_user_pms_chat`;
CREATE TABLE `uu_user_pms_chat` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pid` int(11) unsigned NOT NULL,
  `send_uid` int(11) unsigned NOT NULL,
  `to_uid` int(11) NOT NULL,
  `msg` text NOT NULL,
  `addtime` int(10) NOT NULL,
  `send_display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `to_display` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`,`send_uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_user_pms_chat||-_-||

DROP TABLE IF EXISTS `uu_user_track`;
CREATE TABLE `uu_user_track` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) unsigned NOT NULL DEFAULT '0',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `objid` int(11) unsigned NOT NULL DEFAULT '0',
  `aid` int(11) unsigned NOT NULL DEFAULT '0',
  `addtime` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;
||-_-||uu_user_track||-_-|| 
