<?php
/**
 * @author wonli <wonli@live.com>
 */
require __DIR__ . '/../src/crossboot.php';
$app = Cross\Core\Delegate::loadApp('install');
if (file_exists(__DIR__ . '/install.lock')) {
    $app->get('main:installLock');
} else {
    try {
        $app->run();
    } catch (Exception $e) {
        if ($app->getRequest()->isAjaxRequest()) {
            $app->getResponse()->setContentType('json')->display(json_encode(array(
                'status' => 0,
                'message' => $e->getMessage()
            )));
        } else {
            $app->get('main:errorInfo', array('message' => $e->getMessage()));
        }
    }
}
