<?php
/**
 * @author wonli <wonli@live.com>
 * Info.php
 */


namespace app\admin\controllers;

use app\forum\modules\common\InfoModule;

/**
 * 信息管理
 *
 * Class Info
 * @package app\admin\controllers
 */
class Info extends Forum
{
    /**
     * 列表
     *
     * @throws \Cross\Exception\CoreException
     */
    function index()
    {
        $IM = new InfoModule();
        $this->data['info_list'] = $IM->getAll();

        $nail = array();
        if ($this->is_post()) {
            foreach ($_POST as $id => &$info) {
                if (isset($info['nail_footer']) && $info['nail_footer'] == 'on') {
                    $info['nail_footer'] = 1;
                    $nail[] = $info;
                }

                $IM->update($id, $info);
            }

            $IM->updateNailData();
            $this->to('info');
        }

        $this->display($this->data);
    }

    /**
     * 添加文档
     *
     * @throws \Cross\Exception\CoreException
     */
    function add()
    {
        if ($this->is_post()) {
            $IM = new InfoModule();

            if (isset($_POST['nail_footer']) && $_POST['nail_footer'] == 'on') {
                $_POST['nail_footer'] = 1;
            } else {
                $_POST['nail_footer'] = 0;
            }

            $IM->add($_POST);
            $IM->updateNailData();
            $this->to('info');
        }

        $this->display($this->data);
    }

    /**
     * 删除文档
     *
     * @cp_params id
     * @throws \Cross\Exception\CoreException
     */
    function del()
    {
        $id = $this->params['id'];
        $IM = new InfoModule();
        $IM->del($id);

        $this->to('info');
    }

    /**
     * 编辑文档
     *
     * @cp_params id
     * @throws \Cross\Exception\CoreException
     */
    function edit()
    {
        $id = $this->params['id'];

        $IM = new InfoModule();
        $info = $IM->getInfoContent($id);

        if (empty($info)) {
            $this->to('info');
        }

        if ($this->is_post()) {
            if (isset($_POST['nail_footer']) && $_POST['nail_footer'] == 'on') {
                $_POST['nail_footer'] = 1;
            } else {
                $_POST['nail_footer'] = 0;
            }

            $IM->update($id, $_POST);
            $IM->updateNailData();
            $this->to('info');
        }

        $this->data['info'] = $info;
        $this->display($this->data);
    }
}