<?php
/**
 * @author wonli <wonli@live.com>
 * Log.php
 */


namespace app\admin\controllers;

use app\admin\modules\log\ReadLogFile;
use DateTime;

/**
 * @author wonli <wonli@live.com>
 *
 * Class Log
 * @package app\admin\controllers
 */
class Log extends Forum
{
    /**
     * @var string
     */
    private $logPath;

    /**
     * Log constructor.
     * @throws \Cross\Exception\CoreException
     * @throws \ReflectionException
     */
    function __construct()
    {
        parent::__construct();
        $this->logPath = $this->getFilePath('cache::log') . DIRECTORY_SEPARATOR;
    }

    /**
     * 日志列表
     *
     * @throws \Cross\Exception\CoreException
     */
    function index()
    {
        //日志文件列表
        $logFilePrefixList = array();
        $this->data['logFiles'] = $this->getLogFiles($logFilePrefixList);

        //默认获取当日日志内容
        $fileDir = date('Y-m');
        $fileName = 'exception' . '-' . date('d') . '.log';

        $seek = 0;
        $logContent = array();
        $logFile = $this->logPath . $fileDir . DIRECTORY_SEPARATOR . $fileName;
        if (file_exists($logFile)) {
            $RLF = new ReadLogFile();
            $RLF->setBlockLimit(20);
            $RLF->setFile($logFile);
            $logContent = $RLF->read();
            $seek = $RLF->getCurrentLine();
        }

        $this->data['seek'] = $seek;
        $this->data['log_content'] = $logContent;
        $this->data['file_dir'] = $fileDir;
        $this->data['file_name'] = $fileName;
        $this->data['prefix_list'] = $logFilePrefixList;
        $this->display($this->data);
    }

    /**
     * 获取日志内容接口
     *
     * @throws \Cross\Exception\CoreException
     */
    function read()
    {
        $t1 = microtime(true);
        $key = &$_POST['key'];
        if (!empty($key)) {
            $isValidateKey = preg_match('/(\d+)\.\d+\.\d+$/', $key, $matches);
            if (!$isValidateKey) {
                $this->dieJson($this->result(-1, 'ID格式错误'));
            }

            $unixTime = strtotime($matches[1]);
            if (!$unixTime) {
                $this->dieJson($this->result(-2, '解析ID失败'));
            }

            $prefix = 'exception';
            if (!empty($_POST['prefix'])) {
                $prefix = $_POST['prefix'];
            }

            $DT = new DateTime($matches[1]);
            $fileDir = $DT->format('Y-m');
            $fileName = $prefix . '-' . $DT->format('d') . '.log';

            $emptyContent = '找不到您搜索的日志';
        } else {
            $fileDir = &$_POST['fileDir'];
            $fileName = &$_POST['fileName'];
            if (empty($fileDir) || empty($fileName)) {
                $this->dieJson($this->result(-3, '请指定要查看的日志'));
            }
            $emptyContent = '暂无日志内容';
        }

        $file = $fileDir . DIRECTORY_SEPARATOR . $fileName;
        if (!file_exists($this->logPath . $file)) {
            $this->dieJson($this->result(-4, '日志文件不存在'));
        }

        $RLF = new ReadLogFile();
        $RLF->setBlockLimit(20);

        $seek = &$_POST['seek'];
        $RLF->setSeek((int)$seek);

        $content = '';
        if (empty($file)) {
            $this->dieJson($this->result(-4, '无法完成的请求'));
        } else {
            if (file_exists($this->logPath . $file)) {
                $RLF->setFile($this->logPath . $file);
                if (!empty($key)) {
                    $RLF->search($key);
                }
                $content = $RLF->read();
            }
        }

        $data = $this->result(1, 'ok');
        $data['fileDir'] = $fileDir;
        $data['fileName'] = $fileName;

        if (!empty($content)) {
            $contentString = '';
            if (is_array($content)) {
                foreach ($content as $d) {
                    $d = trim($d);
                    if (!empty($d)) {
                        $contentString .= '<pre>' . $d . '</pre>';
                    }
                }
            } else {
                $contentString = $content;
            }

            $data['seek'] = $RLF->getCurrentLine();
            $data['content'] = $contentString;
        } else {
            $data['status'] = 2;
            $data['message'] = '没有内容 ╮（╯＿╰）╭';
            $data['content'] = $emptyContent;
        }

        $data['t'] = microtime(true) - $t1;
        $this->dieJson($data);
    }

    /**
     * 获取日志文件列表
     *
     * @param array $logFilePrefixList
     * @return array
     */
    private function getLogFiles(&$logFilePrefixList = array())
    {
        $treeData = $this->makeLogDirTreeData($this->logPath, '', $logFilePrefixList);
        $treeData = array_filter($treeData);
        if (!empty($treeData)) {
            //排序
            usort($treeData, function ($a, $b) {
                return $a['text'] < $b['text'];
            });

            //展开
            if (!empty($treeData[0])) {
                $treeData[0]['state']['expanded'] = true;
            }
        }

        return $treeData;
    }

    /**
     * 生成日志文件树
     *
     * @param string $pathName
     * @param string $p
     * @param array $prefixList
     * @return array
     */
    private function makeLogDirTreeData($pathName, $p = '', &$prefixList = array())
    {
        $result = array();
        if (!is_dir($pathName) || !is_readable($pathName)) {
            return $result;
        }

        $allFiles = scandir($pathName);
        foreach ($allFiles as $fileName) {
            if (in_array($fileName, array('.', '..'))) {
                continue;
            }

            $file_real_path = $pathName . $fileName;
            if (is_dir($file_real_path)) {
                $result[] = $this->makeLogDirTreeData($file_real_path, $fileName, $prefixList);
            } else {
                if (false !== strpos($fileName, '-')) {
                    list($prefix,) = explode('-', $fileName);
                    $prefixList[$prefix] = $prefix;
                }

                $result['text'] = $p;
                $result['selectable'] = false;
                $result['state'] = array('expanded' => false);
                $result['nodes'][] = array(
                    'text' => $fileName,
                    'p' => $p,
                );
            }
        }


        return $result;
    }
}