<?php
/**
 * @author wonli <wonli@live.com>
 * Settings.php
 */

namespace app\admin\controllers;

use app\admin\modules\config\manager\BlackHoleManager;
use app\admin\modules\config\manager\FileCacheConfigManager;
use app\admin\modules\config\manager\BanIPManager;
use app\admin\modules\config\manager\ModeManager;
use app\admin\modules\config\manager\NavMenuManager;
use app\admin\modules\config\manager\OauthManager;
use app\admin\modules\config\manager\SiteManager;
use app\admin\modules\config\ConfigManager;
use app\forum\modules\friendsLink\FriendsLinkModule;
use app\forum\modules\invite\InviteModule;
use app\forum\modules\common\SeoModule;

/**
 * 设置
 *
 * @author wonli <wonli@live.com>
 * Class Settings
 * @package app\admin\controllers
 */
class Settings extends Forum
{
    /**
     * @cp_params t=site
     * @throws \Cross\Exception\CoreException
     */
    function index()
    {
        $t = &$this->params['t'];
        $settingConfig = array(
            'site' => '基本信息',
            'oauth' => '第三方登录',
            'statistics' => '统计代码',
            'banIP' => 'IP屏蔽',
            'agreement' => '注册协议',
            'mode' => '话题模块设置',
            'nav' => '导航菜单',
        );

        if (!isset($settingConfig[$t])) {
            $this->to('settings:index');
        }

        switch ($t) {
            case 'site':
                $manager = new SiteManager();
                break;
            case 'mode':
                $manager = new ModeManager();
                break;
            case 'oauth':
                $manager = new OauthManager();
                break;
            case 'banIP':
                $manager = new BanIPManager();
                break;
            case 'statistics':
                $manager = new FileCacheConfigManager();
                $manager->setCacheFile($this->getFilePath('config::statistics_code'));
                $manager->setDataName('statistics_code');
                break;
            case 'agreement':
                $manager = new FileCacheConfigManager();
                $manager->setCacheFile($this->getFilePath('config::agreement'));
                $manager->setDataName('agreement');
                break;
            case 'nav':
                $manager = new NavMenuManager();
                break;

            default:
                $manager = new BlackHoleManager();
        }

        $CM = new ConfigManager($manager);
        if ($this->is_post()) {
            $CM->save($_POST);
            $this->to('settings:index', $this->params);
        } else {
            $data = $CM->get($this->siteConfig);
            if (!empty($data)) {
                $this->data = array_merge($this->data, $data);
            }
        }

        $this->data['settingConfig'] = $settingConfig;
        $this->display($this->data);
    }

    /**
     * seo
     *
     * @cp_params category
     * @throws \Cross\Exception\CoreException
     */
    function seo()
    {
        $SM = new SeoModule();
        $seoConfig = $SM->getSeoConfig();

        $current = array();
        $controllerNameList = array();
        $category = $this->params['category'];
        foreach ($seoConfig as $config) {
            if (empty($category)) {
                $category = $config['controller'];
            }

            if ($category == $config['controller']) {
                $current = $config;
            }

            $controllerNameList[$config['controller']] = $config['name'];
        }

        if ($this->is_post()) {
            $id = &$_POST['id'];
            if ($id) {
                unset($_POST['id']);
                $SM->updateSeoConfig($id, $_POST);
            }

            $this->to('settings:seo');
        }

        $this->data['current'] = $current;
        $this->data['category'] = $category;
        $this->data['all_config'] = $seoConfig;
        $this->data['controller_list'] = $controllerNameList;
        $this->display($this->data);
    }

    /**
     * 邀请码管理
     *
     * @throws \Cross\Exception\CoreException
     */
    function inviteCode()
    {
        $IM = new InviteModule();
        $inviteCodeList = $IM->getAllInviteCode();

        if ($this->is_post()) {
            foreach ($_POST as $id => $config) {
                $data['comments'] = htmlentities(strip_tags($config['comments']), ENT_COMPAT, 'utf-8');
                if (isset($config['status']) && strcasecmp($config['status'], 'on') == 0) {
                    $data['status'] = 1;
                } else {
                    $data['status'] = 0;
                }
                $IM->updateInviteInfo($id, $data);
            }

            $this->to('settings:inviteCode');
        }

        $this->data['inviteCodeList'] = $inviteCodeList;
        $this->display($this->data);
    }

    /**
     * 友情连接
     *
     * @cp_params act=list, id, p=1
     * @throws \Cross\Exception\CoreException
     */
    function friendsLink()
    {
        $page = array(
            'p' => $this->params['p'],
            'limit' => 50,
        );

        $FLM = new FriendsLinkModule();
        if ($this->is_post()) {
            if (!empty($_POST['update'])) {
                foreach ($_POST['update'] as $id => $data) {
                    $data['sort'] = (int)$data['sort'];
                    if (isset($data['status'])) {
                        $data['status'] = 1;
                    } else {
                        $data['status'] = 0;
                    }

                    $FLM->update($id, $data);
                }
            }

            if (!empty($_POST['new']['site_name']) && !empty($_POST['new']['url'])) {
                $newData = &$_POST['new'];

                $newData['sort'] = (int)$newData['sort'];
                if (isset($newData['status'])) {
                    $newData['status'] = 1;
                } else {
                    $newData['status'] = 0;
                }

                $FLM->add($newData);
            }

            $this->to('settings:friendsLink');
        }

        $act = $this->params['act'];
        $id = (int)$this->params['id'];
        if ($act == 'del' && !empty($id)) {
            $FLM->del($id);
            $this->to('settings:friendsLink');
        }

        $list = $FLM->find($page);
        $this->data['list'] = $list;
        $this->data['page'] = $page;
        $this->display($this->data);
    }

    /**
     * 添加邀请码
     *
     * @throws \Cross\Exception\CoreException
     */
    function addInviteCode()
    {
        if (!$this->is_post()) {
            $this->to('settings:inviteCode');
        }

        if (!empty($_POST['invite_code'])) {
            $invite_code = &$_POST['invite_code'];
            $IM = new InviteModule();
            $ret = $IM->checkInviteCode($invite_code);
            if ($ret['status'] == 1) {
                $this->data['status'] = 0;
                $this->data['message'] = '该邀请码已存在~';
            } else {
                $ret = $IM->createInviteCode($invite_code, $_POST['comments']);
                if ($ret) {
                    $this->data['status'] = 1;
                } else {
                    $this->data['status'] = 0;
                    $this->data['message'] = '添加邀请码失败, 请联系管理员';
                }
            }
            $this->display($this->data, 'JSON');
        }
    }

    /**
     * 删除邀请码
     *
     * @cp_params id
     * @throws \Cross\Exception\CoreException
     */
    function delInviteCode()
    {
        $id = (int)$this->params['id'];
        $IM = new InviteModule();
        $IM->deleteInviteCode($id);
        $this->to('settings:inviteCode');
    }

    /**
     * 邀请码状态切换
     *
     * @cp_params id
     * @throws \Cross\Exception\CoreException
     */
    function changeInviteCodeStatus()
    {
        $id = (int)$this->params['id'];
        $IM = new InviteModule();
        $inviteInfo = $IM->getInviteInfo($id);
        if ($inviteInfo) {
            $status = $inviteInfo['status'];
            if ($status == 1) {
                $data = array('status' => 0);
            } else {
                $data = array('status' => 1);
            }
            $IM->updateInviteInfo($id, $data);
        }
        $this->to('settings:inviteCode');
    }

    /**
     * 更新SEO信息
     *
     * @throws \Cross\Exception\CoreException
     */
    function updateSeoConfig()
    {
        $SM = new SeoModule();
        $seoConfig = $SM->getSeoConfig();

        $this->data['config'] = $this->addslashes($seoConfig);
        $this->display($this->data);
        $this->to('settings:seo');
    }

    /**
     * 处理需转义字符
     *
     * @param array $data
     * @return array
     */
    private function addslashes(array &$data)
    {
        foreach ($data as &$p) {
            if (is_array($p)) {
                $p = array_map('addslashes', $p);
            } else {
                $p = addslashes($p);
            }
        }

        return $data;
    }
}
