<?php
/**
 * @author wonli <wonli@live.com>
 * ConfigAbstract.php
 */


namespace app\admin\modules\config;

use app\forum\modules\common\ConfigModule;

/**
 * @author wonli <wonli@live.com>
 *
 * Class ConfigBase
 * @package app\admin\modules\config
 */
abstract class ConfigAbstract implements InterfaceConfigManager
{
    /**
     * 分组名
     *
     * @var mixed
     */
    protected $groupName;

    /**
     * @var ConfigModule
     */
    protected $CONFIG;

    /**
     * ConfigBase constructor.
     *
     * @throws \Cross\Exception\CoreException
     */
    function __construct()
    {
        $this->CONFIG = new ConfigModule();
        $this->groupName = $this->getGroupName();
    }

    /**
     * 分组名称
     *
     * @return mixed
     */
    abstract function getGroupName();

    /**
     * 获取配置数据
     *
     * @param array $initConfigData
     * @return mixed
     */
    abstract function get($initConfigData = array());

    /**
     * 保存配置数据
     *
     * @param array|string $data
     * @return mixed
     */
    abstract function save($data);
}