<?php
/**
 * @author wonli <wonli@live.com>
 * ConfigManager.php
 */


namespace app\admin\modules\config;


/**
 * @author wonli <wonli@live.com>
 *
 * Class ConfigManager
 * @package app\admin\modules\config
 */
class ConfigManager
{
    /**
     * @var ConfigAbstract
     */
    protected $manager;

    /**
     * ConfigManager constructor.
     *
     * @param ConfigAbstract $manager
     */
    function __construct(ConfigAbstract $manager)
    {
        $this->manager = $manager;
    }

    /**
     * 附加配置
     *
     * @param array $initConfig
     * @return mixed
     */
    function get(array $initConfig)
    {
        return $this->manager->get($initConfig);
    }

    /**
     * 保存数据
     *
     * @param string|array $data
     * @return mixed
     */
    function save($data)
    {
        return $this->manager->save($data);
    }
}