<?php
/**
 * @author wonli <wonli@live.com>
 * BanIPManager.php
 */


namespace app\admin\modules\config\manager;


use app\admin\modules\config\ConfigAbstract;

/**
 * @author wonli <wonli@live.com>
 *
 * Class BanIPManager
 * @package app\admin\modules\config\manager
 */
class BanIPManager extends ConfigAbstract
{

    /**
     * 分组名称
     *
     * @return mixed
     */
    function getGroupName()
    {
        return 'banIP';
    }

    /**
     * 获取配置数据
     *
     * @param array $initConfigData
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function get($initConfigData = array())
    {
        $banIPList = array();
        $banIPConfig = $this->CONFIG->get('banIP');
        if (!empty($banIPConfig['value'])) {
            $banIPList = explode('|', $banIPConfig['value']);
        }

        $data['banIP'] = $banIPList;
        return $data;
    }

    /**
     * 保存配置数据
     *
     * @param array|string $data
     * @return mixed
     * @throws \Cross\Exception\CoreException
     */
    function save($data)
    {
        if (!empty($data['ip'])) {
            $ip = str_replace(array("\r\n", "\r", "\n"), '|', $data['ip']);
            $ip = trim($ip, '|');
        } else {
            $ip = '';
        }

        return $this->CONFIG->saveConfig(array('banIP' => $ip), 'banIP');
    }
}