<?php
/**
 * @author wonli <wonli@live.com>
 * BlackHoleManager.php
 */


namespace app\admin\modules\config\manager;


use app\admin\modules\config\ConfigAbstract;

/**
 * 黑洞管理器, 获取和存储都为空
 * @author wonli <wonli@live.com>
 *
 * Class BlackHoleManager
 * @package app\admin\modules\config\manager
 */
class BlackHoleManager extends ConfigAbstract
{

    /**
     * 分组名称
     *
     * @return mixed
     */
    function getGroupName()
    {
        return 'blackHole';
    }

    /**
     * 获取配置数据
     *
     * @param array $initConfigData
     * @return mixed
     */
    function get($initConfigData = array())
    {
        return array();
    }

    /**
     * 保存配置数据
     *
     * @param array|string $data
     * @return mixed
     */
    function save($data)
    {
        return true;
    }
}