<?php
/**
 * @author wonli <wonli@live.com>
 * FileCacheConfigManager.php
 */


namespace app\admin\modules\config\manager;


use app\admin\modules\config\ConfigAbstract;

/**
 * 统计代码用文件保存
 * @author wonli <wonli@live.com>
 *
 * Class StatisticsManager
 * @package app\admin\modules\config\manager
 */
class FileCacheConfigManager extends ConfigAbstract
{
    /**
     * 缓存文件绝对路径
     *
     * @var string
     */
    private $cacheFile;

    /**
     * 数据名称
     *
     * @var string
     */
    private $dataName = 'data';

    /**
     * 分组名称
     *
     * @return mixed
     */
    function getGroupName()
    {
        return '';
    }

    /**
     * 获取配置数据
     *
     * @param array $initConfigData
     * @return mixed
     */
    function get($initConfigData = array())
    {
        $data[$this->dataName] = '';
        if (file_exists($this->cacheFile)) {
            $data[$this->dataName] = file_get_contents($this->cacheFile);
        }

        return $data;
    }

    /**
     * 保存配置数据
     *
     * @param array|string $data
     * @return mixed
     */
    function save($data)
    {
        return file_put_contents($this->cacheFile, trim($data[$this->dataName]), LOCK_EX);
    }

    /**
     * 设置数据名称
     *
     * @param string $name
     */
    function setDataName($name)
    {
        $this->dataName = $name;
    }

    /**
     * 设置缓存文件路径
     *
     * @param string $file
     * @return string
     */
    function setCacheFile($file)
    {
        $this->cacheFile = $file;
    }
}